/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.wrf;

import com.ibm.etools.model2.base.util.Model2ProjectPropertyUtils;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.base.wizards.IModel2RegionData;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.web.WebUtil;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.IStrutsConstants;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.FormBean;
import com.ibm.etools.struts.emf.strutsconfig.Forward;
import com.ibm.etools.struts.emf.strutsconfig.RequestScope;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigFactory;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigPackage;
import com.ibm.etools.struts.internal.util.StrutsProjectUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.strutsconfig.validator.ValidateUtil;
import com.ibm.etools.struts.util.StrutsArtifactEdit;
import com.ibm.etools.struts.util.StrutsLinksSearchUtil;
import com.ibm.etools.struts.wizards.actions.ActionDataUtil;
import com.ibm.etools.struts.wizards.actions.GenericActionRegionData;
import com.ibm.etools.struts.wizards.actions.IActionRegionData;
import com.ibm.etools.struts.wizards.actions.IStrutsActionCodeGenContrib;
import com.ibm.etools.struts.wizards.forms.ActionFormRegionData;
import com.ibm.etools.struts.wizards.forms.IActionFormRegionData;
import com.ibm.etools.struts.wizards.mappings.IActionMappingRegionData;
import com.ibm.etools.struts.wizards.wrf.CGMtoSuperclassMap;
import com.ibm.etools.struts.wizards.wrf.IStrutsRegionData;
import com.ibm.etools.struts.wizards.wrf.StrutsRegionData;
import com.ibm.etools.struts.wizards.wrf.WizardToCgmMap;
import com.ibm.etools.webtools.wizards.basic.ITypeRegionData;
import com.ibm.etools.webtools.wizards.basic.TypeWizardUtil;
import com.ibm.etools.webtools.wizards.cgen.impl.WebRegionCodeGenModel;
import com.ibm.etools.webtools.wizards.regiondata.IWTRegionData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class WizardUtils
extends com.ibm.etools.model2.base.util.WizardUtils {
    public static final String ACTION_FORWARDS = "forwards";
    public static final String ACTION_PATH = "actionMappingPath";
    public static final String ACTION_TYPE = "actionMappingType";
    public static final String ALLOW_CREATE_ACTION_CLASS = "allowCreateActionClass";
    public static final String ALLOW_CREATE_ACTION_MAPPING = "allowCreateActionMapping";
    public static final String ALLOW_CREATE_FORMBEAN_CLASS = "allowCreateFormBeanClass";
    public static final String ALLOW_CREATE_FORMBEAN_MAPPING = "allowCreateFormBeanMapping";
    public static final String BLANK_FORMBEAN_NAME = ResourceHandler.wizard_common_NoFormBean_token;
    public static final String BLANK_FORMBEAN_TYPE = "";
    public static final String BLANK_FORWARD_NAME = ResourceHandler.wizard_utils_forward_blank_name;
    public static final String BLANK_FORWARD_PATH = "./" + BLANK_FORWARD_NAME + ".jsp";
    public static final String FORMBEAN = "formBean";
    public static final String FORMBEAN_NAME = "formBeanMappingName";
    public static final String FORMBEAN_SCOPE = "formBeanMappingType";
    public static final String FORMBEAN_TYPE = "formBeanMappingType";
    protected static final String IO = "java.io";
    public static final String NO_NAME = ResourceHandler.wizard_common_NoName_token;
    public static final String NO_PATH = ResourceHandler.wizard_common_NoPath_token;
    public static final String NO_TYPE = ResourceHandler.wizard_common_NoType_token;
    protected static final String OBJECT_CLASSNAME = "java.lang.Object";
    public static final String SC = "strutsConfig";
    public static final String SCFN = "strutsConfigFileName";
    protected static final String SERVLET = "javax.servlet";
    protected static final String SERVLET_HTTP = "javax.servlet.http";
    protected static final String STRUTS = "org.apache.struts.action";
    private static final String STRUTS_CATEGORY = "StrutsPlugin";
    public static final String STRUTS_CONFIG = "strutsConfig";

    public WizardUtils(IStrutsRegionData rd, TypeWizardUtil wu) {
        super((ITypeRegionData)rd, wu);
    }

    public static boolean actionMappingListsEqual(List one, List other) {
        if (!WizardUtils.sizesEqual((Collection)one, (Collection)other)) {
            return false;
        }
        if (WizardUtils.isEmpty((Collection)one)) {
            return true;
        }
        Iterator itOne = one.iterator();
        Iterator itOther = other.iterator();
        while (itOne.hasNext() && itOther.hasNext()) {
            ActionMapping otherFb;
            ActionMapping oneFb = (ActionMapping)itOne.next();
            if (WizardUtils.actionMappingsEqual(oneFb, otherFb = (ActionMapping)itOther.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean actionMappingsEqual(ActionMapping one, ActionMapping other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        if (!Model2Util.isEqualOrBothNull((Object)one.getPath(), (Object)other.getPath())) {
            return false;
        }
        if (!Model2Util.isEqualOrBothNull((Object)one.getType(), (Object)other.getType())) {
            return false;
        }
        if (!Model2Util.isEqualOrBothNull((Object)one.getName(), (Object)other.getName())) {
            return false;
        }
        if (!WizardUtils.booleansEqual((boolean)one.isSetScope(), (boolean)other.isSetScope())) {
            return false;
        }
        return WizardUtils.requestScopesEqual(one.getScope(), other.getScope());
    }

    public static String areStubsInvalid(IStrutsRegionData srd) {
        assert (srd != null);
        if (srd.isCFS() && !srd.isDC()) {
            return ResourceHandler.wizard_common_cfsSansDc;
        }
        return null;
    }

    public static boolean areValidFormBeanParams(String name, String type) {
        return name != null && name.length() > 0 && !name.equals(BLANK_FORMBEAN_NAME) && type != null && type.length() > 0 && !type.equals(BLANK_FORMBEAN_TYPE);
    }

    public static boolean areValidForwardParams(String name, String path) {
        return name != null && name.length() > 0 && !name.equals(BLANK_FORWARD_NAME) && path != null && path.length() > 0 && !path.equals(BLANK_FORWARD_PATH);
    }

    public static WebRegionCodeGenModel cgmId2CGM(IStrutsRegionData srd, String id) {
        assert (srd != null);
        assert (id != null && id.length() > 0);
        Object[] cgms = srd.getCodeGenModels();
        if (!WizardUtils.isEmpty((Object[])cgms)) {
            int i = 0;
            while (i < cgms.length) {
                Object cgm = cgms[i];
                assert (cgm != null);
                String cgmId = cgm.getId();
                if (id.equals(cgmId)) {
                    return cgm;
                }
                ++i;
            }
        }
        return null;
    }

    public static String classname2Name(String cn) {
        return WizardUtils.classname2Name(cn, true);
    }

    public static String classname2Name(String className, boolean okToMassage) {
        String fbn = null;
        if (!WizardUtils.isEmpty((String)className)) {
            fbn = okToMassage ? WizardUtils.lcfc((String)className) : className;
        }
        if (WizardUtils.isEmpty(fbn)) {
            return BLANK_FORMBEAN_TYPE;
        }
        return fbn;
    }

    public static ActionMapping composeActionMapping(IActionRegionData ard) {
        ActionMapping am = WizardUtils.getActionMapping(ard);
        assert (am != null);
        String typename = am.getType();
        if (!com.ibm.etools.model2.base.util.WizardUtils.isValidJavaClassName((String)typename)) {
            String scn = ard.getClassname();
            typename = com.ibm.etools.model2.base.util.WizardUtils.isValidJavaClassName((String)scn) ? WizardUtils.getFQClassname(ard) : null;
        }
        return WizardUtils.composeActionMapping(ard, typename);
    }

    public static ActionMapping composeActionMapping(IActionRegionData ard, String typename) {
        ActionMapping am = WizardUtils.getActionMapping(ard);
        assert (am != null);
        String path = WizardUtils.getActionMappingPath(ard);
        am.setPath(path);
        am.setType(typename);
        EList<Forward> amForwards = am.getForwards();
        Collection ardForwards = WizardUtils.getForwards(ard);
        amForwards.clear();
        amForwards.addAll(ardForwards);
        am.setPath(path);
        am.setType(typename);
        return am;
    }

    public static FormBean composeFormBean(String name, String type, FormBean fb) {
        fb.setName(name);
        fb.setType(type);
        return fb;
    }

    public static Forward composeForward(String name, String path, Forward f) {
        f.setName(name);
        f.setPath(path);
        return f;
    }

    public static void createAndAddForward(ActionMapping am, String fn) {
        Forward nf = WizardUtils.createForward(fn);
        am.getForwards().add((Object)nf);
    }

    public static void createAndAddForward(ActionMapping am, String fn, String fp) {
        Forward nf = WizardUtils.createForward(fn, fp);
        am.getForwards().add((Object)nf);
    }

    public static void createAndAddForwards(ActionMapping am, String[] fns) {
        Forward nf = null;
        EList<Forward> forwards = am.getForwards();
        int i = 0;
        while (i < fns.length) {
            nf = WizardUtils.createForward(fns[i]);
            forwards.add(nf);
            ++i;
        }
    }

    public static FormBean createBlankFormBean() {
        return WizardUtils.createFormBeanMapping(BLANK_FORMBEAN_NAME, BLANK_FORMBEAN_TYPE);
    }

    public static Forward createBlankForward() {
        return WizardUtils.createForward(BLANK_FORWARD_NAME, BLANK_FORWARD_PATH);
    }

    public static FormBean createFormBean() {
        return WizardUtils.createFormBeanMapping();
    }

    public static FormBean createFormBeanMapping() {
        return WizardUtils.createFormBeanMapping(WizardUtils.getDefaultFormBeanName(), WizardUtils.getDefaultFormBeanType());
    }

    public static FormBean createFormBeanMapping(String name) {
        return WizardUtils.createFormBeanMapping(name, BLANK_FORMBEAN_TYPE);
    }

    public static FormBean createFormBeanMapping(String name, String type) {
        return WizardUtils.composeFormBean(name, type, StrutsconfigFactory.eINSTANCE.createFormBean());
    }

    public static Forward createForward(String name) {
        return WizardUtils.createForward(name, "./" + name + ".jsp");
    }

    public static Forward createForward(String name, String path) {
        return WizardUtils.composeForward(name, path, StrutsconfigFactory.eINSTANCE.createForward());
    }

    public static List<String> dealWithEmptyFormBeanNames(IStrutsRegionData srd) {
        List<FormBean> fbs = WizardUtils.dealWithEmptyFormBeans(srd);
        List<Object> fbns = null;
        fbns = WizardUtils.isEmpty(fbs) ? Collections.emptyList() : WizardUtils.getFormBeanNames(srd);
        srd.setFormBeanNames(fbns);
        return fbns;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<FormBean> dealWithEmptyFormBeans(IStrutsRegionData srd) {
        Object newFbs = null;
        StrutsArtifactEdit strutsArtifactEdit = null;
        try {
            try {
                IVirtualComponent component;
                strutsArtifactEdit = WizardUtils.getStrutsArtifactEdit(srd);
                if (strutsArtifactEdit == null) return newFbs;
                StrutsConfig sc = strutsArtifactEdit.getStrutsConfig();
                if (sc != null && WizardUtils.isEmpty(newFbs = sc.getFormBeans()) && (component = WizardUtils.getComponent(srd)) != null) {
                    String mn = WizardUtils.getModuleName(srd);
                    SearchScope scope = StrutsSearchUtil.getModuleScope((IProject)srd.getProject(), (String)mn, null);
                    Set formBeans = StrutsSearchUtil.getAllFormBeans((SearchScope)scope, null);
                    newFbs = new ArrayList();
                    for (ILink formbean : formBeans) {
                        FormBean o = (FormBean)StrutsLinksSearchUtil.getCorrespondingEObject(StrutsconfigPackage.eINSTANCE.getFormBean(), sc, formbean);
                        if (o == null) continue;
                        newFbs.add(o);
                    }
                }
                FormBean non = WizardUtils.createBlankFormBean();
                if (newFbs == null) {
                    newFbs = Collections.emptyList();
                } else {
                    while (newFbs.contains(non)) {
                        newFbs.remove(non);
                    }
                }
                ArrayList<FormBean> v = new ArrayList<FormBean>(newFbs.size() + 1);
                v.add(non);
                v.addAll((Collection<FormBean>)newFbs);
                newFbs = v;
                srd.setFormBeans((List<FormBean>)newFbs);
                return newFbs;
            }
            catch (Exception e) {
                StrutsPlugin.getLogger().log("EXCEPTION: ", (Throwable)e);
                ArrayList<FormBean> arrayList = new ArrayList<FormBean>();
                WizardUtils.releaseStrutsArtifactEdit(strutsArtifactEdit);
                return arrayList;
            }
        }
        finally {
            WizardUtils.releaseStrutsArtifactEdit(strutsArtifactEdit);
        }
    }

    public static boolean formBeanListsEqual(List one, List other) {
        if (!WizardUtils.sizesEqual((Collection)one, (Collection)other)) {
            return false;
        }
        if (WizardUtils.isEmpty((Collection)one)) {
            return true;
        }
        Iterator itOne = one.iterator();
        Iterator itOther = other.iterator();
        while (itOne.hasNext() && itOther.hasNext()) {
            FormBean otherFb;
            FormBean oneFb = (FormBean)itOne.next();
            if (WizardUtils.formBeansEqual(oneFb, otherFb = (FormBean)itOther.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean formBeansEqual(FormBean one, FormBean other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        if (!Model2Util.isEqualOrBothNull((Object)one.getName(), (Object)other.getName())) {
            return false;
        }
        return Model2Util.isEqualOrBothNull((Object)one.getType(), (Object)other.getType());
    }

    public static boolean forwardListsEqual(Collection one, Collection other) {
        if (!WizardUtils.sizesEqual((Collection)one, (Collection)other)) {
            return false;
        }
        if (WizardUtils.isEmpty((Collection)one)) {
            return true;
        }
        Iterator itOne = one.iterator();
        Iterator itOther = other.iterator();
        while (itOne.hasNext() && itOther.hasNext()) {
            Forward otherFb;
            Forward oneFb = (Forward)itOne.next();
            if (WizardUtils.forwardsEqual(oneFb, otherFb = (Forward)itOther.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean forwardsEqual(Forward one, Forward other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        if (!Model2Util.isEqualOrBothNull((Object)one.getName(), (Object)other.getName())) {
            return false;
        }
        if (!Model2Util.isEqualOrBothNull((Object)one.getPath(), (Object)other.getPath())) {
            return false;
        }
        return WizardUtils.booleansEqual((boolean)one.isContextRelative(), (boolean)other.isContextRelative());
    }

    public static ActionMapping getActionMapping(IActionRegionData ard) {
        ActionMapping oldAm;
        ActionMapping newAm = oldAm = ard.getActionMapping();
        if (oldAm == null) {
            newAm = WizardUtils.newActionMapping(ard);
        }
        if (newAm == null) {
            return null;
        }
        ard.setMapping(newAm);
        String pkgName = ard.getPackageName();
        String prefix = ard.getPrefix();
        if (pkgName != null && pkgName.length() != 0 && prefix != null && prefix.length() != 0) {
            newAm.setType(String.valueOf(ard.getPackageName()) + '.' + ard.getPrefix());
        }
        return newAm;
    }

    public static String getActionMappingPath(IActionRegionData ard) {
        String oldAmp;
        String newAmp = oldAmp = ard.getActionMappingPath();
        if (WizardUtils.isEmpty((String)oldAmp)) {
            ActionMapping am = WizardUtils.getActionMapping(ard);
            assert (am != null);
            newAmp = am.getPath();
        }
        if (!Model2Util.isEqualOrBothNull((Object)oldAmp, (Object)newAmp)) {
            ard.setActionMappingPath(newAmp);
        }
        return newAmp;
    }

    public static List getActionMappingPaths(IActionRegionData ard) {
        List<ActionMapping> oldAms;
        List<String> oldAmps;
        List<String> newAmps = oldAmps = ard.getActionMappingPaths();
        if (WizardUtils.isEmpty(oldAmps) && !WizardUtils.isEmpty(oldAms = ard.getActionMappings())) {
            newAmps = new Vector<String>(oldAms.size());
            for (ActionMapping am : oldAms) {
                String path = am.getPath();
                if (WizardUtils.isEmpty((String)path)) continue;
                newAmps.add(path);
            }
            assert (newAmps != null);
        }
        return newAmps;
    }

    public static List getActionMappings(IActionRegionData ard) {
        List<ActionMapping> oldAms;
        List<ActionMapping> newAms = oldAms = ard.getActionMappings();
        if (WizardUtils.isEmpty(oldAms)) {
            StrutsArtifactEdit strutsArtifactEdit = null;
            try {
                try {
                    strutsArtifactEdit = WizardUtils.getStrutsArtifactEdit(ard);
                    if (strutsArtifactEdit != null) {
                        StrutsConfig sc = strutsArtifactEdit.getStrutsConfig();
                        if (sc == null) {
                            StrutsPlugin.getLogger().log("ERROR: got null StrutsConfig from scem");
                        } else {
                            newAms = sc.getActionMappings();
                            assert (newAms != null);
                        }
                    }
                }
                catch (Exception e) {
                    StrutsPlugin.getLogger().log("EXCEPTION: ", (Throwable)e);
                    ArrayList arrayList = new ArrayList();
                    WizardUtils.releaseStrutsArtifactEdit(strutsArtifactEdit);
                    return arrayList;
                }
            }
            finally {
                WizardUtils.releaseStrutsArtifactEdit(strutsArtifactEdit);
            }
            if (!WizardUtils.actionMappingListsEqual(oldAms, newAms)) {
                ard.setActionMappings(newAms);
            }
        }
        return newAms;
    }

    public static String[] getAllFormBeanScopes(IStrutsRegionData ard) {
        return new String[]{BLANK_FORMBEAN_TYPE, "request", "session"};
    }

    public static String getBlankFormBeanName() {
        return BLANK_FORMBEAN_NAME;
    }

    public static String getBlankFormBeanScope() {
        return BLANK_FORMBEAN_TYPE;
    }

    protected static String getCategory() {
        return STRUTS_CATEGORY;
    }

    public static Set getCgmIds(IStrutsRegionData regionData) {
        WebRegionCodeGenModel[] models = regionData.getCodeGenModels();
        if (models != null) {
            HashSet<String> ids = new HashSet<String>();
            int i = 0;
            while (i < models.length) {
                WebRegionCodeGenModel model = models[i];
                String id = model.getId();
                if (!WizardUtils.isEmpty((String)id)) {
                    ids.add(id);
                }
                ++i;
            }
            return ids;
        }
        return Collections.EMPTY_SET;
    }

    public static String getClassname(IActionFormRegionData afrd) {
        return WizardUtils.getPrefix(afrd);
    }

    public static String getClassname(IActionRegionData ard) {
        return WizardUtils.getPrefix(ard);
    }

    public static String getClassname(IStrutsRegionData srd) {
        String ret = null;
        if (srd instanceof IActionRegionData) {
            ret = WizardUtils.getPrefix((IActionRegionData)srd);
        } else if (srd instanceof IActionFormRegionData) {
            ret = WizardUtils.getPrefix((IActionFormRegionData)srd);
        } else assert (false);
        return ret;
    }

    public static WebRegionCodeGenModel getCodeGenModel(IModel2RegionData ard) {
        WebRegionCodeGenModel cgm = ard.getCurrentCodeGenModel();
        if (cgm == null) {
            cgm = ard.getDefaultCodeGenModel();
            assert (cgm != null);
            ard.setCurrentCodeGenModel(cgm);
            ard.initCurrentCodeGenModelIfNecessary();
        }
        return cgm;
    }

    public static IVirtualComponent getComponent() {
        IVirtualComponent component = WizardUtils.selection2VirtualComponent((ISelection)WizardUtils.getCurrentSelection());
        if (component != null && WizardUtils.isStrutsComponent(component)) {
            return component;
        }
        IProject project = StrutsProjectUtil.getFirstStrutsProject();
        if (project != null) {
            return ComponentCore.createComponent((IProject)project);
        }
        return null;
    }

    public static IVirtualComponent getComponent(IStrutsRegionData srd) {
        IVirtualComponent ret = srd.getComponent();
        if (ret == null && (ret = WizardUtils.getComponent()) != null) {
            srd.setComponent(ret);
        }
        return ret;
    }

    public static String getDefaultActionMappingPath() {
        return IStrutsConstants.ACTION_MAPPING_DEFAULT_PATH;
    }

    public static String getDefaultActionMappingType() {
        return "Action";
    }

    public static String getDefaultFormBeanName() {
        return "form";
    }

    public static String getDefaultFormBeanScope() {
        return WizardUtils.getBlankFormBeanScope();
    }

    public static String getDefaultFormBeanScope(IStrutsRegionData ard) {
        return WizardUtils.getDefaultFormBeanScope();
    }

    public static String getDefaultFormBeanType() {
        return "Form";
    }

    public static IPackageFragment getDefaultJavaPackageFragment(IStrutsRegionData srd) {
        IVirtualComponent component = WizardUtils.getComponent(srd);
        IPackageFragmentRoot packageFragmentRoot = WizardUtils.getJavaPackageFragmentRoot((IModel2RegionData)srd);
        if (component != null && packageFragmentRoot != null) {
            String suffix;
            String moduleName;
            ArrayList<String> parts = new ArrayList<String>();
            String prefix = Model2ProjectPropertyUtils.getPackagePrefix((IProject)component.getProject());
            if (!WizardUtils.isEmpty((String)prefix)) {
                parts.add(prefix);
            }
            if (StrutsProjectCoreUtil.getStrutsVersion((IProject)component.getProject()) >= 1 && !WizardUtils.isEmpty((String)(moduleName = WizardUtils.getModuleName(srd)))) {
                if (moduleName.startsWith("/")) {
                    moduleName = moduleName.substring(1);
                }
                if (!WizardUtils.isEmpty((String)(moduleName = moduleName.replace('/', '.')))) {
                    parts.add(moduleName);
                }
            }
            if (!WizardUtils.isEmpty((String)(suffix = WizardUtils.getDefaultJavaPackageSuffix(srd)))) {
                parts.add(suffix);
            }
            if (!parts.isEmpty()) {
                String packageName = WizardUtils.dotAppend(parts);
                return packageFragmentRoot.getPackageFragment(packageName);
            }
        }
        return null;
    }

    public static String getDefaultJavaPackageFragmentName(IStrutsRegionData srd) {
        String ret = null;
        IPackageFragment pf = WizardUtils.getDefaultJavaPackageFragment(srd);
        if (pf != null) {
            ret = pf.getElementName();
        }
        return ret;
    }

    public static String getDefaultJavaPackageSuffix(IStrutsRegionData srd) {
        String ret = srd.getDefaultJavaPackageSuffix();
        if (ret == null) {
            return BLANK_FORMBEAN_TYPE;
        }
        return ret;
    }

    public static String getDefaultSuperclassName(IActionMappingRegionData amrd) {
        return WizardUtils.getDefaultSuperclassName((IActionRegionData)amrd);
    }

    public static String getDefaultSuperclassName(IActionRegionData ard) {
        assert (ard != null);
        String ret = WizardUtils.getDefaultSuperclassNameFromCGC(ard);
        return ret;
    }

    public static String getDefaultSuperclassName(IStrutsRegionData srd) {
        return srd.getDefaultSuperClassName();
    }

    public static String getDefaultSuperclassNameFromCGC(IActionRegionData ard) {
        String ret = null;
        IStrutsActionCodeGenContrib cgc = ard.getActionCodeGenContrib();
        assert (ard != null);
        ret = cgc.getDefaultSuperclassName(ard);
        return ret;
    }

    public static String getDefaultSuperClassNameFromExtension(IActionRegionData ard) {
        WebRegionCodeGenModel cgm = WizardUtils.getCodeGenModel(ard);
        return WizardUtils.getDefaultSuperClassNameFromMap(ard, cgm);
    }

    public static String getDefaultSuperClassNameFromMap(IActionRegionData ard, WebRegionCodeGenModel cgm) {
        String ret = null;
        CGMtoSuperclassMap cgm2scm = WizardUtils.getExternallyDefinedDefaultSuperclassMap(ard);
        if (!WizardUtils.isEmpty((Map)cgm2scm)) {
            String cgmId = cgm.getId();
            assert (cgmId != null && cgmId.length() > 0);
            ret = (String)cgm2scm.get(cgmId);
        }
        return ret;
    }

    public static WizardToCgmMap getExternallyDefinedDefaultCgmMap(IActionRegionData ard, String wizardId) {
        assert (ard != null);
        assert (wizardId != null && wizardId.length() > 0);
        WizardToCgmMap w2cgm = ard.getWizardToCgmMap();
        if (w2cgm == null) {
            w2cgm = new WizardToCgmMap(ard, wizardId);
            ard.setWizardToCgmMap(w2cgm);
        }
        return w2cgm;
    }

    public static CGMtoSuperclassMap getExternallyDefinedDefaultSuperclassMap(IActionRegionData ard) {
        assert (ard != null);
        CGMtoSuperclassMap cgm2scm = ard.getCGMtoSuperclassMap();
        if (cgm2scm == null) {
            cgm2scm = new CGMtoSuperclassMap(ard);
            ard.setCGMtoSuperclassMap(cgm2scm);
        }
        return cgm2scm;
    }

    public static FormBean getFormBean(IActionFormRegionData afrd) {
        FormBean oldFb;
        FormBean newFb = oldFb = afrd.getMapping();
        if (oldFb == null) {
            newFb = WizardUtils.newFormBean(afrd);
        }
        if (!WizardUtils.formBeansEqual(oldFb, newFb)) {
            afrd.setMapping(newFb);
        }
        return newFb;
    }

    public static FormBean getFormBean(IActionRegionData ard) {
        FormBean oldFb;
        FormBean newFb = oldFb = ard.getFormBean();
        if (oldFb == null) {
            List<FormBean> fbs = WizardUtils.getFormBeans(ard);
            if (WizardUtils.isEmpty(fbs)) {
                fbs = WizardUtils.dealWithEmptyFormBeans(ard);
            }
            if (WizardUtils.isEmpty(fbs)) {
                newFb = WizardUtils.createBlankFormBean();
                fbs = new ArrayList<FormBean>(1);
                fbs.add(newFb);
                ard.setFormBeans(fbs);
            }
            newFb = fbs.get(0);
            assert (newFb != null);
        }
        if (!WizardUtils.formBeansEqual(oldFb, newFb)) {
            ard.setFormBean(newFb);
        }
        return newFb;
    }

    public static String getFormBeanName(IActionFormRegionData afrd) {
        String oldFbn;
        String newFbn = oldFbn = afrd.getFormBeanName();
        if (oldFbn == null) {
            FormBean fb = WizardUtils.getFormBean(afrd);
            if (fb == null) {
                fb = WizardUtils.createBlankFormBean();
                afrd.setFormBean(fb);
            }
            newFbn = fb.getName();
        }
        assert (newFbn != null);
        if (!Model2Util.isEqualOrBothNull((Object)oldFbn, (Object)newFbn)) {
            afrd.setFormBeanName(newFbn);
        }
        return newFbn;
    }

    public static String getFormBeanName(IActionRegionData ard) {
        String oldFbn;
        String newFbn = oldFbn = ard.getFormBeanName();
        if (oldFbn == null) {
            FormBean fb = WizardUtils.getFormBean(ard);
            if (fb == null) {
                fb = WizardUtils.createBlankFormBean();
                ard.setFormBean(fb);
            }
            newFbn = fb.getName();
        }
        assert (newFbn != null);
        if (!Model2Util.isEqualOrBothNull((Object)oldFbn, (Object)newFbn)) {
            ard.setFormBeanName(newFbn);
        }
        return newFbn;
    }

    public static List<String> getFormBeanNames(IStrutsRegionData srd) {
        List<String> oldFbns;
        List<String> newFbns = oldFbns = srd.getFormBeanNames();
        if (WizardUtils.isEmpty(oldFbns)) {
            List<FormBean> fbs = WizardUtils.getFormBeans(srd);
            if (WizardUtils.isEmpty(fbs)) {
                WizardUtils.trace((String)".getFormBeanNames(IStrutsRegionData): empty formBeans");
                newFbns = WizardUtils.dealWithEmptyFormBeanNames(srd);
            } else {
                newFbns = new ArrayList<String>(fbs.size());
                for (FormBean fb : fbs) {
                    String name = fb.getName();
                    if (WizardUtils.isEmpty((String)name)) continue;
                    newFbns.add(name);
                }
            }
        }
        assert (newFbns != null) : ".getFormBeanNames(): ERROR: null formBeanNames";
        if (!WizardUtils.stringListsEqual(oldFbns, newFbns)) {
            srd.setFormBeanNames(newFbns);
        }
        return newFbns;
    }

    public static List<FormBean> getFormBeans(IStrutsRegionData srd) {
        List<FormBean> oldFbs;
        List<FormBean> newFbs = oldFbs = srd.getFormBeans();
        if (oldFbs == null) {
            newFbs = WizardUtils.dealWithEmptyFormBeans(srd);
        }
        if (!WizardUtils.formBeanListsEqual(oldFbs, newFbs)) {
            srd.setFormBeans(newFbs);
        }
        return newFbs;
    }

    public static String getFormBeanScope(IActionRegionData ard) {
        String oldFbs;
        String newFbs = oldFbs = ard.getFormBeanScope();
        if (!WizardUtils.isValidFormBeanScope(oldFbs)) {
            ActionMapping am = WizardUtils.getActionMapping(ard);
            if (am.isSetScope()) {
                RequestScope rs = am.getScope();
                if (rs != null) {
                    newFbs = rs.toString();
                }
            } else {
                newFbs = WizardUtils.getBlankFormBeanScope();
            }
        }
        if (!Model2Util.isEqualOrBothNull((Object)oldFbs, (Object)newFbs)) {
            ard.setFormBeanScope(newFbs);
        }
        return newFbs;
    }

    public static String getFormBeanType(IActionFormRegionData afrd) {
        String oldFbt;
        String newFbt = oldFbt = afrd.getFormBeanType();
        if (oldFbt == null) {
            FormBean fb = WizardUtils.getFormBean(afrd);
            if (fb == null) {
                fb = WizardUtils.createBlankFormBean();
                afrd.setFormBean(fb);
            }
            newFbt = fb.getType();
        }
        assert (newFbt != null);
        if (!Model2Util.isEqualOrBothNull((Object)oldFbt, (Object)newFbt)) {
            afrd.setFormBeanType(newFbt);
        }
        return newFbt;
    }

    public static Collection getForwards(IActionRegionData ard) {
        Collection<Forward> oldFs;
        Collection<Forward> newFs = oldFs = ard.getForwards();
        ActionMapping am = WizardUtils.getActionMapping(ard);
        if (WizardUtils.isEmpty(oldFs) && am != null) {
            newFs = new LinkedHashSet<Forward>();
            newFs.addAll((Collection<Forward>)am.getForwards());
        }
        if (!WizardUtils.forwardListsEqual(oldFs, newFs)) {
            ard.setForwards(newFs);
        }
        return newFs;
    }

    public static String getFQClassname(IActionFormRegionData afrd) {
        return WizardUtils.getFQClassname((IModel2RegionData)afrd, (String)WizardUtils.getPrefix(afrd));
    }

    public static String getFQClassname(IActionRegionData ard) {
        return WizardUtils.getFQClassname((IModel2RegionData)ard, (String)WizardUtils.getPrefix(ard));
    }

    public static String getJavaPackageName(IStrutsRegionData srd) {
        String oldPN;
        assert (srd != null);
        String newPN = oldPN = srd.getJavaPackageName();
        IPackageFragment pf = srd.getJavaPackageFragment();
        if (pf == null) {
            pf = WizardUtils.getDefaultJavaPackageFragment(srd);
        }
        if (!Model2Util.isEqualOrBothNull((Object)oldPN, (Object)(newPN = pf.getElementName()))) {
            srd.setJavaPackageName(newPN);
        }
        return newPN;
    }

    public static String getModuleName(IStrutsRegionData srd) {
        assert (srd != null);
        String oldMn = srd.getModuleName();
        String newMn = oldMn;
        if (newMn == null) {
            newMn = WizardUtils.scfName2ModuleName(srd);
        }
        if (!Model2Util.isEqualOrBothNull((Object)oldMn, (Object)newMn)) {
            srd.setModuleName(newMn);
        }
        return newMn;
    }

    public static String getNewName(String className) {
        if (!WizardUtils.isEmpty((String)className)) {
            return WizardUtils.lcfc((String)className);
        }
        return NO_NAME;
    }

    public static String getNewPath(String cn) {
        if (!WizardUtils.isEmpty((String)cn)) {
            return WizardUtils.addLeadingSlash((String)WizardUtils.lcfc((String)cn));
        }
        return NO_PATH;
    }

    public static String getNoProjectsError() {
        return ResourceHandler.wizard_common_error_noStrutsProjects;
    }

    public static String[] getOtherSuperClasses() {
        String[] classes = new String[]{};
        return classes;
    }

    public static String[] getOtherSuperClasses(IActionRegionData ard) {
        assert (ard != null);
        IStrutsActionCodeGenContrib cgc = ard.getActionCodeGenContrib();
        return cgc.getOtherSuperClasses();
    }

    public static String getPrefix(IActionFormRegionData afrd) {
        String cn = afrd.getPrefix();
        if (WizardUtils.isEmpty((String)cn)) {
            String name = WizardUtils.getFormBeanName(afrd);
            cn = WizardUtils.name2Classname(name);
            afrd.setPrefix(cn);
        }
        return cn;
    }

    public static String getPrefix(IActionRegionData ard) {
        String cn = ard.getPrefix();
        if (WizardUtils.isEmpty((String)cn)) {
            String mp = WizardUtils.getActionMappingPath(ard);
            cn = WizardUtils.path2Classname(mp);
        }
        return cn;
    }

    public static String getProjectName(IStrutsRegionData srd) {
        String ret = BLANK_FORMBEAN_TYPE;
        IVirtualComponent component = WizardUtils.getComponent(srd);
        if (component == null && WizardUtils.getComponent() == null) {
            return ret;
        }
        if (component == null) {
            return BLANK_FORMBEAN_TYPE;
        }
        ret = component.getName();
        if (ret == null) {
            ret = BLANK_FORMBEAN_TYPE;
        }
        return ret;
    }

    public static StrutsArtifactEdit getStrutsArtifactEdit(IStrutsRegionData srd) {
        IFile scf;
        IVirtualComponent component;
        StrutsArtifactEdit newStrutsArtifactEdit = null;
        String scfn = srd.getStrutsConfigFileName();
        if (WizardUtils.isEmpty((String)scfn)) {
            List<String> scfns = WizardUtils.getStrutsConfigFileNames(srd);
            WizardUtils.isEmpty(scfns);
            srd.setStrutsConfigFileNames(scfns);
            if (WizardUtils.isEmpty(scfns)) {
                WizardUtils.trace((String)"empty SCF name list");
            } else {
                scfn = scfns.get(0);
                srd.setStrutsConfigFileName(scfn);
            }
        }
        if (!WizardUtils.isEmpty((String)scfn) && (component = WizardUtils.getComponent(srd)) != null && (scf = Model2Util.fileFor((IVirtualComponent)component, (String)scfn)) != null) {
            newStrutsArtifactEdit = StrutsArtifactEdit.getStrutsArtifactEditForWrite(scf);
        }
        return newStrutsArtifactEdit;
    }

    public static IVirtualComponent[] getStrutsComponents() {
        Object[] ps = WizardUtils.getComponents();
        ArrayList<Object> ret = new ArrayList<Object>(ps.length);
        if (!WizardUtils.isEmpty((Object[])ps)) {
            int i = 0;
            while (i < ps.length) {
                if (WizardUtils.isStrutsComponent((IVirtualComponent)ps[i])) {
                    ret.add(ps[i]);
                }
                ++i;
            }
        }
        if (WizardUtils.isEmpty(ret)) {
            return new IVirtualComponent[0];
        }
        return ret.toArray(new IVirtualComponent[0]);
    }

    public static String getStrutsConfigFileName(IStrutsRegionData srd) {
        List<String> scfns;
        String oldScfn;
        String newScfn = oldScfn = srd.getStrutsConfigFileName();
        if (WizardUtils.isEmpty((String)oldScfn) && !WizardUtils.isEmpty(scfns = WizardUtils.getStrutsConfigFileNames(srd))) {
            String mn = srd.getModuleName();
            newScfn = WizardUtils.isEmpty((String)mn) ? "/WEB-INF/struts-config.xml" : WizardUtils.moduleName2SCFN(srd);
        }
        if (!Model2Util.isEqualOrBothNull((Object)oldScfn, (Object)newScfn)) {
            srd.setStrutsConfigFileName(newScfn);
            WizardUtils.setModuleNameViaSCFN(srd, newScfn);
        }
        return newScfn;
    }

    public static List<String> getStrutsConfigFileNames(IStrutsRegionData srd) {
        List<String> oldScfns;
        List<String> newScfns = oldScfns = srd.getStrutsConfigFileNames();
        if (WizardUtils.isEmpty(oldScfns)) {
            IVirtualComponent component = WizardUtils.getComponent(srd);
            if (component == null) {
                newScfns = Collections.emptyList();
            } else {
                Set scLinks;
                try {
                    scLinks = StrutsSearchUtil.getStrutsConfigFileLinks((IProject)component.getProject(), null);
                }
                catch (ReferenceException e) {
                    e.printStackTrace();
                    scLinks = Collections.emptySet();
                }
                newScfns = new ArrayList<String>(StrutsSearchUtil.convertPathsToStrings((Collection)StrutsSearchUtil.convertFilesToDocRootRelativePaths((Collection)StrutsSearchUtil.convertLinksToFiles(scLinks))));
            }
        }
        if (!WizardUtils.strutsConfigFileNamesEqual(oldScfns, newScfns)) {
            srd.setStrutsConfigFileNames(newScfns);
        }
        return newScfns;
    }

    public static boolean hasStrutsComponents() {
        Object[] ps = WizardUtils.getComponents();
        if (!WizardUtils.isEmpty((Object[])ps)) {
            int i = 0;
            while (i < ps.length) {
                if (WizardUtils.isStrutsComponent((IVirtualComponent)ps[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void initDefaultCGM(IActionRegionData ard) {
        assert (ard != null);
        WizardUtils.initDefaultCGM(ard, ard.getWizardId());
    }

    public static void initDefaultCGM(IActionRegionData ard, String wizardId) {
        IVirtualComponent component;
        WizardToCgmMap w2cgm = WizardUtils.getExternallyDefinedDefaultCgmMap(ard, wizardId);
        if (w2cgm != null && (component = WizardUtils.getComponent(ard)) != null) {
            WizardUtils.setDefaultCGM(ard, w2cgm, component);
        }
    }

    public static void initModule(IActionFormRegionData afrd, String scfn) {
        WizardUtils.newDefaultPackage(afrd);
        WizardUtils.refreshFormBean(afrd);
    }

    public static void initModule(IActionRegionData gard, String scfn) {
        WizardUtils.newDefaultPackage(gard);
        WizardUtils.newActionMapping(gard);
        WizardUtils.refreshFormBeans(gard);
    }

    public static void initModule(IStrutsRegionData srd) {
        String scfn = null;
        String mn = srd.getModuleName();
        scfn = mn == null ? WizardUtils.newStrutsConfigFileName(srd) : WizardUtils.getStrutsConfigFileName(srd);
        if (srd instanceof IActionRegionData) {
            GenericActionRegionData gard = (GenericActionRegionData)srd;
            WizardUtils.initModule(gard, scfn);
        } else if (srd instanceof ActionFormRegionData) {
            ActionFormRegionData afrd = (ActionFormRegionData)srd;
            WizardUtils.initModule(afrd, scfn);
        }
    }

    public static void initPrefix(IStrutsRegionData srd, String defaultClassName) {
        srd.setPrefix(defaultClassName);
    }

    public static void initProject(IActionRegionData ard) {
        WizardUtils.initDefaultCGM(ard);
        String defSCN = WizardUtils.getDefaultSuperclassNameFromCGC(ard);
        WizardUtils.initSuperclass(ard, defSCN);
        WizardUtils.initProject((IStrutsRegionData)ard);
    }

    public static void initProject(IStrutsRegionData srd) {
        List<String> scfns = null;
        String mn = srd.getModuleName();
        scfns = mn == null || mn.trim().length() == 0 ? WizardUtils.newStrutsConfigFileNames(srd) : WizardUtils.getStrutsConfigFileNames(srd);
        if (!WizardUtils.isEmpty((Collection)scfns)) {
            WizardUtils.initModule(srd);
        }
    }

    public static void initSuperclass(IStrutsRegionData srd, String defaultSuperclassName) {
        assert (srd != null);
        assert (defaultSuperclassName != null && defaultSuperclassName.length() > 0);
        srd.setDefaultSuperClassName(defaultSuperclassName);
        srd.setDefaultSuperclass();
    }

    public static boolean isBlankActionMapping(ActionMapping am) {
        return am.getPath().equals(NO_PATH);
    }

    public static boolean isBlankFormBean(FormBean fb) {
        String name = fb.getName();
        return name != null && (name.equals(BLANK_FORMBEAN_NAME) || BLANK_FORMBEAN_TYPE.equals(name));
    }

    public static boolean isBlankMapping(ActionMapping am) {
        return WizardUtils.isBlankActionMapping(am);
    }

    public static boolean isBlankMapping(FormBean fb) {
        return WizardUtils.isBlankFormBean(fb);
    }

    public static boolean isDefaultActionClassname(String ac) {
        return !WizardUtils.isEmpty((String)ac) && ac.equals(WizardUtils.getDefaultActionMappingType());
    }

    public static boolean isDefaultActionMappingPath(String amp) {
        return !WizardUtils.isEmpty((String)amp) && amp.equals(WizardUtils.getDefaultActionMappingPath());
    }

    public static boolean isNewName(String n, List names) {
        if (WizardUtils.isEmpty((Collection)names)) {
            return true;
        }
        return !names.contains(n);
    }

    public static boolean isNewPath(IActionRegionData ard, String p) {
        List amps = WizardUtils.getActionMappingPaths(ard);
        if (WizardUtils.isEmpty((Collection)amps)) {
            return true;
        }
        return !amps.contains(p);
    }

    public static boolean isStrutsComponent(IVirtualComponent component) {
        return StrutsProjectCoreUtil.isStruts((IProject)component.getProject());
    }

    public static boolean isValidActionMappingPath(String path) {
        if (WizardUtils.isEmpty((String)path) || path.equals(NO_PATH) || path.indexOf(":") > -1 || path.indexOf(" ") > -1) {
            return false;
        }
        Path p = new Path(path);
        return !p.isUNC() && p.isValidPath(path);
    }

    public static boolean isValidFormBeanName(String name) {
        return !WizardUtils.isEmpty((String)name) && !name.equals(BLANK_FORMBEAN_NAME) && ValidateUtil.isValidBeanName(name);
    }

    public static boolean isValidFormBeanScope(RequestScope rs) {
        if (rs == null) {
            return false;
        }
        return WizardUtils.isValidFormBeanScope(rs.toString());
    }

    public static boolean isValidFormBeanScope(String s) {
        if (WizardUtils.isEmpty((String)s) || s.equals(BLANK_FORMBEAN_TYPE)) {
            return false;
        }
        return s.equals("request") || s.equals("session");
    }

    public static String moduleName2SCFN(IStrutsRegionData srd) {
        String mn = WizardUtils.getModuleName(srd);
        IVirtualComponent component = WizardUtils.getComponent(srd);
        String scfn = WizardUtils.moduleName2SCFN(mn, component, true);
        srd.setStrutsConfigFileName(scfn);
        return scfn;
    }

    public static String moduleName2SCFN(String mn, IVirtualComponent component) {
        return WizardUtils.moduleName2SCFN(mn, component, true);
    }

    public static String moduleName2SCFN(String mn, IVirtualComponent component, boolean mustExist) {
        String ret = null;
        if (component == null) {
            return null;
        }
        if (!WizardUtils.isEmpty((String)mn)) {
            IFile file;
            IPath path;
            Set links;
            try {
                links = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)component.getProject(), (String)mn, null);
            }
            catch (ReferenceException e) {
                e.printStackTrace();
                links = Collections.emptySet();
            }
            Collection filesList = StrutsSearchUtil.convertLinksToFiles(links);
            IFile[] files = filesList.toArray(new IFile[filesList.size()]);
            if (files.length > 0 && (path = (file = files[0]).getFullPath()) != null) {
                ret = WizardUtils.scfPath2SCFN(path);
            }
        }
        return ret;
    }

    public static String name2Classname(String fbn) {
        if (!WizardUtils.isEmpty((String)fbn)) {
            return WizardUtils.ucfc((String)fbn);
        }
        return BLANK_FORMBEAN_TYPE;
    }

    public static String name2Path(String name) {
        String defpath = WizardUtils.getDefaultActionMappingPath();
        if (WizardUtils.isEmpty((String)name) || WizardUtils.isDefaultActionClassname(name)) {
            return defpath;
        }
        String defname = WizardUtils.getDefaultActionMappingType();
        StringBuffer ret = new StringBuffer();
        String inter = null;
        if (name.endsWith(defname)) {
            int li = name.lastIndexOf(defname);
            inter = name.substring(0, li);
            ret.append(IStrutsConstants.ACTION_MAPPING_DEFAULT_SEPARATOR).append(WizardUtils.lcfc((String)inter));
        } else {
            ret.append(IStrutsConstants.ACTION_MAPPING_DEFAULT_SEPARATOR).append(WizardUtils.lcfc((String)name));
        }
        return ret.toString();
    }

    public static ActionMapping newActionMapping(IActionRegionData ard) {
        ActionMapping newAm = null;
        String cn = ard.getPrefix();
        newAm = WizardUtils.isEmpty((String)cn) ? ActionDataUtil.createMapping() : ActionDataUtil.createMapping(WizardUtils.name2Path(cn));
        assert (newAm != null);
        assert (newAm.getPath() != null);
        ActionDataUtil.addActionMapping(ard, newAm);
        return newAm;
    }

    public static IPackageFragment newDefaultPackage(IStrutsRegionData srd) {
        IPackageFragment newPF = WizardUtils.getDefaultJavaPackageFragment(srd);
        WizardUtils.setPackage((IModel2RegionData)srd, (IPackageFragment)newPF);
        return newPF;
    }

    public static FormBean newFormBean(IActionFormRegionData afrd) {
        assert (afrd != null);
        FormBean newFb = null;
        String candidateName = afrd.getFormBeanName();
        String defaultName = afrd.getPrefix();
        if (WizardUtils.isEmpty((String)defaultName) && WizardUtils.isEmpty((String)candidateName)) {
            newFb = WizardUtils.createFormBeanMapping();
        } else {
            if (WizardUtils.isEmpty((String)candidateName)) {
                candidateName = WizardUtils.classname2Name(defaultName);
            }
            newFb = WizardUtils.createFormBeanMapping(candidateName);
        }
        assert (newFb != null);
        candidateName = newFb.getName();
        assert (candidateName != null && candidateName.length() > 0);
        List<String> fbns = WizardUtils.getFormBeanNames(afrd);
        assert (fbns != null) : "empty fbns";
        List<FormBean> oldFbs = null;
        List<FormBean> newFbs = null;
        if (!WizardUtils.isEmpty(fbns) && fbns.contains(candidateName)) {
            newFbs = oldFbs = WizardUtils.getFormBeans(afrd);
            assert (oldFbs != null && oldFbs.size() > 0);
            oldFbs.contains(newFb);
        } else {
            newFbs = oldFbs = WizardUtils.getFormBeans(afrd);
            if (WizardUtils.isEmpty(oldFbs)) {
                newFbs = new ArrayList<FormBean>(1);
            }
            newFbs.add(newFb);
        }
        assert (newFb != null) : "ERROR: null mapping";
        assert (newFb.getName() != null && newFb.getName().length() > 0);
        assert (newFbs != null && newFbs.size() > 0);
        afrd.setFormBeans(newFbs);
        return newFb;
    }

    public static List newFormBeanNames(IActionRegionData ard) {
        return WizardUtils.dealWithEmptyFormBeanNames(ard);
    }

    public static List<FormBean> newFormBeans(IActionRegionData ard) {
        return WizardUtils.dealWithEmptyFormBeans(ard);
    }

    public static String newStrutsConfigFileName(IStrutsRegionData srd) {
        srd.setStrutsConfigFileName(null);
        return WizardUtils.getStrutsConfigFileName(srd);
    }

    public static List newStrutsConfigFileNames(IStrutsRegionData srd) {
        srd.setStrutsConfigFileNames(null);
        return WizardUtils.getStrutsConfigFileNames(srd);
    }

    public static String path2Classname(String path) {
        if (path.equals(WizardUtils.getDefaultActionMappingPath())) {
            return WizardUtils.getDefaultActionMappingType();
        }
        StringBuffer sb = new StringBuffer();
        String inter = null;
        int li = path.lastIndexOf(IStrutsConstants.ACTION_MAPPING_DEFAULT_SEPARATOR);
        inter = li > -1 ? path.substring(li + 1) : path;
        if (!WizardUtils.isEmpty((String)inter)) {
            inter = WizardUtils.ucfc((String)inter);
        }
        if (JavaConventions.validateIdentifier((String)inter).isOK()) {
            sb.append(inter);
        }
        sb.append(WizardUtils.getDefaultActionMappingType());
        return sb.toString();
    }

    public static boolean projectsEqual(IProject one, IProject other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        if (!one.getName().equals(other.getName())) {
            return false;
        }
        return one.equals((Object)other);
    }

    public static void refreshFormBean(IActionFormRegionData afrd) {
        FormBean fb = WizardUtils.newFormBean(afrd);
        assert (fb != null);
        afrd.setMapping(fb);
        String fbn = fb.getName();
        String fbt = fb.getType();
        assert (fbn != null && fbn.length() > 0);
        afrd.setFormBeanName(fbn);
        afrd.setFormBeanType(fbt);
    }

    public static void refreshFormBeans(IActionRegionData ard) {
        ard.setFormBeans(null);
        ard.setFormBean(null);
        ard.setFormBeanNames(null);
        ard.setFormBeanName(null);
        WizardUtils.newFormBeanNames(ard);
        WizardUtils.getFormBeanName(ard);
        WizardUtils.newFormBeans(ard);
        WizardUtils.getFormBean(ard);
    }

    public static void releaseStrutsArtifactEdit(StrutsArtifactEdit strutsArtifactEdit) {
        if (strutsArtifactEdit != null) {
            strutsArtifactEdit.dispose();
        }
    }

    public static boolean requestScopesEqual(RequestScope one, RequestScope other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        return one.equals((Object)other);
    }

    protected static void saveStrutsArtifactEdit(StrutsArtifactEdit strutsArtifactEdit) {
        if (strutsArtifactEdit != null) {
            strutsArtifactEdit.saveIfNecessary(null);
        }
    }

    public static String scfName2ModuleName(IStrutsRegionData srd) {
        String scfn = WizardUtils.getStrutsConfigFileName(srd);
        String ret = null;
        if (!WizardUtils.isEmpty((String)scfn)) {
            IFile strutsConfigFile;
            IVirtualComponent component = WizardUtils.getComponent(srd);
            if (component == null) {
                component = WizardUtils.getComponent();
            }
            if ((strutsConfigFile = Model2Util.fileFor((IVirtualComponent)component, (String)scfn)) != null) {
                ILink link = StrutsSearchUtil.getStrutsConfig((IFile)strutsConfigFile);
                try {
                    return StrutsSearchUtil.getModuleForILink((ILink)link, null);
                }
                catch (ReferenceException e) {
                    e.printStackTrace();
                }
            }
        }
        if (ret == null) {
            ret = BLANK_FORMBEAN_TYPE;
        }
        return ret;
    }

    public static String scfPath2SCFN(IPath ip) {
        int segN;
        String ret = null;
        if (ip != null && (segN = ip.segmentCount()) > 2) {
            int goodLen;
            Object[] segA = ip.segments();
            int w = -1;
            if (!WizardUtils.isEmpty((Object[])segA)) {
                int i = 0;
                while (i < segN) {
                    Object cand = segA[i];
                    if (!WizardUtils.isEmpty((String)cand) && ((String)cand).equals("WEB-INF")) {
                        w = i;
                        break;
                    }
                    ++i;
                }
            }
            if (w > -1 && (goodLen = segN - w) > 0) {
                Object[] goodA = new String[goodLen];
                System.arraycopy(segA, w, goodA, 0, goodLen);
                if (!WizardUtils.isEmpty((Object[])goodA)) {
                    ret = new StringBuffer(47).append(WizardUtils.slashAppend((String[])goodA)).toString();
                }
            }
        }
        return ret;
    }

    public static void setActionMappingPath(IActionRegionData ard, String p) {
        ActionMapping am = WizardUtils.getActionMapping(ard);
        if (am != null) {
            ard.setActionMappingPath(p);
        }
    }

    public static void setActionMappingType(IActionRegionData ard, String t) {
        ActionMapping am = WizardUtils.getActionMapping(ard);
        if (am != null) {
            if (WizardUtils.isEmpty((String)t)) {
                ard.setActionMappingType(NO_TYPE);
            } else {
                ard.setActionMappingType(t);
            }
        }
    }

    public static void setClassname(IActionFormRegionData afrd, String cn) {
        WizardUtils.setPrefix((IModel2RegionData)afrd, (String)cn);
    }

    public static void setClassname(IActionRegionData ard, String cn) {
        WizardUtils.setPrefix((IModel2RegionData)ard, (String)cn);
    }

    public static void setDefaultCGM(IActionRegionData ard, WizardToCgmMap w2cgm, IVirtualComponent component) {
        WebRegionCodeGenModel cgm;
        Set facetIds = Model2Util.getAllFacetIds((IVirtualComponent)component);
        String cgmId = w2cgm.facetIds2CgmId(facetIds);
        if (!com.ibm.etools.model2.base.util.WizardUtils.isEmpty((String)cgmId) && (cgm = WizardUtils.cgmId2CGM(ard, cgmId)) != null) {
            ard.setDefaultCodeGenModel(cgm);
            ard.setCurrentCodeGenModel(cgm);
            ard.initCurrentCodeGenModelIfNecessary();
        }
    }

    public static void setDestinationFolder(StrutsRegionData srd, IContainer newC) {
        if (newC != null) {
            srd.setDestinationFolder(newC);
            IJavaProject jProject = WizardUtils.getJavaProject((IModel2RegionData)srd);
            if (jProject != null) {
                IPackageFragmentRoot ipfr = jProject.getPackageFragmentRoot((IResource)newC);
                WizardUtils.setPackageFragmentRoot(srd, ipfr);
                IPackageFragment ipf = null;
                if (ipfr != null) {
                    String jpn = WizardUtils.getJavaPackageName(srd);
                    ipf = ipfr.getPackageFragment(jpn);
                }
                WizardUtils.setJavaPackageFragment(srd, ipf);
            }
        } else {
            WizardUtils.setJavaPackageFragment(srd, null);
            srd.setDestinationFolder(null);
        }
    }

    public static void setFormBean(IActionRegionData ard, FormBean fb) {
        FormBean oldFb = ard.getFormBean();
        String oldFbn = null;
        String oldFbt = null;
        FormBean newFb = fb;
        if (newFb != null) {
            String newFbn = newFb.getName();
            assert (newFbn != null && newFbn.length() > 0);
            if (oldFb != null) {
                oldFbn = oldFb.getName();
            }
            if (!Model2Util.isEqualOrBothNull((Object)oldFbn, (Object)newFbn)) {
                ard.setFormBeanName(newFbn);
            }
            String newFbt = newFb.getType();
            if (oldFb != null) {
                oldFbt = oldFb.getType();
            }
            if (!Model2Util.isEqualOrBothNull((Object)oldFbt, (Object)newFbt)) {
                ard.setFormBeanType(newFbt);
            }
        }
    }

    public static void setFormBeanName(IActionFormRegionData afrd, String n) {
        FormBean fb = WizardUtils.getFormBean(afrd);
        if (fb != null) {
            if (WizardUtils.isEmpty((String)n)) {
                afrd.setFormBeanName(NO_NAME);
            } else {
                afrd.setFormBeanName(n);
            }
        }
    }

    public static void setFormBeanType(IActionFormRegionData afrd, String t) {
        FormBean fb = WizardUtils.getFormBean(afrd);
        if (fb != null) {
            if (WizardUtils.isEmpty((String)t)) {
                afrd.setFormBeanType(NO_TYPE);
            } else {
                afrd.setFormBeanType(t);
            }
        }
    }

    public static void setFQClassname(IStrutsRegionData srd, String classname) {
        String pkg = null;
        String name = null;
        if (!WizardUtils.isEmpty((String)classname)) {
            int i = classname.lastIndexOf(46);
            if (i == -1) {
                pkg = null;
                name = classname;
            } else {
                pkg = classname.substring(0, i);
                name = classname.substring(i + 1);
            }
        }
        srd.setClassname(name);
        if (WizardUtils.isEmpty(pkg)) {
            pkg = WizardUtils.getDefaultJavaPackageFragmentName(srd);
        }
        WizardUtils.setPackage((IModel2RegionData)srd, (String)pkg);
    }

    protected static void setJavaPackageFragment(StrutsRegionData srd, IPackageFragment ipf) {
        assert (srd != null);
        srd.setJavaPackageFragment(ipf);
    }

    public static void setMapping(IActionRegionData ard, ActionMapping am) {
        List ams = WizardUtils.getActionMappings(ard);
        if (!ams.contains(am)) {
            ams.add(am);
            ard.setActionMappings(ams);
        }
        ard.setMapping(am);
    }

    public static void setModuleName(IStrutsRegionData srd, String newMn) {
        String oldMn = srd.getModuleName();
        if (!Model2Util.isEqualOrBothNull((Object)oldMn, (Object)newMn)) {
            srd.setModuleName(newMn);
            WizardUtils.initModule(srd);
        }
    }

    public static void setModuleNameViaSCFN(IStrutsRegionData srd, String newScfn) {
        IVirtualComponent component = WizardUtils.getComponent(srd);
        IContainer container = WebUtil.getDocumentRootContainer((IResource)component.getProject());
        IPath path = container.getFullPath().append(newScfn);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        ILink scLink = StrutsSearchUtil.getStrutsConfig((IFile)file);
        String newMn = null;
        if (scLink != null) {
            try {
                newMn = StrutsSearchUtil.getModuleForILink((ILink)scLink, null);
            }
            catch (ReferenceException e) {
                e.printStackTrace();
            }
        }
        WizardUtils.setModuleName(srd, newMn);
    }

    protected static void setPackageFragmentRoot(StrutsRegionData srd, IPackageFragmentRoot ipfr) {
        assert (srd != null);
        srd.setPackageFragmentRoot(ipfr);
    }

    public static void setStrutsConfigFileName(IStrutsRegionData srd, String scfn) {
        srd.setStrutsConfigFileName(scfn);
        WizardUtils.setModuleNameViaSCFN(srd, scfn);
    }

    public static void setStrutsConfigFileNames(IStrutsRegionData srd, Collection newScfns) {
        List<String> oldScfns = srd.getStrutsConfigFileNames();
        if (!WizardUtils.stringListsEqual(oldScfns, (Collection)newScfns)) {
            srd.setStrutsConfigFileNames(new ArrayList<String>(newScfns));
            String oldScfn = srd.getStrutsConfigFileName();
            newScfns.contains(oldScfn);
        }
    }

    public static boolean strutsConfigFileNamesEqual(List one, List other) {
        return WizardUtils.stringListsEqual((Collection)one, (Collection)other);
    }

    public static boolean strutsConfigsEqual(StrutsConfig one, StrutsConfig other) {
        if (one == null && other == null) {
            return true;
        }
        if (one == null) {
            return false;
        }
        return one.equals(other);
    }

    public static IStatus validateDuplicateEntries(String name, List list) {
        if (!WizardUtils.isEmpty((Collection)list) && !WizardUtils.isNewName(name, list)) {
            int severity = 4;
            return new Status(severity, StrutsPlugin.getPluginId(), severity, NLS.bind((String)ResourceHandler.wizard_common_error_existing, (Object)"name"), null);
        }
        return new Status(0, StrutsPlugin.getPluginId(), 0, BLANK_FORMBEAN_TYPE, null);
    }

    public static IStatus validateMappingName(String name) {
        if (WizardUtils.isEmpty((String)name) || name.equals(NO_NAME)) {
            int severity = 4;
            return new Status(severity, StrutsPlugin.getPluginId(), severity, NLS.bind((String)ResourceHandler.wizard_common_error_empty, (Object)ResourceHandler.wizard_common_name_lowercase), null);
        }
        if (!ValidateUtil.isValidBeanName(name)) {
            int severity = 4;
            return new Status(severity, StrutsPlugin.getPluginId(), severity, NLS.bind((String)ResourceHandler.wizard_common_error_badMappingPK, (Object)"name", (Object)name), null);
        }
        return new Status(0, StrutsPlugin.getPluginId(), 0, BLANK_FORMBEAN_TYPE, null);
    }

    public static IStatus validateMappingName(String name, List names) {
        IStatus ret = WizardUtils.validateMappingName(name);
        int sev = ret.getSeverity();
        assert (sev == 4 || sev == 0);
        if (ret.getSeverity() == 4) {
            return ret;
        }
        if (!WizardUtils.isEmpty((Collection)names) && !WizardUtils.isNewName(name, names)) {
            int severity = 4;
            return new Status(severity, StrutsPlugin.getPluginId(), severity, NLS.bind((String)ResourceHandler.wizard_common_error_existing, (Object)"name"), null);
        }
        return new Status(0, StrutsPlugin.getPluginId(), 0, BLANK_FORMBEAN_TYPE, null);
    }

    public static IStatus validateMappingPath(String path) {
        if (WizardUtils.isEmpty((String)path) || path.equals(NO_PATH)) {
            int severity = 4;
            return new Status(severity, StrutsPlugin.getPluginId(), severity, NLS.bind((String)ResourceHandler.wizard_common_error_empty, (Object)ResourceHandler.wizard_common_path_lowercase), null);
        }
        if (!ValidateUtil.beginsWithSlash(path)) {
            int severity = 4;
            return new Status(severity, StrutsPlugin.getPluginId(), severity, ResourceHandler.wizard_common_path_noslash, null);
        }
        if (!ValidateUtil.isValidMappingPath(path)) {
            int severity = 4;
            return new Status(severity, StrutsPlugin.getPluginId(), severity, NLS.bind((String)ResourceHandler.wizard_common_error_badMappingPK, (Object)ResourceHandler.wizard_common_path_lowercase, (Object)path), null);
        }
        return new Status(0, StrutsPlugin.getPluginId(), 0, BLANK_FORMBEAN_TYPE, null);
    }

    public static String whyIsMappingPathInvalid(String path, IWTRegionData rd) {
        if (WizardUtils.isEmpty((String)path) || path.equals(NO_PATH)) {
            return NLS.bind((String)ResourceHandler.wizard_common_error_empty, (Object)ResourceHandler.wizard_common_path_lowercase);
        }
        if (ValidateUtil.isValidMappingPath(path)) {
            return NLS.bind((String)ResourceHandler.wizard_common_error_badMappingPK, (Object)ResourceHandler.wizard_common_path_lowercase, (Object)path);
        }
        return null;
    }
}

