/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.wrf;

import com.ibm.etools.struts.wizards.wrf.IStrutsRegionData;
import com.ibm.etools.struts.wizards.wrf.WizardUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class WizardToCgmMap {
    private static final String EXTENSION_ID = "com.ibm.etools.struts.WebRegionModel_Model2_actions_default_CGM";
    private static final String ELEMENT_NAME = "cgm";
    private static final String FACET_ELEMENT = "facet";
    private static final String WIZARD_ID = "wizard_id";
    private static final String MODEL_ID = "model_id";
    private final IStrutsRegionData strutsRegionData;
    private final String wizardId;
    private final Map map;

    public WizardToCgmMap(IStrutsRegionData strutsRegionData, String wizardId) {
        this.strutsRegionData = strutsRegionData;
        this.wizardId = wizardId;
        this.map = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int i = 0;
        while (i < elements.length) {
            ElementBean elementBean = this.parseElement(elements[i]);
            if (elementBean != null) {
                this.add(elementBean);
            }
            ++i;
        }
    }

    private void add(ElementBean element) {
        ArrayList<Set> list = (ArrayList<Set>)this.map.get(element.modelId);
        if (list == null) {
            list = new ArrayList<Set>();
            this.map.put(element.modelId, list);
        }
        list.add(element.facetIds);
    }

    public String facetIds2CgmId(Set facetIds) {
        String maxId = null;
        int maxSize = 0;
        Set currentIds = WizardUtils.getCgmIds(this.strutsRegionData);
        for (Map.Entry entry : this.map.entrySet()) {
            String id = (String)entry.getKey();
            if (!currentIds.contains(id)) continue;
            for (Set facetSet : (List)entry.getValue()) {
                if (!facetIds.containsAll(facetSet) || facetSet.size() <= maxSize) continue;
                maxSize = facetSet.size();
                maxId = id;
            }
        }
        return maxId;
    }

    private ElementBean parseElement(IConfigurationElement element) {
        String modelId;
        if (ELEMENT_NAME.equals(element.getName()) && this.wizardId.equals(element.getAttribute(WIZARD_ID)) && (modelId = element.getAttribute(MODEL_ID)) != null) {
            IConfigurationElement[] childElements = element.getChildren();
            HashSet<String> facetIds = new HashSet<String>();
            int i = 0;
            while (i < childElements.length) {
                String facetId;
                IConfigurationElement childElement = childElements[i];
                if (FACET_ELEMENT.equals(childElement.getName()) && (facetId = childElement.getValue()) != null && facetId.length() > 0) {
                    facetIds.add(facetId);
                }
                ++i;
            }
            return new ElementBean(modelId, facetIds);
        }
        return null;
    }

    private static final class ElementBean {
        public String modelId;
        public Set facetIds;

        public ElementBean(String modelId, Set facetIds) {
            this.modelId = modelId;
            this.facetIds = facetIds;
        }
    }
}

