/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.webpage;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.jspeditor.StrutsTaglibUtil;
import com.ibm.etools.webedit.common.commands.CompoundHTMLCommand;
import com.ibm.etools.webedit.common.commands.HTMLCommand;
import com.ibm.etools.webedit.common.commands.utils.ChangeTag;
import com.ibm.etools.webedit.common.editdomain.HTMLCommandTarget;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webpage.template.selection.core.ITemplateDescriptor;
import com.ibm.etools.webtools.taglib.TaglibRecordWrapper;
import com.ibm.etools.webtools.webpage.core.IDocumentEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StrutsDocumentEditor
implements IDocumentEditor {
    private IDataModel pageModel;
    private HTMLEditDomain editDomain;

    private void addHtmlRenameCommands(List commands) {
        NodeList nodes;
        Element element;
        IDOMModel model = this.editDomain.getActiveModel();
        if (model != null && (element = model.getDocument().getDocumentElement()) != null && (nodes = element.getElementsByTagName("HTML")).getLength() == 1 && nodes.item(0).getNodeType() == 1) {
            HTMLCommand command = new HTMLCommand("something"){

                protected void doExecute() {
                    ChangeTag ct = new ChangeTag(nodes);
                    ct.change((Element)nodes.item(0), "html:html");
                }
            };
            commands.add(command);
        }
    }

    private void addTaglibInsertCommand(List commands, TaglibRecordWrapper wrapper) {
        String uri = wrapper.getURI();
        String prefix = wrapper.getPrefix();
        HTMLCommand cmd = StrutsTaglibUtil.getTaglibInsertCommand(uri, prefix, this.editDomain);
        commands.add(cmd);
    }

    public boolean editDocument(HTMLEditDomain editDomain) {
        this.editDomain = editDomain;
        HTMLCommand command = this.getCommand();
        if (command != null) {
            command.execute();
        }
        this.editDomain = null;
        this.pageModel = null;
        return false;
    }

    private TaglibRecordWrapper[] getAvailableTaglibRecordWrappers() {
        IVirtualComponent component;
        IProject project = (IProject)this.pageModel.getProperty("IWebPageCreationDataModelProperties.PROJECT");
        if (project != null && (component = Model2Util.findComponent((IResource)project)) != null) {
            IPath rootPath = component.getRootFolder().getWorkspaceRelativePath();
            ITaglibRecord[] records = TaglibIndex.getAvailableTaglibRecords((IPath)rootPath);
            return TaglibRecordWrapper.wrapper((ITaglibRecord[])records);
        }
        return new TaglibRecordWrapper[0];
    }

    private HTMLCommand getCommand() {
        ArrayList commands = new ArrayList();
        List wrappers = this.getStrutsTaglibRecordWrappers();
        for (TaglibRecordWrapper wrapper : wrappers) {
            this.addTaglibInsertCommand(commands, wrapper);
        }
        this.addHtmlRenameCommands(commands);
        if (!commands.isEmpty()) {
            CompoundHTMLCommand command = commands.size() == 1 ? (HTMLCommand)commands.get(0) : new CompoundHTMLCommand("insert_struts_taglibs", commands);
            command.setCommandTarget((HTMLCommandTarget)this.editDomain);
            return command;
        }
        return null;
    }

    private List getStrutsTaglibRecordWrappers() {
        TaglibRecordWrapper[] availableWrappers;
        String[] fragments = (String[])this.pageModel.getProperty("com.ibm.etools.struts.wizards.webpage.STRUTS_TAGLIB_FRAGMENTS");
        if (fragments.length > 0 && (availableWrappers = this.getAvailableTaglibRecordWrappers()).length > 0) {
            ArrayList<TaglibRecordWrapper> wrappers = new ArrayList<TaglibRecordWrapper>();
            int i = 0;
            while (i < fragments.length) {
                int j = 0;
                while (j < availableWrappers.length) {
                    if (this.isMatch(fragments[i], availableWrappers[j])) {
                        wrappers.add(availableWrappers[j]);
                    }
                    ++j;
                }
                ++i;
            }
            return wrappers;
        }
        return Collections.EMPTY_LIST;
    }

    private final boolean isJSP(IDataModel pageModel) {
        return pageModel.getStringProperty("IWebPageDataModelProperties.PAGE_TYPE").equals("DYNAMIC");
    }

    private boolean isMatch(String fragment, TaglibRecordWrapper wrapper) {
        int suffix2aIndex;
        String uri = wrapper.getURI();
        int fragmentIndex = uri.lastIndexOf(fragment);
        if (fragmentIndex == -1) {
            return false;
        }
        if (uri.startsWith("http://jakarta.apache.org/struts/tags-") && fragmentIndex == "http://jakarta.apache.org/struts/tags-".length()) {
            return true;
        }
        IProject project = (IProject)this.pageModel.getProperty("IWebPageCreationDataModelProperties.PROJECT");
        if (StrutsProjectCoreUtil.isStruts1_3((IProject)project) && uri.startsWith("http://struts.apache.org/tags-") && fragmentIndex == "http://struts.apache.org/tags-".length() && uri.length() == "http://struts.apache.org/tags-".length() + fragment.length()) {
            return true;
        }
        return uri.startsWith("/WEB-INF/") && uri.endsWith(".tld") && fragmentIndex + ".tld".length() == uri.length() && (suffix2aIndex = uri.lastIndexOf("/struts-")) != -1 && suffix2aIndex + "/struts-".length() == fragmentIndex;
    }

    public boolean shouldRun(IDataModel pageModel) {
        this.pageModel = pageModel;
        if (this.isJSP(pageModel) && pageModel.getBooleanProperty("com.ibm.etools.struts.wizards.webpage.IS_STRUTS_PAGE")) {
            ITemplateDescriptor template = (ITemplateDescriptor)pageModel.getProperty("IWebPageDataModelProperties.TEMPLATE");
            boolean isSampleTemplate = template.getCategory() == 1 || template.getCategory() == 2;
            boolean linkPageToTemplate = pageModel.getBooleanProperty("IWebPageDataModelProperties.LINK_PAGE_TO_TEMPLATE");
            return !isSampleTemplate || !linkPageToTemplate;
        }
        return false;
    }
}

