/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.module;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.strutsconfig.StrutsConfigFileCreator;
import com.ibm.etools.struts.wizards.module.AbstractModuleConfiguration;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.osgi.framework.Bundle;

public abstract class AbstractStrutsModuleOperation
extends WorkspaceModifyOperation {
    protected static final String DEFAULT_RESOURCE_BUNDLE_FILE = "templates/ApplicationResources.properties";
    private AbstractModuleConfiguration configuration;
    private IProgressMonitor progressMonitor;

    public AbstractStrutsModuleOperation(AbstractModuleConfiguration configuration) {
        this.setConfiguration(configuration);
    }

    private final void checkForUnsavedChanges(IProgressMonitor monitor) throws InterruptedException {
        IVirtualComponent component = this.getConfiguration().getComponent();
        if (component != null) {
            IFile[] files;
            Set scLinks;
            try {
                scLinks = StrutsSearchUtil.getStrutsConfigFileLinks((IProject)component.getProject(), (IProgressMonitor)monitor);
            }
            catch (ReferenceException e) {
                e.printStackTrace();
                scLinks = Collections.emptySet();
            }
            Collection configFileContainers = StrutsSearchUtil.convertLinksToFiles(scLinks);
            if (configFileContainers != null && !IDE.saveAllEditors((IResource[])(files = configFileContainers.toArray(new IFile[configFileContainers.size()])), (boolean)true)) {
                throw new InterruptedException("User declined to save unsaved resources.");
            }
        }
    }

    protected void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent != null && parent instanceof IFolder) {
                this.createFolder((IFolder)parent);
            }
            folder.create(true, true, this.getProgressMonitor());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createResourceBundleFile() {
        IFile resourceBundleFile = this.getResourceBundleFile();
        if (resourceBundleFile == null) return;
        String packageName = this.getConfiguration().getResourceBundlePackage();
        String propertiesFilename = String.valueOf(this.getConfiguration().getResourceBundleName()) + ".properties";
        IPackageFragment targetPackage = this.getResourceBundlePackage(packageName);
        if (targetPackage != null) {
            IFolder packageFolder;
            try {
                packageFolder = (IFolder)targetPackage.getUnderlyingResource();
            }
            catch (JavaModelException exception) {
                StrutsPlugin.getLogger().log("Cannot locate package for resource bundle file", (Throwable)exception);
                return;
            }
            IFile propertiesFile = packageFolder.getFile(propertiesFilename);
            if (propertiesFile.exists()) {
                if (propertiesFile.getType() != 1) {
                    StrutsPlugin.getLogger().trace("StrutsPlugin", "Cannot locate source file");
                    return;
                } else {
                    StrutsPlugin.getLogger().trace("StrutsPlugin", "Resource Bundle already exists");
                }
                return;
            }
            InputStream stream = null;
            try {
                try {
                    stream = new BufferedInputStream(FileLocator.openStream((Bundle)StrutsPlugin.getDefault().getBundle(), (IPath)new Path(DEFAULT_RESOURCE_BUNDLE_FILE), (boolean)false));
                    propertiesFile.create(stream, false, this.getProgressMonitor());
                    return;
                }
                catch (IOException exception) {
                    StrutsPlugin.getLogger().log((Throwable)exception);
                    if (stream == null) return;
                    try {
                        try {
                            stream.close();
                            return;
                        }
                        catch (IOException ignored) {
                            StrutsPlugin.getLogger().log((Throwable)ignored);
                            stream = null;
                        }
                        return;
                    }
                    finally {
                        stream = null;
                    }
                }
                catch (CoreException exception) {
                    StrutsPlugin.getLogger().log((Throwable)exception);
                    if (stream == null) return;
                    try {
                        try {
                            stream.close();
                            return;
                        }
                        catch (IOException ignored) {
                            StrutsPlugin.getLogger().log((Throwable)ignored);
                            stream = null;
                        }
                        return;
                    }
                    finally {
                        stream = null;
                    }
                }
            }
            finally {
                block33: {
                    if (stream != null) {
                        try {
                            try {
                                stream.close();
                            }
                            catch (IOException ignored) {
                                StrutsPlugin.getLogger().log((Throwable)ignored);
                                stream = null;
                                break block33;
                            }
                        }
                        catch (Throwable throwable) {
                            stream = null;
                            throw throwable;
                        }
                        stream = null;
                    }
                }
            }
        }
        StrutsPlugin.getLogger().log("Package for resource bundle cannot be created");
    }

    protected void createStrutsConfigFile(IFile strutsConfigFile) {
        String resourceBundle = null;
        if (this.getConfiguration().getStrutsVersion() >= 1 && this.getConfiguration().isCreateResourceBundle()) {
            resourceBundle = this.getConfiguration().getFullResourceBundleName();
        }
        try {
            StrutsConfigFileCreator scfCreator = new StrutsConfigFileCreator(this.getConfiguration().getStrutsVersion(), resourceBundle);
            scfCreator.writeTo(strutsConfigFile, this.getProgressMonitor());
        }
        catch (Exception e) {
            StrutsPlugin.getLogger().log((Throwable)e);
        }
    }

    protected abstract void execute() throws CoreException, InvocationTargetException, InterruptedException;

    public final void execute(IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            SubMonitor converted = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)2);
            this.checkForUnsavedChanges((IProgressMonitor)converted.newChild(1));
            this.setProgressMonitor((IProgressMonitor)converted.newChild(1));
            this.execute();
        }
        finally {
            if (progressMonitor != null) {
                progressMonitor.done();
            }
            this.setProgressMonitor(null);
        }
    }

    protected Collection<IFile> getConfigFileContainers() {
        IVirtualComponent component = this.getConfiguration().getComponent();
        if (component != null) {
            Set scLinks;
            try {
                scLinks = StrutsSearchUtil.getStrutsConfigFileLinks((IProject)component.getProject(), null);
            }
            catch (ReferenceException e) {
                e.printStackTrace();
                scLinks = Collections.emptySet();
            }
            Collection configFileContainers = StrutsSearchUtil.convertLinksToFiles(scLinks);
            return configFileContainers;
        }
        return null;
    }

    protected String getConfigInitParamName() {
        String moduleName = this.getConfiguration().getModuleName();
        if (moduleName.length() == 0) {
            return "config";
        }
        return "config/" + moduleName;
    }

    public AbstractModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    protected IFile getFile(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    protected IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }

    protected IFile getResourceBundleFile() {
        IFolder sourceFolder;
        IJavaProject javaProject = JavaCore.create((IProject)this.getConfiguration().getComponent().getProject());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)(sourceFolder = Model2Util.getSourceFolder((IVirtualComponent)this.getConfiguration().getComponent())));
        IPackageFragment targetPackage = root.getPackageFragment(this.getConfiguration().getResourceBundlePackage());
        IPath resourceBundlePath = targetPackage.getPath().append(String.valueOf(this.getConfiguration().getResourceBundleName()) + ".properties");
        IFile resourceBundleFile = this.getFile(resourceBundlePath);
        return resourceBundleFile.exists() ? null : resourceBundleFile;
    }

    private IPackageFragment getResourceBundlePackage(String packageName) {
        try {
            IPackageFragmentRoot root;
            IPackageFragment targetPackage;
            IJavaProject javaProject = JavaCore.create((IProject)this.getConfiguration().getComponent().getProject());
            IFolder srcDirFolder = Model2Util.getSourceFolder((IVirtualComponent)this.getConfiguration().getComponent());
            if (!srcDirFolder.exists()) {
                StrutsPlugin.getLogger().trace("StrutsPlugin", "Source Folder does not exist, creating it");
                srcDirFolder.create(true, true, this.getProgressMonitor());
            }
            if (!(targetPackage = (root = javaProject.getPackageFragmentRoot((IResource)srcDirFolder)).getPackageFragment(packageName)).exists()) {
                StrutsPlugin.getLogger().trace("StrutsPlugin", "Package does not exist, creating it");
                root.createPackageFragment(packageName, false, this.getProgressMonitor());
            }
            return targetPackage;
        }
        catch (Exception e) {
            StrutsPlugin.getLogger().log("Problem getting or creating package " + packageName, (Throwable)e);
            return null;
        }
    }

    public void setConfiguration(AbstractModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }
}

