/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.module;

import com.ibm.etools.model2.base.util.Model2ProjectPropertyUtils;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.base.util.SelectionUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class AbstractModuleConfiguration {
    private String moduleName = null;
    private boolean createModuleDirectory = true;
    private String strutsConfigFileName = null;
    private boolean createResourceBundle = true;
    private String resourceBundlePackage = null;
    private String resourceBundleName = "ApplicationResources";
    private String defaultPackagePrefix = null;

    public abstract IVirtualComponent getComponent();

    public String getComponentName() {
        return this.getComponent() == null ? "" : this.getComponent().getName();
    }

    protected String getDefaultModuleName() {
        return "module";
    }

    protected String getDefaultPackagePrefix() {
        IVirtualComponent comp;
        if (this.defaultPackagePrefix == null && (comp = this.getComponent()) != null) {
            this.defaultPackagePrefix = Model2ProjectPropertyUtils.getPackagePrefix((IProject)comp.getProject());
        }
        return this.defaultPackagePrefix;
    }

    protected String getDefaultResourceBundlePackage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDefaultPackagePrefix());
        String name = this.getModuleName();
        if (name.length() > 0) {
            if (buffer.length() > 0) {
                buffer.append('.');
            }
            name = name.replace('/', '.').replace('-', '_');
            buffer.append(name);
        }
        if (buffer.length() > 0) {
            buffer.append('.');
        }
        buffer.append("resources");
        return buffer.toString();
    }

    protected String getDefaultStrutsConfigFileName() {
        String name = this.getModuleName();
        if ((name = name.replace('/', '-')).length() == 0) {
            name = "config";
        }
        return "/WEB-INF/struts-" + name + ".xml";
    }

    public String getFullResourceBundleName() {
        return this.getResourceBundlePackage().length() > 0 ? String.valueOf(this.getResourceBundlePackage()) + "." + this.getResourceBundleName() : this.getResourceBundleName();
    }

    public IFolder getModuleFolder() {
        IContainer webModuleContainer;
        String moduleName = this.getModuleName();
        if (moduleName.length() > 0 && (webModuleContainer = Model2Util.getDocumentRootContainer((IVirtualComponent)this.getComponent())) != null) {
            return Model2Util.getFolder((IContainer)webModuleContainer, (String)moduleName);
        }
        return null;
    }

    public String getModuleName() {
        if (this.moduleName == null) {
            this.moduleName = this.getDefaultModuleName();
        }
        return this.moduleName;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getResourceBundlePackage() {
        if (this.resourceBundlePackage == null) {
            this.resourceBundlePackage = this.getDefaultResourceBundlePackage();
        }
        return this.resourceBundlePackage;
    }

    public abstract IStructuredSelection getSelection();

    public IFile getStrutsConfigFile() {
        String name;
        IContainer container = Model2Util.getDocumentRootContainer((IVirtualComponent)this.getComponent());
        if (container != null && (name = this.getStrutsConfigFileName()) != null && name.length() > 0) {
            return Model2Util.getFile((IContainer)container, (String)name);
        }
        return null;
    }

    public String getStrutsConfigFileName() {
        if (this.strutsConfigFileName == null) {
            this.strutsConfigFileName = this.getDefaultStrutsConfigFileName();
        }
        return this.strutsConfigFileName;
    }

    public int getStrutsVersion() {
        int version = StrutsProjectCoreUtil.getStrutsVersion((IProject)this.getComponent().getProject());
        if (version == -1) {
            version = 1;
        }
        return version;
    }

    public abstract IWorkbench getWorkbench();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IVirtualComponent component;
        IProject project = SelectionUtil.getProject((ISelection)selection);
        if (project != null && (component = Model2Util.findComponent((IResource)project)) != null) {
            this.setComponent(component);
        }
    }

    public boolean isCreateModuleDirectory() {
        return this.createModuleDirectory;
    }

    public boolean isCreateResourceBundle() {
        return this.createResourceBundle;
    }

    public boolean isDefaultModuleName() {
        return this.moduleName == null || this.moduleName.equals(this.getDefaultModuleName());
    }

    public boolean isDefaultResourceBundlePackage() {
        return this.resourceBundlePackage == null || this.resourceBundlePackage.equals(this.getDefaultResourceBundlePackage());
    }

    public boolean isDefaultStrutsConfigFileName() {
        return this.strutsConfigFileName == null || this.getStrutsConfigFileName().equals(this.getDefaultStrutsConfigFileName());
    }

    public void setComponent(IVirtualComponent component) {
        this.defaultPackagePrefix = null;
    }

    public void setCreateModuleDirectory(boolean createModuleDirectory) {
        this.createModuleDirectory = createModuleDirectory;
    }

    public void setCreateResourceBundle(boolean createResourceBundle) {
        this.createResourceBundle = createResourceBundle;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    public void setResourceBundlePackage(String resourceBundlePackage) {
        this.resourceBundlePackage = resourceBundlePackage;
    }

    public void setStrutsConfigFileName(String configFileName) {
        this.strutsConfigFileName = configFileName;
    }
}

