/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards.formbeans;

import com.ibm.etools.model2.base.util.CommonDialogManager;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.base.util.WidgetUtils;
import com.ibm.etools.model2.base.util.WizardUtils;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.util.StrutsUtil;
import com.ibm.etools.struts.wizards.formbeans.FormBeanWizard;
import com.ibm.etools.struts.wizards.formbeans.IFormBeanRegionData;
import com.ibm.etools.struts.wizards.forms.ActionFormWizard;
import com.ibm.etools.struts.wizards.forms.IActionFormRegionData;
import com.ibm.etools.struts.wizards.wrf.IStrutsRegionData;
import com.ibm.etools.struts.wizards.wrf.StrutsRegionData;
import com.ibm.etools.struts.wizards.wrf.StrutsRegionDataPage;
import com.ibm.etools.webtools.wizards.IRegionAwareWizardPage;
import com.ibm.etools.webtools.wizards.regiondata.IWTRegionData;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class FormBeanRegionDataPage
extends StrutsRegionDataPage
implements IRegionAwareWizardPage {
    private static final String DEFAULT_NAME = "fbw_class_page_name";
    private static final String KIND_OF_MAPPING = "form-bean";
    private static final String NAME_CONTROL_LABEL = ResourceHandler.wizard_common_fbname_label;
    private static final String NAME_CONTROL_TIP = ResourceHandler.wizard_formbean_name_tip;

    public FormBeanRegionDataPage() {
        super(DEFAULT_NAME);
    }

    public FormBeanRegionDataPage(String pn) {
        super(pn);
    }

    public FormBeanRegionDataPage(String pn, String title, ImageDescriptor titleImage) {
        super(pn, title, titleImage);
    }

    @Override
    protected void ableAll(boolean b) {
        this.projButton.setEnabled(b);
        this.ableAllButMainControl(b);
    }

    @Override
    protected void ableAllButMainControl(boolean b) {
        this.scfNameCombo.setEnabled(b);
        this.idText.setEnabled(b);
        this.typeText.setEnabled(b);
        this.typeHyperlink.setEnabled(b);
        this.typeBrowse.setEnabled(b);
        if (StrutsProjectCoreUtil.isStruts1_3((IProject)this.getStrutsRegionData().getProject())) {
            this.extendsText.setEnabled(b);
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    private void checkMappingTypeChange(IFormBeanRegionData fbrd) {
        String nt;
        String ot = com.ibm.etools.struts.wizards.wrf.WizardUtils.getFormBeanType(fbrd);
        if (!Model2Util.isEqualOrBothNull((Object)ot, (Object)(nt = com.ibm.etools.struts.wizards.wrf.WizardUtils.getFQClassname(fbrd)))) {
            com.ibm.etools.struts.wizards.wrf.WizardUtils.setFormBeanType(fbrd, nt);
            this.signalRegionDataChanged("formBeanMappingType");
        }
    }

    @Override
    public Composite createComponents(Composite parent, IStrutsRegionData srd) {
        Composite child = WidgetUtils.createComposite((Composite)parent, (int)2);
        return this.createTypeClassEntrySection(child, "com.ibm.etools.struts.sgaf0000", KIND_OF_MAPPING, NAME_CONTROL_LABEL, NAME_CONTROL_TIP);
    }

    @Override
    protected void createMethodStubsControl(Composite c) {
    }

    @Override
    protected Composite createOtherControls(Composite c, String kot) {
        return c;
    }

    @Override
    protected void doTypeHyperlinkClickAction() {
        String typeName = this.typeText.getText();
        if (WizardUtils.isEmpty((String)typeName)) {
            String name = this.idText.getText();
            if (name == null) {
                name = "";
            }
            typeName = com.ibm.etools.struts.wizards.wrf.WizardUtils.name2Classname(name);
        }
        IJavaProject jp = JavaCore.create((IProject)this.getStrutsRegionData().getProject());
        IType type = null;
        try {
            type = jp.findType(typeName);
        }
        catch (JavaModelException e1) {
            StrutsPlugin.getLogger().log((Throwable)e1);
        }
        if (type == null) {
            ActionFormWizard wizard = new ActionFormWizard(false);
            IActionFormRegionData afrd = (IActionFormRegionData)wizard.getRegionData();
            String mn = StrutsUtil.transposeModuleName(this.getStrutsRegionData().getModuleName());
            afrd.setModuleName(mn);
            afrd.setSkipBeanMappingAndConfigurationPages(true);
            StructuredSelection ss = new StructuredSelection((Object)this.getStrutsRegionData().getComponent());
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)ss);
            IVirtualComponent component = this.getStrutsRegionData().getComponent();
            afrd.setDestinationFolder(component.getRootFolder().getUnderlyingFolder());
            com.ibm.etools.struts.wizards.wrf.WizardUtils.setFQClassname(afrd, typeName);
            String scfn = this.getStrutsRegionData().getStrutsConfigFileName();
            if (WizardUtils.isEmpty((String)scfn)) {
                WizardUtils.trace((Object)((Object)this), (String)"got empty SCFN");
            } else {
                com.ibm.etools.struts.wizards.wrf.WizardUtils.setStrutsConfigFileName(afrd, scfn);
            }
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.create();
            int rc = dialog.open();
            if (rc == 0) {
                typeName = afrd.getFQClassname();
                this.typeText.setText(typeName);
                this.typeText.setFocus();
            }
        }
    }

    @Override
    protected String getCreateTypeToolTip() {
        return ResourceHandler.wizard_common_formbean_create_type_tooltip;
    }

    @Override
    protected String getExistsTypeToolTip() {
        return ResourceHandler.wizard_common_formbean_exists_type_tooltip;
    }

    @Override
    protected StrutsUtil.ElementType getExtendsContentAssistType() {
        return StrutsUtil.ElementType.FORMBEAN;
    }

    @Override
    protected String getExtendsTypeLabel() {
        return ResourceHandler.wizard_common_extends_formbean;
    }

    @Override
    protected String getExtendsTypeSpecificLabel() {
        return ResourceHandler.wizard_common_extends_formbean;
    }

    public IFormBeanRegionData getFormBeanRegionData() {
        return (IFormBeanRegionData)this.getRegionData();
    }

    @Override
    protected String[] getOurThingies(IStrutsRegionData srd) {
        return ((IFormBeanRegionData)srd).getActionForms();
    }

    @Override
    protected String[] getTypeContentAssistValues(StrutsRegionData srd) {
        return ((IFormBeanRegionData)((Object)srd)).getActionForms();
    }

    @Override
    protected String getTypeText() {
        return ResourceHandler.wizard_common_formbean_type;
    }

    @Override
    public void handleComponents(IStrutsRegionData srd, Event e) {
        IFormBeanRegionData fbrd = this.getFormBeanRegionData();
        Widget source = e.widget;
        if (source == this.idText) {
            this.handleMappingNameTextKey(fbrd);
        } else if (source == this.scfNameCombo) {
            this.handleSCFNameComboSelected(fbrd);
        } else if (source == this.extendsText) {
            this.handleExtendsTextChanged(fbrd);
        } else if (source == this.typeText) {
            this.handleTypeChanged();
        } else if (source == this.projButton) {
            this.handleComponentBrowseButtonSelected(fbrd);
        } else assert (false);
        this.setPageComplete(this.validatePage(this.getFormBeanRegionData()));
    }

    public void handleEvent(Event e) {
        super.handleEvent(this.getFormBeanRegionData(), e);
    }

    private void handleMappingNameChanged(IFormBeanRegionData fbrd) {
        String cn = com.ibm.etools.struts.wizards.wrf.WizardUtils.name2Classname(fbrd.getMapping().getName());
        if (cn != null && !cn.equals(fbrd.getPrefix())) {
            fbrd.setPrefix(cn);
            this.signalRegionDataChanged("prefix");
        }
        this.updateView(fbrd);
    }

    private void handleMappingNameTextKey(IFormBeanRegionData fbrd) {
        String fbn;
        String mnt = this.idText.getText();
        if (!Model2Util.isEqualOrBothNull((Object)mnt, (Object)(fbn = com.ibm.etools.struts.wizards.wrf.WizardUtils.getFormBeanName(fbrd)))) {
            fbrd.setFormBeanName(mnt);
            this.signalRegionDataChanged("formBeanMappingName");
        }
    }

    private void handlePackageFragmentChanged(IFormBeanRegionData fbrd) {
        this.checkMappingTypeChange(fbrd);
    }

    private void handlePrefixChanged(IFormBeanRegionData fbrd) {
        this.checkMappingTypeChange(fbrd);
    }

    @Override
    public void handleRegionDataChanged(IWTRegionData data, Collection changed) {
        if (WizardUtils.isEmpty((Collection)changed)) {
            StrutsPlugin.getLogger().log("handleRegionDataChanged: null changed");
            return;
        }
        IFormBeanRegionData fbrd = (IFormBeanRegionData)data;
        for (String key : changed) {
            assert (key != null);
            if (key.equals("strutsConfigFileName")) {
                this.handleStrutsConfigFileNameChanged(fbrd);
                continue;
            }
            if (key.equals("formBeanMappingName")) {
                this.handleMappingNameChanged(fbrd);
                continue;
            }
            if (key.equals("prefix")) {
                this.handlePrefixChanged(fbrd);
                continue;
            }
            if (key.equals("packageFragment")) {
                this.handlePackageFragmentChanged(fbrd);
                continue;
            }
            if (key.equals("formBeanMappingType")) {
                this.updateView(fbrd);
                continue;
            }
            if (key.equals("reuseRadio")) {
                this.updateView(fbrd);
                continue;
            }
            if (key.equals("generateRadio")) {
                this.updateView(fbrd);
                continue;
            }
            if (key.equals("allowCreateFormBeanClass")) {
                this.updateView(fbrd);
                continue;
            }
            if (key.equals("model")) {
                this.updateView(fbrd);
                continue;
            }
            if (!key.equals("project")) continue;
            this.handleProjectChanged(fbrd);
        }
    }

    @Override
    protected void handleTypeBrowseButtonSelected() {
        String beanType = CommonDialogManager.openClassBrowser((IProject)this.getStrutsRegionData().getComponent().getProject(), (String)"org.apache.struts.action.ActionForm");
        if (beanType != null) {
            this.typeText.setText(beanType);
            this.typeText.setFocus();
        }
    }

    @Override
    protected void handleTypeChanged() {
        super.handleTypeChanged();
        IFormBeanRegionData amrd = this.getFormBeanRegionData();
        amrd.setReuseTypeName(this.typeText.getText());
        this.signalRegionDataChanged("reuseTypeName");
    }

    @Override
    protected void initContent(IStrutsRegionData srd) {
        IFormBeanRegionData fbrd = (IFormBeanRegionData)srd;
        this.initMappingRDP(fbrd);
    }

    @Override
    protected void initIDControl(IStrutsRegionData srd) {
        IFormBeanRegionData fbrd = (IFormBeanRegionData)srd;
        String name = com.ibm.etools.struts.wizards.wrf.WizardUtils.getFormBeanName(fbrd);
        if (this.idText != null && !this.idText.isDisposed() && name != null) {
            this.idText.setText(name);
        }
    }

    @Override
    protected void initOtherContents(IStrutsRegionData srd) {
        this.initTypeControl();
    }

    protected void initTypeControl() {
        try {
            IFormBeanRegionData ard = this.getFormBeanRegionData();
            ard.setReuseBacking();
            ard.setAllowCreateFormBeanClass(false);
            ard.setModelId(ard.getReuseModelId());
            this.handleNewModelSelected(ard.getReuseModelId());
            this.signalRegionDataChanged(new String[]{"reuseRadio", "allowCreateActionClass", "model"});
        }
        catch (CoreException e) {
            StrutsPlugin.getLogger().log((Throwable)e);
        }
    }

    public void signalRegionDataChanged(List changed) {
        ((FormBeanWizard)this.getWizard()).fireRegionDataChangedEvent(changed);
    }

    @Override
    public void signalRegionDataChanged(String changed) {
        ((FormBeanWizard)this.getWizard()).fireRegionDataChangedEvent(WizardUtils.makeList((String)changed));
    }

    @Override
    public void signalRegionDataChanged(String[] changed) {
        ((FormBeanWizard)this.getWizard()).fireRegionDataChangedEvent(WizardUtils.makeList((String[])changed));
    }

    @Override
    protected void updateButtonStates(IStrutsRegionData srd) {
    }

    private void updateComponents(IFormBeanRegionData fbrd) {
        this.updateMappingRDP(fbrd);
    }

    private void updateComponents(IFormBeanRegionData fbrd, Event e) {
        this.updateMappingRDP(fbrd, e);
    }

    @Override
    protected void updateComponents(IStrutsRegionData srd) {
        this.updateComponents((IFormBeanRegionData)srd);
    }

    @Override
    protected void updateComponents(IStrutsRegionData srd, Event e) {
        this.updateComponents((IFormBeanRegionData)srd, e);
    }

    private void updateIDControl(IFormBeanRegionData fbrd) {
        String newP = com.ibm.etools.struts.wizards.wrf.WizardUtils.getFormBeanName(fbrd);
        String oldP = this.idText.getText();
        if (newP != null && !newP.equals(oldP)) {
            this.idText.setText(newP);
        }
    }

    @Override
    protected void updateIDControl(IStrutsRegionData srd) {
        this.updateIDControl((IFormBeanRegionData)srd);
    }

    @Override
    protected void updateMethodStubs(IStrutsRegionData srd) {
    }

    @Override
    public void updateOnKey(String key, IWTRegionData rd) {
        this.updateView((IStrutsRegionData)rd);
    }

    @Override
    protected void updateOtherControls(IStrutsRegionData srd) {
    }

    @Override
    protected void updateOtherControls(IStrutsRegionData srd, Event e) {
    }

    @Override
    protected void validateBackingControl(IStrutsRegionData srd) {
        if (!srd.hasBacking()) {
            this.pageStatus.addErrorMessage(ResourceHandler.wizard_formbean_error_noBacking);
        } else if (srd.isGenerate()) {
            this.validateGenerateControl(srd);
        }
    }

    @Override
    protected void validateComponents(IStrutsRegionData srd) {
        this.validateMappingRDP(srd);
    }

    @Override
    protected void validateGenerateControl(IStrutsRegionData srd) {
        IFormBeanRegionData fbrd = (IFormBeanRegionData)srd;
        String mid = fbrd.getModelId();
        if (fbrd.isReuseModel(mid)) {
            this.pageStatus.addErrorMessage(ResourceHandler.wizard_common_error_noReuse);
        } else if (fbrd.getStrutsVersion() == 0 && fbrd.isDynaFormModel(mid)) {
            this.pageStatus.addErrorMessage(ResourceHandler.wizard_formbean_error_noDyna);
        }
    }

    @Override
    protected void validateIDControl(IStrutsRegionData srd) {
        super.validateIDControl((IFormBeanRegionData)srd);
    }

    @Override
    protected void validateOtherControls(IStrutsRegionData srd) {
    }

    @Override
    protected void validateSuperclass(IStrutsRegionData srd) {
    }
}

