/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.wizards;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.strutsconfig.StrutsConfigFileCreator;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsConfigFileWizardPage
extends WizardNewFileCreationPage {
    private String errorMessage = null;

    public StrutsConfigFileWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setTitle(ResourceHandler.StrutsConfigFileWizard_pageTitle);
        this.setDescription(ResourceHandler.StrutsConfigFileWizard_description);
    }

    protected void createAdvancedControls(Composite parent) {
        super.createAdvancedControls(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.etools.struts.scfw0000");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.errorMessage != null) {
            this.setMessage(null);
            this.setErrorMessage(this.errorMessage);
        }
    }

    protected IFile createFileHandle(IPath filePath) {
        if (filePath != null && !"xml".equals(filePath.getFileExtension())) {
            filePath = filePath.addFileExtension("xml");
        }
        return super.createFileHandle(filePath);
    }

    private IVirtualComponent getComponent() {
        if (this.getFileContainer() != null) {
            return Model2Util.findComponent((IResource)this.getFileContainer().getProject());
        }
        return null;
    }

    private IContainer getFileContainer() {
        IPath path = this.getContainerFullPath();
        if (path != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            switch (path.segmentCount()) {
                case 0: {
                    return root;
                }
                case 1: {
                    return root.getProject(path.segment(0));
                }
            }
            return root.getFolder(path);
        }
        return null;
    }

    protected InputStream getInitialContents() {
        try {
            return new StrutsConfigFileCreator(this.getStrutsVersion()).buildInputStream(this.getComponent());
        }
        catch (IOException exception) {
            StrutsPlugin.getLogger().log((Throwable)exception);
            return null;
        }
    }

    private int getStrutsVersion() {
        IVirtualComponent component = this.getComponent();
        int strutsVersion = StrutsProjectCoreUtil.getStrutsVersion((IProject)component.getProject());
        if (strutsVersion == -1) {
            strutsVersion = 1;
        }
        return strutsVersion;
    }

    private IPath getValidFileContainerPath(IContainer container) {
        IVirtualComponent component = Model2Util.findComponent((IResource)container.getProject());
        if (component == null || !StrutsProjectCoreUtil.isStruts((IProject)component.getProject())) {
            return null;
        }
        IPath webContentPath = Model2Util.getDocumentRootContainer((IVirtualComponent)component).getFullPath();
        if (webContentPath.isPrefixOf(container.getFullPath())) {
            return container.getFullPath();
        }
        return webContentPath.append("WEB-INF");
    }

    protected void initialPopulateContainerNameField() {
        super.initialPopulateContainerNameField();
        IContainer container = this.getFileContainer();
        if (container != null) {
            this.setContainerFullPath(this.getValidFileContainerPath(container));
        }
    }

    private boolean isValidFileContainer(IContainer container) {
        IVirtualComponent component = Model2Util.findComponent((IResource)container.getProject());
        if (component == null || !StrutsProjectCoreUtil.isStruts((IProject)component.getProject())) {
            return false;
        }
        IPath webContentPath = Model2Util.getDocumentRootContainer((IVirtualComponent)component).getFullPath();
        return webContentPath.isPrefixOf(container.getFullPath());
    }

    protected boolean validatePage() {
        IContainer container = this.getFileContainer();
        if (container != null) {
            IPath filePath;
            IFile file;
            if (!this.isValidFileContainer(container)) {
                this.setMessage(null);
                this.errorMessage = ResourceHandler.StrutsConfigFileWizard_error_selection_must_be_under_WebContent;
                this.setErrorMessage(this.errorMessage);
                return false;
            }
            String fileName = this.getFileName();
            if (fileName != null && fileName.length() > 0 && (file = this.createFileHandle(filePath = container.getFullPath().append(fileName))).exists()) {
                this.setMessage(null);
                this.errorMessage = ResourceHandler.StrutsConfigFileWizard_error_file_exists;
                this.setErrorMessage(this.errorMessage);
                return false;
            }
        }
        if (!super.validatePage()) {
            this.errorMessage = this.getErrorMessage();
            if (this.errorMessage == null) {
                this.errorMessage = this.getMessage();
            }
            return false;
        }
        this.setMessage(null);
        this.errorMessage = null;
        this.setErrorMessage(this.errorMessage);
        return true;
    }
}

