/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.util;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.IStrutsConstants;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.configFile.id.contributions.ConfigFileIdentifierQuizMaster;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.DisplayableSetPropertyContainer;
import com.ibm.etools.struts.emf.strutsconfig.Exception0;
import com.ibm.etools.struts.emf.strutsconfig.FormBean;
import com.ibm.etools.struts.emf.strutsconfig.Forward;
import com.ibm.etools.struts.emf.strutsconfig.StrutsConfig;
import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigPackage;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.util.StrutsArtifactEdit;
import com.ibm.etools.struts.utilities.StrutsSelectorDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class StrutsUtil
implements IStrutsConstants {
    private static final String ORG_APACHE_STRUTS_ACTION_DYNA_ACTION_FORM = "org.apache.struts.action.DynaActionForm";

    private static String createPath(String newPath, int suffix) {
        if (suffix > 0) {
            return String.valueOf(newPath) + suffix;
        }
        return newPath;
    }

    public static StrutsSelectorDialog createStrutsConfigSelectionDialog(IVirtualComponent component) {
        Set scLinks;
        StrutsSelectorDialog dialog = new StrutsSelectorDialog(Display.getCurrent().getActiveShell(), ResourceHandler.Graphical_select_config_file_heading__UI_);
        try {
            scLinks = StrutsSearchUtil.getStrutsConfigFileLinks((IProject)component.getProject(), null);
        }
        catch (ReferenceException e) {
            e.printStackTrace();
            scLinks = Collections.emptySet();
        }
        ArrayList names = new ArrayList(StrutsSearchUtil.convertPathsToStrings((Collection)StrutsSearchUtil.convertFilesToDocRootRelativePaths((Collection)StrutsSearchUtil.convertLinksToFiles(scLinks))));
        dialog.setData(names);
        return dialog;
    }

    public static String getActionSuffix(IVirtualComponent component) {
        String mapping = ConfigFileIdentifierQuizMaster.getPreferredActionServletMapping(component);
        if (mapping != null && mapping.startsWith("*.")) {
            return mapping.substring(2);
        }
        return "";
    }

    public static List<String> getAcyclicExtendValues(StrutsConfig sco, EObject obj) {
        ArrayList<EObject> invalidElements = new ArrayList<EObject>();
        ArrayList<DisplayableSetPropertyContainer> candidateElements = new ArrayList<DisplayableSetPropertyContainer>();
        ArrayList<String> candidateElementResult = new ArrayList<String>();
        StrutsconfigPackage scp = StrutsconfigPackage.eINSTANCE;
        EAttribute identFeature = null;
        EAttribute extendsFeature = null;
        if (obj instanceof ActionMapping) {
            extendsFeature = scp.getActionMapping_Extends0();
            identFeature = scp.getActionMapping_Path();
            for (ActionMapping am : sco.getActionMappings()) {
                candidateElements.add(am);
            }
        } else if (obj instanceof FormBean) {
            extendsFeature = scp.getFormBean_Extends0();
            identFeature = scp.getFormBean_Name();
            for (FormBean fb : sco.getFormBeans()) {
                candidateElements.add(fb);
            }
        } else if (obj instanceof Forward) {
            extendsFeature = scp.getForward_Extends0();
            identFeature = scp.getForward_Name();
            for (Forward f : sco.getGlobalForwards()) {
                candidateElements.add(f);
            }
            if (obj.eContainer() instanceof ActionMapping) {
                for (Forward f : ((ActionMapping)obj.eContainer()).getForwards()) {
                    candidateElements.add(f);
                }
            }
        } else if (obj instanceof Exception0) {
            extendsFeature = scp.getException0_Extends0();
            identFeature = scp.getException0_Handler();
            for (Exception0 e : sco.getGlobalExceptions()) {
                candidateElements.add(e);
            }
            if (obj.eContainer() instanceof ActionMapping) {
                for (Exception0 e : ((ActionMapping)obj.eContainer()).getExceptions()) {
                    candidateElements.add(e);
                }
            }
        }
        if (identFeature != null && extendsFeature != null) {
            ArrayList<EObject> tempInvalid = new ArrayList<EObject>();
            tempInvalid.add(obj);
            while (tempInvalid.size() > 0) {
                for (EObject ce : tempInvalid) {
                    invalidElements.add(ce);
                    candidateElements.remove(ce);
                }
                tempInvalid = new ArrayList();
                for (EObject ce : candidateElements) {
                    for (EObject ie : invalidElements) {
                        String invalidIdentValue = (String)ie.eGet((EStructuralFeature)identFeature);
                        String candidateExtendsValue = (String)ce.eGet((EStructuralFeature)extendsFeature);
                        String candidateIdentValue = (String)ce.eGet((EStructuralFeature)identFeature);
                        invalidIdentValue = invalidIdentValue == null ? "" : invalidIdentValue;
                        candidateExtendsValue = candidateExtendsValue == null ? "" : candidateExtendsValue;
                        String string = candidateIdentValue = candidateIdentValue == null ? "" : candidateIdentValue;
                        if (!invalidIdentValue.equals("") && invalidIdentValue.equals(candidateExtendsValue)) {
                            tempInvalid.add(ce);
                            continue;
                        }
                        if (invalidIdentValue.equals(candidateIdentValue)) {
                            tempInvalid.add(ce);
                            continue;
                        }
                        if (!candidateIdentValue.equals("")) continue;
                        tempInvalid.add(ce);
                    }
                }
            }
            for (EObject ce : candidateElements) {
                String identFeatureValue = (String)ce.eGet((EStructuralFeature)identFeature);
                if (identFeatureValue == null || candidateElementResult.contains(identFeatureValue)) continue;
                candidateElementResult.add(identFeatureValue);
            }
        }
        return candidateElementResult;
    }

    public static List<String> getAllExtendsValues(IFile strutsConfigFile, ElementType type) {
        return StrutsUtil.getAllExtendsValues(strutsConfigFile, type, null);
    }

    public static List<String> getAllExtendsValues(IFile strutsConfigFile, ElementType type, String parentAMPath) {
        ArrayList<String> result = new ArrayList<String>();
        if (strutsConfigFile == null) {
            return result;
        }
        StrutsArtifactEdit strutsArtifactEdit = null;
        try {
            strutsArtifactEdit = StrutsArtifactEdit.getStrutsArtifactEditForWrite(strutsConfigFile);
            StrutsConfig strutsConfig = strutsArtifactEdit.getStrutsConfig();
            List<String> list = StrutsUtil.getAllExtendsValues(strutsConfig, type, parentAMPath);
            return list;
        }
        finally {
            if (strutsArtifactEdit != null) {
                strutsArtifactEdit.dispose();
            }
        }
    }

    public static List<String> getAllExtendsValues(StrutsConfig strutsConfig, ElementType type) {
        return StrutsUtil.getAllExtendsValues(strutsConfig, type, null);
    }

    public static List<String> getAllExtendsValues(StrutsConfig strutsConfig, ElementType type, String parentAMPath) {
        String tempIdent;
        EObject eob;
        ArrayList<String> result = new ArrayList<String>();
        if (strutsConfig == null) {
            return result;
        }
        StrutsconfigPackage scp = StrutsconfigPackage.eINSTANCE;
        EAttribute identFeature = null;
        Object global_eobjs = null;
        Object local_eobjs = null;
        switch (type) {
            case ACTION: {
                identFeature = scp.getActionMapping_Path();
                global_eobjs = strutsConfig.getActionMappings();
                break;
            }
            case FORMBEAN: {
                identFeature = scp.getFormBean_Name();
                global_eobjs = strutsConfig.getFormBeans();
                break;
            }
            case EXCEPTION: {
                identFeature = scp.getException0_Handler();
                ActionMapping am = StrutsUtil.getFirstMatchingActionMapping(strutsConfig, parentAMPath);
                global_eobjs = strutsConfig.getGlobalExceptions();
                if (am == null) break;
                local_eobjs = am.getExceptions();
                break;
            }
            case FORWARD: {
                identFeature = scp.getForward_Name();
                ActionMapping am = StrutsUtil.getFirstMatchingActionMapping(strutsConfig, parentAMPath);
                global_eobjs = strutsConfig.getGlobalForwards();
                if (am == null) break;
                local_eobjs = am.getForwards();
            }
        }
        if (global_eobjs != null) {
            for (Object o : global_eobjs) {
                eob = (EObject)o;
                tempIdent = (String)eob.eGet((EStructuralFeature)identFeature);
                if (result.contains(tempIdent) || tempIdent == null) continue;
                result.add(tempIdent);
            }
        }
        if (local_eobjs != null) {
            for (Object o : local_eobjs) {
                eob = (EObject)o;
                tempIdent = (String)eob.eGet((EStructuralFeature)identFeature);
                if (result.contains(tempIdent) || tempIdent == null) continue;
                result.add(tempIdent);
            }
        }
        return result;
    }

    private static ActionMapping getFirstMatchingActionMapping(StrutsConfig strutsConfig, String mappingPath) {
        ActionMapping mapping = null;
        if (mappingPath != null && !mappingPath.equals("")) {
            EList<ActionMapping> mappings = strutsConfig.getActionMappings();
            for (ActionMapping tmpMapping : mappings) {
                if (!mappingPath.equals(tmpMapping.getPath())) continue;
                mapping = tmpMapping;
                break;
            }
        }
        return mapping;
    }

    public static List<String> getModuleActionPaths(IVirtualComponent component, String moduleName) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            SearchScope scope = StrutsSearchUtil.getModuleScope((IProject)component.getProject(), (String)moduleName, null);
            Set actionMappings = StrutsSearchUtil.getAllActionMappings((SearchScope)scope, null);
            for (ILink link : actionMappings) {
                names.add(link.getName());
            }
        }
        catch (ReferenceException e) {
            e.printStackTrace();
        }
        return names;
    }

    public static IContainer getModuleServerRoot(IVirtualComponent component) {
        IVirtualFolder rootFolder = component.getRootFolder();
        if (rootFolder != null) {
            return rootFolder.getUnderlyingFolder();
        }
        return null;
    }

    public static String getPathForActionServlet(IVirtualComponent component, String module, String targetPath) {
        String patterned = StrutsUtil.getPatterenedPathForActionServlet(component, module, targetPath);
        patterned = StrutsUtil.removePattern(ConfigFileIdentifierQuizMaster.getPreferredActionServletMapping(component), patterned);
        return patterned;
    }

    public static String getPatterenedPathForActionServlet(IVirtualComponent component, String module, String targetPath) {
        if (targetPath == null) {
            return null;
        }
        String result = StrutsSearchUtil.patternActionString((IProject)component.getProject(), (String)targetPath, null);
        return result;
    }

    public static String[] getStrutsApplicationResourcesNames(IVirtualComponent component, String module) {
        ArrayList<String> names = new ArrayList<String>();
        try {
            SearchScope moduleScope = StrutsSearchUtil.getModuleScope((IProject)component.getProject(), (String)module, null);
            Set messages = StrutsSearchUtil.getMessageResources((SearchScope)moduleScope, null);
            for (ILink link : messages) {
                names.add(AbstractWebProvider.trimQuotes((String)link.getLinkText()));
            }
        }
        catch (ReferenceException e) {
            e.printStackTrace();
        }
        return names.toArray(new String[names.size()]);
    }

    public static IFile getStrutsConfigurationFile(StrutsConfig config) {
        if (config == null) {
            return null;
        }
        Resource configResource = config.eResource();
        if (configResource == null) {
            return null;
        }
        return WorkspaceSynchronizer.getFile((Resource)configResource);
    }

    public static String getUniqueFormBeanName(IVirtualComponent component, String moduleName, String hint) {
        HashSet<String> formNames = new HashSet<String>();
        try {
            SearchScope scope = StrutsSearchUtil.getModuleScope((IProject)component.getProject(), (String)moduleName, null);
            Set formBeans = StrutsSearchUtil.getAllFormBeans((SearchScope)scope, null);
            for (ILink form : formBeans) {
                formNames.add(form.getName());
            }
        }
        catch (ReferenceException e) {
            e.printStackTrace();
        }
        String theHint = hint == null ? "formBean" : hint;
        int i = 0;
        while (formNames.contains(StrutsUtil.createPath(theHint, i))) {
            ++i;
        }
        return StrutsUtil.createPath(theHint, i);
    }

    public static boolean isDynaForm(String typeName) {
        return ORG_APACHE_STRUTS_ACTION_DYNA_ACTION_FORM.equals(typeName);
    }

    public static boolean isSubclassOf(String typeName0, String typeName1, IJavaProject javaProject) throws JavaModelException {
        if (typeName0.equals(typeName1)) {
            return true;
        }
        IType type0 = javaProject.findType(typeName0);
        IType type1 = javaProject.findType(typeName1);
        if (type0 == null || type1 == null) {
            return false;
        }
        ITypeHierarchy hierarchy = type0.newSupertypeHierarchy(null);
        IType[] superTypes = hierarchy.getAllSupertypes(type0);
        int i = 0;
        while (i < superTypes.length) {
            if (superTypes[i].equals(type1)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSubClassOfDynaForm(IType type) {
        if (type == null) return false;
        try {
            IType[] typePlusSuperTypes;
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            IType[] iTypeArray = typePlusSuperTypes = typeHierarchy.getAllTypes();
            int n = typePlusSuperTypes.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType t = iTypeArray[n2];
                if (ORG_APACHE_STRUTS_ACTION_DYNA_ACTION_FORM.equals(t.getFullyQualifiedName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            StrutsPlugin.getLogger().log((Throwable)e);
        }
        return false;
    }

    public static String removePattern(String urlPattern, String rawlink) {
        int ind = urlPattern.indexOf(42);
        if (ind == 0) {
            String s = urlPattern.substring(1);
            if (rawlink.endsWith(s)) {
                return rawlink.substring(0, rawlink.length() - urlPattern.length() + 1);
            }
        } else if (ind == urlPattern.length() - 1) {
            if (rawlink.startsWith(urlPattern.substring(0, ind))) {
                rawlink = rawlink.substring(urlPattern.length() - 1);
                return "/" + rawlink;
            }
        } else if (ind == -1) {
            if (rawlink.equals(urlPattern)) {
                return rawlink;
            }
        } else {
            String prefix = urlPattern.substring(0, ind);
            String suffix = urlPattern.substring(ind + 1);
            if (rawlink.startsWith(prefix) && rawlink.endsWith(suffix)) {
                int endInd = rawlink.length() - suffix.length();
                rawlink = rawlink.substring(prefix.length(), endInd);
                return "/" + rawlink;
            }
        }
        return null;
    }

    public static String transposeModuleName(String moduleName) {
        String result = moduleName;
        if (result == null) {
            result = "";
        }
        if (result.equals(IStrutsConstants.DEFAULTMODULE)) {
            result = "";
        }
        return result;
    }

    public static enum ElementType {
        ACTION,
        EXCEPTION,
        FORMBEAN,
        FORWARD;

    }
}

