/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.util;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.search.SearchEngine;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.Exception0;
import com.ibm.etools.struts.emf.strutsconfig.FormBean;
import com.ibm.etools.struts.emf.strutsconfig.Forward;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.wst.common.internal.emf.resource.EMF2DOMAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Node;

public class StrutsLinksSearchUtil {
    public static final Set<String> getActionMappingIncomingReferences(IProject project, String actionPath, String module, IProgressMonitor monitor) throws ReferenceException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        HashSet<String> result = new HashSet<String>();
        Set actionIncomingReferenceLinks = StrutsSearchUtil.getActionMappingIncomingReferences((IProject)project, (String)actionPath, (String)module, (IProgressMonitor)monitor);
        for (IResolvedReference l : actionIncomingReferenceLinks) {
            String depatternedResolvedRef;
            String rawResolvedRef = l.getFragmentText();
            if (rawResolvedRef == null || (depatternedResolvedRef = StrutsSearchUtil.depatternActionString((IProject)project, (String)rawResolvedRef, (IProgressMonitor)mon.newChild(1))) == null) continue;
            if (!depatternedResolvedRef.startsWith("/")) {
                depatternedResolvedRef = "/" + depatternedResolvedRef;
            }
            result.add(depatternedResolvedRef);
        }
        return result;
    }

    public static final Set<String> getActionMappingRuntimePaths(IProject project, ActionMapping action) {
        String module = StrutsLinksSearchUtil.getStrutsModule(action, null);
        return StrutsLinksSearchUtil.getActionMappingIncomingReferences(project, action.getPath(), module, null);
    }

    public static final Set<String> getActionMappingRuntimePaths(IProject project, String path, String module) {
        return StrutsLinksSearchUtil.getActionMappingIncomingReferences(project, path, module, (IProgressMonitor)new NullProgressMonitor());
    }

    public static final EObject getCorrespondingEObject(EClass eclass, EObject root, ILink link) {
        if (link == null) {
            return null;
        }
        ReferenceManager.getReferenceManager().waitForIndexing(null, SearchEngine.createSearchScope((IResource[])new IResource[]{link.getContainer().getResource()}));
        TreeIterator itr = root.eAllContents();
        while (itr.hasNext()) {
            int contextLength;
            IDOMElement domElement;
            int contextStartOffset;
            TextRange elementRange;
            Node n;
            Adapter adapter;
            EObject object = (EObject)itr.next();
            if (!eclass.equals(object.eClass()) || !((adapter = EcoreUtil.getExistingAdapter((Notifier)object, (Object)EMF2DOMAdapter.ADAPTER_CLASS)) instanceof EMF2DOMAdapter) || !((n = ((EMF2DOMAdapter)adapter).getNode()) instanceof IDOMElement) || !(elementRange = new TextRange(contextStartOffset = (domElement = (IDOMElement)n).getStartOffset(), contextLength = domElement.getEndOffset() - contextStartOffset, 0)).contains(link.getContextLocation())) continue;
            return object;
        }
        return null;
    }

    public static final String getFormBeanType(ILink beanLink) {
        HashSet<String> visitedBeans = new HashSet<String>();
        if (beanLink != null) {
            visitedBeans.add(beanLink.getName());
            return StrutsLinksSearchUtil.getFormBeanType(beanLink, visitedBeans);
        }
        return "";
    }

    private static final String getFormBeanType(ILink beanLink, Set<String> visitedBeans) {
        String beanName;
        String typeName = AbstractWebProvider.trimQuotes((String)beanLink.getLinkText());
        if (typeName != null && typeName.length() > 0) {
            return typeName;
        }
        ILink extendsBeanLink = StrutsSearchUtil.getFormBeanExtendsLinkForFormBean((ILink)beanLink);
        if (extendsBeanLink != null && (extendsBeanLink = StrutsSearchUtil.getFormBeanTargetForFormBeanLink((ILink)extendsBeanLink)) != null && !visitedBeans.contains(beanName = extendsBeanLink.getName())) {
            visitedBeans.add(beanName);
            return StrutsLinksSearchUtil.getFormBeanType(extendsBeanLink, visitedBeans);
        }
        return null;
    }

    public static final ILink getLink(EObject eo) {
        ILink result = null;
        if (eo != null) {
            IProject project = WorkspaceSynchronizer.getFile((Resource)eo.eResource()).getProject();
            if (eo instanceof ActionMapping) {
                ActionMapping am = (ActionMapping)eo;
                result = StrutsSearchUtil.getActionMappingLink((IProject)project, (String)am.getPath(), (String)StrutsLinksSearchUtil.getStrutsModule(am, null), null);
            } else if (eo instanceof Exception0) {
                Exception0 ex = (Exception0)eo;
                result = StrutsSearchUtil.getExceptionLink((IProject)project, (String)ex.getType(), (String)StrutsLinksSearchUtil.getStrutsModule(ex, null), null);
            } else if (eo instanceof Forward) {
                Forward fd = (Forward)eo;
                result = StrutsSearchUtil.getForwardLink((IProject)project, (String)fd.getName(), (String)StrutsLinksSearchUtil.getStrutsModule(fd, null), null);
            } else if (eo instanceof FormBean) {
                FormBean fb = (FormBean)eo;
                result = StrutsSearchUtil.getFormBeanLink((IProject)project, (String)fb.getName(), (String)StrutsLinksSearchUtil.getStrutsModule(fb, null), null);
            }
        }
        return result;
    }

    public static final Set<String> getProjectStrutsConfigFiles(IProject project) {
        Set links;
        HashSet<String> ret = new HashSet<String>();
        if (project != null && (links = StrutsSearchUtil.getStrutsConfigFileLinks((IProject)project, null)) != null && links.size() > 0) {
            for (ILink l : links) {
                ret.add(l.getContainer().getResource().getName());
            }
        }
        return ret;
    }

    public static final String getStrutsModule(EObject obj, IProgressMonitor monitor) {
        ReferenceManager manager = ReferenceManager.getReferenceManager();
        ILink strutsFile = (ILink)manager.getLinkNode(WorkspaceSynchronizer.getFile((Resource)obj.eResource())).getLinks(manager.getLinkType("builtin.file.nodeid"), SpecializedType.Depth.ZERO, monitor).iterator().next();
        return StrutsSearchUtil.getModuleForILink((ILink)strutsFile, (IProgressMonitor)monitor);
    }

    public static final String getStrutsModule(IFile strutsConfig) {
        ReferenceManager manager = ReferenceManager.getReferenceManager();
        ILink strutsFile = (ILink)manager.getLinkNode(strutsConfig).getLinks(manager.getLinkType("builtin.file.nodeid"), SpecializedType.Depth.ZERO, (IProgressMonitor)new NullProgressMonitor()).iterator().next();
        return StrutsSearchUtil.getModuleForILink((ILink)strutsFile, null);
    }

    public static final void log(Throwable e) {
        StrutsPlugin.getLogger().log(e);
    }
}

