/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.ui.refactoring;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.refactoring.processor.FileTextRange;
import com.ibm.etools.references.refactoring.processor.RenameTextRangeProcessor;
import com.ibm.etools.references.ui.refactoring.RenameTextWizard;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.refactoring.processors.AbstractStrutsRenameProcessor;
import com.ibm.etools.struts.refactoring.processors.RenameActionMappingProcessor;
import com.ibm.etools.struts.refactoring.processors.RenameFormBeanProcessor;
import com.ibm.etools.struts.refactoring.processors.RenameGlobalExceptionProcessor;
import com.ibm.etools.struts.refactoring.processors.RenameGlobalForwardProcessor;
import com.ibm.etools.struts.refactoring.processors.RenameLocalExceptionProcessor;
import com.ibm.etools.struts.refactoring.processors.RenameLocalForwardProcessor;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameStrutsArtifactHandler
extends AbstractHandler {
    private static final String NAME_ATTRIBUTE = "name=";
    private static final String PATH_ATTRIBUTE = "path=";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ILink link;
        Object o;
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection && (o = ((IStructuredSelection)sel).getFirstElement()) instanceof IAdaptable && (link = (ILink)((IAdaptable)o).getAdapter(ILink.class)) != null) {
            boolean isLocal;
            String scope;
            AbstractStrutsRenameProcessor processor = null;
            String attribute = null;
            if ("struts.action.link".equals(link.getSpecializedType().getId())) {
                processor = new RenameActionMappingProcessor();
                attribute = PATH_ATTRIBUTE;
            } else if ("struts.formbean.link".equals(link.getSpecializedType().getId())) {
                processor = new RenameFormBeanProcessor();
                attribute = NAME_ATTRIBUTE;
            } else if ("struts.exception.link".equals(link.getSpecializedType().getId())) {
                scope = link.getParameter("struts.paramScope");
                boolean bl = isLocal = scope != null && !scope.equals("global");
                processor = isLocal ? new RenameLocalExceptionProcessor() : new RenameGlobalExceptionProcessor();
            } else if ("struts.forward.link".equals(link.getSpecializedType().getId())) {
                scope = link.getParameter("struts.paramScope");
                isLocal = scope != null && !scope.equals("global");
                processor = isLocal ? new RenameLocalForwardProcessor() : new RenameGlobalForwardProcessor();
                attribute = NAME_ATTRIBUTE;
            }
            int offset = -1;
            int length = -1;
            String oldTxt = null;
            if ("struts.exception.link".equals(link.getSpecializedType().getId())) {
                if (link.getLinkLocation() != null) {
                    TextRange range = AbstractWebProvider.createTrimmedRange((ILink)link);
                    offset = link.getLinkLocation().getOffset() + range.getOffset();
                    length = range.getLength();
                    oldTxt = link.getLinkText().substring(range.getOffset(), range.getLength() + range.getOffset());
                }
            } else if (link.getName() != null) {
                String context = link.getContextText();
                int index = context.indexOf(attribute);
                index = context.indexOf(link.getName(), index + attribute.length());
                if (index >= 0) {
                    offset = link.getContextLocation().getOffset() + index;
                    length = link.getName().length();
                    oldTxt = link.getContextText().substring(index, length + index);
                }
            }
            if (offset >= 0) {
                FileTextRange fileTextRange = new FileTextRange((IFile)link.getContainer().getResource(), length, offset);
                RenameTextWizard wizard = new RenameTextWizard(oldTxt, fileTextRange, (RenameTextRangeProcessor)processor);
                RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                try {
                    operation.run(activeShell, ResourceHandler.RenameStrutsArtifactHandler_RenameStrutsArtifact);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return null;
    }
}

