/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.ui.overlay;

import com.ibm.etools.struts.Images;
import com.ibm.etools.struts.ui.overlay.StrutsImageInfo;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class StrutsCompositeImageDescriptor
extends CompositeImageDescriptor {
    private static final int SIDE_PADDING = 1;
    private StrutsImageInfo info;

    public StrutsCompositeImageDescriptor(StrutsImageInfo info) {
        this.info = info;
        this.initBaseImageData();
    }

    public StrutsCompositeImageDescriptor(StrutsImageType type, boolean showExtends, int status) {
        this.info = new StrutsImageInfo(type, showExtends, status);
        this.initBaseImageData();
    }

    private void drawBaseImage() {
        this.drawImage(this.info.getBaseImageData(), 1, 1);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawBaseImage();
        if (this.info.hasExtends()) {
            this.drawExtendsOverlay();
        }
        this.drawStatusOverlay();
    }

    private void drawExtendsOverlay() {
        ImageData did = Images.getOverrides().getImageData();
        ImageData id = this.info.getBaseImageData();
        int xValue = id.width;
        int yValue = id.height;
        this.drawImage(did, xValue - 5, yValue - 5);
    }

    private void drawStatusOverlay() {
        ImageData did = null;
        switch (this.info.getStatus()) {
            case 2: {
                did = Images.getWarningProjectExplorer().getImageData();
                break;
            }
            case 4: {
                did = Images.getErrorProjectExplorer().getImageData();
            }
        }
        if (did != null) {
            ImageData id = this.info.getBaseImageData();
            int yValue = id.height;
            this.drawImage(did, -5, yValue - 10);
        }
    }

    protected Point getSize() {
        ImageData id = this.info.getBaseImageData();
        return new Point(id.width + 2, id.height + 2);
    }

    private void initBaseImageData() {
        if (this.info.getBaseImageData() != null) {
            return;
        }
        switch (this.info.getType()) {
            case WILDCARD_ACTIONMAPPING: {
                this.info.setBaseImageData(Images.getWildcardActionMapping16().getImageData());
                break;
            }
            case ACTIONMAPPING: {
                this.info.setBaseImageData(Images.getActionMapping16().getImageData());
                break;
            }
            case DATASOURCE: {
                this.info.setBaseImageData(Images.getDataSource16().getImageData());
                break;
            }
            case EXCEPTION: {
                this.info.setBaseImageData(Images.getExceptions16().getImageData());
                break;
            }
            case FORMBEAN: {
                this.info.setBaseImageData(Images.getFormBean16().getImageData());
                break;
            }
            case FORMPROPERTY: {
                this.info.setBaseImageData(Images.getDataFormFieldGS16().getImageData());
                break;
            }
            case FORWARD: {
                this.info.setBaseImageData(Images.getForward16().getImageData());
                break;
            }
            case MESSAGE: {
                this.info.setBaseImageData(Images.getMessageResource16().getImageData());
                break;
            }
            case PLUGIN: {
                this.info.setBaseImageData(Images.getPluginClass16().getImageData());
                break;
            }
            case SETPROPERTY: {
                this.info.setBaseImageData(Images.getSetProperty().getImageData());
                break;
            }
            case CONTROLLER: {
                this.info.setBaseImageData(Images.getControllerServlet16().getImageData());
                break;
            }
            case STRUTSCONFIG: {
                this.info.setBaseImageData(Images.getStrutsConfig16().getImageData());
                break;
            }
            default: {
                this.info.setBaseImageData(Images.getUnused16().getImageData());
            }
        }
    }

    public static enum StrutsImageType {
        ACTIONMAPPING,
        CONTROLLER,
        DATASOURCE,
        EXCEPTION,
        FORMBEAN,
        FORMPROPERTY,
        FORWARD,
        MESSAGE,
        PLUGIN,
        SETPROPERTY,
        STRUTSCONFIG,
        UNKNOWN,
        WILDCARD_ACTIONMAPPING;

    }
}

