/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.treeviewer;

import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.nls.ResourceHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;

public class OpenToJavaClassAction
extends Action {
    private IProject project;
    private String className;
    private IType classType;

    public OpenToJavaClassAction() {
        this.setText(this.getDefaultString());
    }

    public OpenToJavaClassAction(IProject projectContext, String className) {
        this.setText(this.getDefaultString());
        this.project = projectContext;
        this.className = className;
    }

    public boolean canActionBeAdded() {
        this.classType = this.findIType(this.project, this.className);
        return this.classType != null;
    }

    private IType findIType(IProject project, String className) {
        if (project == null || className == null || className.length() <= 0) {
            return null;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                return javaProject.findType(className);
            }
            catch (JavaModelException jme) {
                StrutsPlugin.getLogger().log((Throwable)jme);
            }
        }
        return null;
    }

    public String getDefaultString() {
        return ResourceHandler.WebStructure_action_OpenToJavaClass;
    }

    public IType getType() {
        return this.classType;
    }

    public void run() {
        this.classType = this.findIType(this.project, this.className);
        if (this.classType == null) {
            return;
        }
        try {
            IEditorPart editorPart = JavaUI.openInEditor((IJavaElement)this.classType);
            if (editorPart != null) {
                JavaUI.revealInEditor((IEditorPart)editorPart, (IJavaElement)this.classType);
            }
        }
        catch (PartInitException pie) {
            StrutsPlugin.getLogger().log((Throwable)pie);
        }
        catch (JavaModelException jme) {
            StrutsPlugin.getLogger().log((Throwable)jme);
        }
    }

    public void setClassName(String newName) {
        this.className = newName;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

