/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.treeviewer;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.util.StrutsUtil;
import com.ibm.etools.struts.utilities.StrutsSelectorDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ILinkActionUtilities {
    private static ILinkActionUtilities anInstance = new ILinkActionUtilities();
    public static final int DEFAULT_LINE = -1;
    public static final int DEFAULT_START_COL = -1;
    public static final int DEFAULT_END_COL = -1;

    private static String getConfigFileSelectionFromUser(List names, IVirtualComponent component) {
        StrutsSelectorDialog dialog = StrutsUtil.createStrutsConfigSelectionDialog(component);
        if (dialog != null) {
            dialog.setData(names);
            dialog.open();
            if (dialog.getReturnCode() == 0 && !dialog.getSelection().equals("")) {
                return dialog.getSelection();
            }
        }
        return "";
    }

    protected static IFile getConfigFileWithUserInput(IVirtualComponent component, String moduleName, boolean allConfiguredFiles) {
        String selectedConfig;
        List configNames = ILinkActionUtilities.getSortedConfigFileList(component, moduleName, allConfiguredFiles);
        if (configNames == null || configNames.isEmpty()) {
            return null;
        }
        String string = selectedConfig = configNames.size() > 1 ? ILinkActionUtilities.getConfigFileSelectionFromUser(configNames, component) : (String)configNames.get(0);
        if (!selectedConfig.equals("")) {
            return Model2Util.fileFor((IVirtualComponent)component, (String)selectedConfig);
        }
        return null;
    }

    private static Collection getConfigNames(IVirtualComponent component, String moduleName, boolean allConfiguredFiles) {
        Set scLinks;
        if (component == null) {
            return null;
        }
        try {
            scLinks = StrutsProjectCoreUtil.getStrutsVersion((IProject)component.getProject()) >= 1 && allConfiguredFiles ? StrutsSearchUtil.getStrutsConfigFileLinks((IProject)component.getProject(), null) : StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)component.getProject(), (String)moduleName, null);
        }
        catch (ReferenceException e) {
            e.printStackTrace();
            scLinks = Collections.emptySet();
        }
        Collection list = StrutsSearchUtil.convertPathsToStrings((Collection)StrutsSearchUtil.convertFilesToDocRootRelativePaths((Collection)StrutsSearchUtil.convertLinksToFiles(scLinks)));
        return list;
    }

    protected static List getSortedConfigFileList(IVirtualComponent component, String moduleName, boolean allConfiguredFiles) {
        ArrayList configNames = new ArrayList(ILinkActionUtilities.getConfigNames(component, moduleName, allConfiguredFiles));
        if (configNames == null || configNames.isEmpty() || configNames.size() == 1) {
            return configNames;
        }
        Collections.sort(configNames);
        return configNames;
    }

    protected static boolean hasStrutsConfigFile(IVirtualComponent component, String moduleName, boolean allConfiguredFiles) {
        Collection configNames = ILinkActionUtilities.getConfigNames(component, moduleName, allConfiguredFiles);
        if (configNames == null || configNames.isEmpty()) {
            return false;
        }
        return !configNames.isEmpty();
    }

    public static IEditorPart openEditorOnFile(IFile selectedResource) {
        return anInstance.instanceOpenEditorOnFile(selectedResource);
    }

    public static IEditorPart openEditorOnMarker(IMarker marker) {
        return anInstance.instanceOpenEditorOnMarker(marker);
    }

    public static IEditorPart openSCFEditorOnFile(IFile selectedResource) {
        return anInstance.instanceOpenSCFEditorOnFile(selectedResource);
    }

    private IEditorPart instanceOpenEditorOnFile(IFile selectedResource) {
        if (selectedResource == null) {
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            return IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)selectedResource, (boolean)true);
        }
        catch (PartInitException partInitException) {
            String title = ResourceHandler.WebStructure_openEditorFailed_title;
            String message = NLS.bind((String)ResourceHandler.WebStructure_openEditorFailed_message, (Object)selectedResource.getName());
            MessageDialog.openInformation((Shell)window.getShell(), (String)title, (String)message);
            return null;
        }
    }

    private IEditorPart instanceOpenEditorOnMarker(IMarker marker) {
        if (marker == null) {
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            return IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IMarker)marker, (boolean)true);
        }
        catch (PartInitException partInitException) {
            String title = ResourceHandler.WebStructure_openEditorFailed_title;
            String message = NLS.bind((String)ResourceHandler.WebStructure_openEditorFailed_message, (Object)marker.getResource().getName());
            MessageDialog.openInformation((Shell)window.getShell(), (String)title, (String)message);
            return null;
        }
    }

    private IEditorPart instanceOpenSCFEditorOnFile(IFile selectedResource) {
        if (selectedResource == null) {
            return null;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            return IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)selectedResource, (String)"com.ibm.etools.struts.editor.strutsconfig", (boolean)true);
        }
        catch (PartInitException partInitException) {
            String title = ResourceHandler.WebStructure_openEditorFailed_title;
            String message = NLS.bind((String)ResourceHandler.WebStructure_openEditorFailed_message, (Object)selectedResource.getName());
            MessageDialog.openInformation((Shell)window.getShell(), (String)title, (String)message);
            return null;
        }
    }
}

