/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.validator;

import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.cache.SubClassLookupCache;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.SetProperty;
import com.ibm.etools.struts.strutsconfig.validator.ModelReaderForStrutsConfigValidation;
import com.ibm.etools.struts.strutsconfig.validator.SetPropertyValidator;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageCollector;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageItem;
import com.ibm.etools.struts.strutsconfig.validator.ValidateUtil;
import com.ibm.etools.struts.util.StrutsLinksSearchUtil;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class WildcardSetPropertyValidator
extends SetPropertyValidator {
    private ActionMapping action;
    private ActionMappingWildcardUtil wildcardUtil;

    public WildcardSetPropertyValidator(IFile file, ModelReaderForStrutsConfigValidation reader, SubClassLookupCache cache) {
        super(file, reader, cache);
    }

    private void addProblems(ValidateMessageCollector problemCollector, ValidateMessageItem msg) {
        msg.setAttribute("TargetResource", this.getFile());
        problemCollector.addItem(msg);
    }

    public ActionMapping getAction() {
        return this.action;
    }

    public ActionMappingWildcardUtil getWildcardUtil() {
        return this.wildcardUtil;
    }

    public void setAction(ActionMapping action) {
        this.action = action;
    }

    public void setWildcardUtil(ActionMappingWildcardUtil wildcardUtil) {
        this.wildcardUtil = wildcardUtil;
    }

    @Override
    protected void validateKeyAttribute(SetProperty setProperty, ValidateMessageCollector problemCollector) {
        String rawValue = setProperty.getKey();
        if (StrutsProjectCoreUtil.isStruts1_3((IProject)this.project)) {
            if (!this.wildcardUtil.actionHasWildcards() && this.wildcardUtil.attributeHasTokens(rawValue)) {
                this.addProblems(problemCollector, ValidateMessageItem.getAttributeTokenUseInAMWithNoWildcardsMessageItem(setProperty, "key", rawValue));
            } else if (this.wildcardUtil.actionHasWildcards() && !this.wildcardUtil.isAttributeTokenUseValid(rawValue)) {
                this.addProblems(problemCollector, ValidateMessageItem.getInvalidParameterTokenInSetPropertyAttributeMessageItem(setProperty, "key", rawValue, String.valueOf(this.wildcardUtil.getNumberWildcards())));
            }
        } else {
            super.validateKeyAttribute(setProperty, problemCollector);
        }
    }

    @Override
    protected void validatePropertyAttribute(SetProperty setProperty, ValidateMessageCollector problemCollector) {
        String rawValue = setProperty.getProperty();
        if (StrutsProjectCoreUtil.isStruts1_3((IProject)this.project)) {
            if (!this.wildcardUtil.actionHasWildcards() && this.wildcardUtil.attributeHasTokens(rawValue)) {
                this.addProblems(problemCollector, ValidateMessageItem.getAttributeTokenUseInAMWithNoWildcardsMessageItem(setProperty, "property", rawValue));
            } else if (this.wildcardUtil.actionHasWildcards() && !this.wildcardUtil.isAttributeTokenUseValid(rawValue)) {
                this.addProblems(problemCollector, ValidateMessageItem.getInvalidParameterTokenInSetPropertyAttributeMessageItem(setProperty, "property", rawValue, String.valueOf(this.wildcardUtil.getNumberWildcards())));
            } else {
                try {
                    Set<String> referencesToAction = StrutsLinksSearchUtil.getActionMappingIncomingReferences(this.project, this.action.getPath(), StrutsLinksSearchUtil.getStrutsModule(this.action, null), (IProgressMonitor)new NullProgressMonitor());
                    for (String refToAction : referencesToAction) {
                        String concreteProperty = this.wildcardUtil.getConcreteAttributeValue(rawValue, refToAction);
                        if (concreteProperty == null || ValidateUtil.isValidJavaIdentifier(concreteProperty)) continue;
                        this.addProblems(problemCollector, ValidateMessageItem.getInvalidJavaIdentifierUsedMessageItem(setProperty, "property", concreteProperty));
                    }
                }
                catch (ReferenceException e) {
                    StrutsPlugin.getLogger().log((Throwable)e);
                }
            }
        } else {
            super.validatePropertyAttribute(setProperty, problemCollector);
        }
    }

    @Override
    protected void validateValueAttribute(SetProperty setProperty, ValidateMessageCollector problemCollector) {
        String rawValue = setProperty.getValue();
        if (StrutsProjectCoreUtil.isStruts1_3((IProject)this.project)) {
            if (!this.wildcardUtil.actionHasWildcards() && this.wildcardUtil.attributeHasTokens(rawValue)) {
                this.addProblems(problemCollector, ValidateMessageItem.getAttributeTokenUseInAMWithNoWildcardsMessageItem(setProperty, "value", rawValue));
            } else if (this.wildcardUtil.actionHasWildcards() && !this.wildcardUtil.isAttributeTokenUseValid(rawValue)) {
                this.addProblems(problemCollector, ValidateMessageItem.getInvalidParameterTokenInSetPropertyAttributeMessageItem(setProperty, "value", rawValue, String.valueOf(this.wildcardUtil.getNumberWildcards())));
            }
        } else {
            super.validateValueAttribute(setProperty, problemCollector);
        }
    }
}

