/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.validator;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.strutsconfig.validator.ValidateEntityConstants;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ValidateUtil {
    private static final char[] invalid_special_characters = new char[]{'^'};
    private static final HashSet Valid_Pattern = new HashSet(4);

    static {
        Valid_Pattern.add("$M");
        Valid_Pattern.add("$x");
        Valid_Pattern.add("$$");
        Valid_Pattern.add("$P");
    }

    public static boolean beginsWithSlash(String str) {
        if (ValidateUtil.isEmpty(str)) {
            return false;
        }
        return '/' == str.charAt(0);
    }

    public static boolean containsValidMappingPathCharacters(String str) {
        if (str == null) {
            return false;
        }
        return ValidateUtil.isValidSpecialAlphaNumericString(str.toCharArray(), invalid_special_characters);
    }

    public static boolean containsWhitespace(String str) {
        return ValidateUtil.isStringContainWhiteSpace(str);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasValidImplementClass(IFile file, String class1, String implementClass) {
        if (file == null || implementClass == null || implementClass.length() == 0) {
            return true;
        }
        IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
        if (javaProject != null) {
            try {
                IType targetClassType = javaProject.findType(class1);
                if (targetClassType == null) {
                    return true;
                }
                ITypeHierarchy hierarchy = targetClassType.newSupertypeHierarchy(null);
                IType[] interfaces = hierarchy.getAllInterfaces();
                if (interfaces == null || interfaces.length == 0) {
                    return false;
                }
                int i = 0;
                while (true) {
                    if (i >= interfaces.length) {
                        return false;
                    }
                    if (implementClass.equals(interfaces[i].getFullyQualifiedName())) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (JavaModelException jme) {
                StrutsPlugin.getLogger().log((Throwable)jme);
            }
        }
        return true;
    }

    public static boolean isBeginsWithSlash(String str) {
        return ValidateUtil.beginsWithSlash(str);
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() < 1;
    }

    public static boolean isFirstLetterLowerCase(String str) {
        char c;
        return str != null && str.length() > 0 && (c = str.charAt(0)) == Character.toLowerCase(c);
    }

    public static boolean isStringContainWhiteSpace(String str) {
        if (ValidateUtil.isEmpty(str)) {
            return false;
        }
        int i = 0;
        while (i < ValidateEntityConstants.WHITE_SPACE.length) {
            if (str.indexOf(ValidateEntityConstants.WHITE_SPACE[i]) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isValidAttributeName(String str) {
        return true;
    }

    public static boolean isValidBeanName(String str) {
        return ValidateUtil.isValidJavaIdentifier(str);
    }

    public static boolean isValidBeanPropertyName(String str) {
        return ValidateUtil.isFirstLetterLowerCase(str) && ValidateUtil.isValidJavaIdentifier(str);
    }

    public static boolean isValidBooleanValue(String str) {
        return true;
    }

    public static boolean isValidCDataString(String str) {
        return true;
    }

    public static boolean isValidClassNameString(String str) {
        IStatus status = JavaConventions.validateJavaTypeName((String)str);
        return status.getSeverity() != 4;
    }

    public static boolean isValidContextRelativeURIPathString(String str, IFile file) {
        if (ValidateUtil.isValidRelativePathString(str, file)) {
            return ValidateUtil.beginsWithSlash(str);
        }
        return false;
    }

    public static boolean isValidFileSize(String inputSize) {
        char lastChar = inputSize.charAt(inputSize.length() - 1);
        if (Character.isDigit(lastChar)) {
            return ValidateUtil.isValidIntegerString(inputSize);
        }
        if (lastChar == 'M' || lastChar == 'G' || lastChar == 'K') {
            String trim = inputSize.substring(0, inputSize.length() - 1);
            return ValidateUtil.isValidIntegerString(trim);
        }
        return false;
    }

    public static boolean isValidFileSizeField(NamedNodeMap map, String attrib, String mofValue) {
        Node sizeStr = map == null ? null : map.getNamedItem(attrib);
        return sizeStr == null ? ValidateUtil.isValidFileSize(mofValue) : ValidateUtil.isValidFileSize(sizeStr.getNodeValue());
    }

    public static boolean isValidIntegerField(NamedNodeMap map, String attrib, String mofValue) {
        Node intName = map == null ? null : map.getNamedItem(attrib);
        return intName == null ? ValidateUtil.isValidIntegerString(mofValue) : ValidateUtil.isValidIntegerString(intName.getNodeValue());
    }

    public static boolean isValidIntegerString(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static boolean isValidJavaIdentifier(String str) {
        IStatus status = JavaConventions.validateFieldName((String)str);
        return status.getSeverity() != 4;
    }

    public static boolean isValidLocationString(String str, IFile file) {
        return ValidateUtil.isValidRelativePathString(str, file);
    }

    public static boolean isValidMappingPath(String str) {
        if (str == null) {
            return false;
        }
        return ValidateUtil.beginsWithSlash(str) && ValidateUtil.isValidSpecialAlphaNumericString(str.toCharArray(), invalid_special_characters);
    }

    public static boolean isValidPattern(String patternStr) {
        if (patternStr.length() % 2 != 0) {
            return false;
        }
        int begin = 0;
        int end = 2;
        while (end <= patternStr.length()) {
            String subStr = patternStr.substring(begin, end);
            if (!Valid_Pattern.contains(subStr)) {
                return false;
            }
            begin = end;
            end += 2;
        }
        return true;
    }

    public static boolean isValidPropNameString(String str) {
        return ValidateUtil.isValidBeanPropertyName(str);
    }

    public static boolean isValidRelativePathString(String str, IFile file) {
        if (str != null && str.length() > 0) {
            StringBuffer fileBuffer = new StringBuffer("file:///");
            fileBuffer.append(file.getFullPath().toString());
            URL context = null;
            try {
                context = new URL(fileBuffer.toString());
            }
            catch (MalformedURLException malformedURLException) {}
            if (context != null) {
                try {
                    new URL(context, str);
                    return true;
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return false;
    }

    public static boolean isValidRequestPathForRedirectedForward(String str, IFile file) {
        return true;
    }

    public static boolean isValidRequestScope(String str) {
        return true;
    }

    public static boolean isValidSpecialAlphaNumericString(char[] str, char[] invalid_characters) {
        if (str == null) {
            return false;
        }
        int i = 0;
        while (i < str.length) {
            if (!(str[i] >= 'A' && str[i] <= 'Z' || str[i] >= 'a' && str[i] <= 'z' || str[i] >= '0' && str[i] <= '9')) {
                boolean equalSpecial = false;
                char[] cArray = invalid_characters;
                int n = invalid_characters.length;
                int n2 = 0;
                while (n2 < n) {
                    char special = cArray[n2];
                    if (special == str[i]) {
                        equalSpecial = true;
                        break;
                    }
                    ++n2;
                }
                if (equalSpecial) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidSubClass(IProject project, String class1, String parentClass) {
        if (project == null) {
            return true;
        }
        if (parentClass == null || parentClass.length() == 0) {
            return true;
        }
        if (parentClass.equals(class1)) {
            return true;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            IType targetClassType;
            block7: {
                targetClassType = javaProject.findType(class1);
                if (targetClassType != null) break block7;
                return true;
            }
            try {
                return Model2Util.isExtenderOf((IType)targetClassType, (String)parentClass);
            }
            catch (JavaModelException jme) {
                StrutsPlugin.getLogger().log((Throwable)jme);
            }
        }
        return true;
    }

    public static boolean isValidTypeReference(IFile file, String className) {
        if (!ValidateUtil.isValidClassNameString(className)) {
            return false;
        }
        IProject project = file.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                IType targetClassType = javaProject.findType(className);
                if (targetClassType != null) {
                    return true;
                }
            }
            catch (JavaModelException jme) {
                StrutsPlugin.getLogger().log((Throwable)jme);
            }
        }
        return false;
    }

    public static boolean mappingPathHasWildcardCharacters(String path) {
        if (ValidateUtil.containsValidMappingPathCharacters(path)) {
            return path.indexOf(42) > -1 || path.indexOf(92) > -1;
        }
        return false;
    }

    public static IStatus validateFormBeanName(String fbn) {
        return JavaConventions.validateFieldName((String)fbn);
    }

    public static IStatus validateJavaIdentifier(String str) {
        return JavaConventions.validateFieldName((String)str);
    }
}

