/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.validator;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.struts.StrutsPlugin;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.wst.validation.internal.TaskListUtility;

public class StrutsMarkerUtil {
    public static final String M_MESSAGE = "message";
    public static final String M_SEVERITY = "severity";
    public static final String M_LINENUMBER = "lineNumber";
    public static final String M_CHARSTART = "charStart";
    public static final String M_CHAREND = "charEnd";
    public static final String M_LOCATION = "location";
    public static final int NO_MARKER_SEVERITY = -1;
    public static final int HIGHEST_SEVERITY = 2;
    public static final int DEFAULT_LINE = -1;
    public static final int DEFAULT_CHAR_START = -1;
    public static final int DEFAULT_CHAR_END = -1;

    private StrutsMarkerUtil() {
    }

    public static int getCharEnd(IMarker marker) {
        return StrutsMarkerUtil.getIntAttribute(marker, M_CHAREND, -1);
    }

    public static int getCharStart(IMarker marker) {
        return StrutsMarkerUtil.getIntAttribute(marker, M_CHARSTART, -1);
    }

    private static IMarker[] getChildrenMarkersForPart(IFile file, ILink link) {
        IMarker[] problemMarkers;
        ArrayList<IMarker> filteredMarkers = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = problemMarkers = StrutsMarkerUtil.getValidationMarkersForFile(file);
        int n = problemMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            int end;
            int length;
            int start;
            TextRange markerRange;
            IMarker marker = iMarkerArray[n2];
            TextRange linkRange = link.getContextLocation();
            if (linkRange.contains(markerRange = new TextRange(start = StrutsMarkerUtil.getCharStart(marker), length = (end = StrutsMarkerUtil.getCharEnd(marker)) - start, 0))) {
                filteredMarkers.add(marker);
            }
            ++n2;
        }
        return filteredMarkers.toArray(new IMarker[filteredMarkers.size()]);
    }

    public static int getHighestSeverity(IMarker[] markers) {
        if (markers == null || markers.length == 0) {
            return -1;
        }
        boolean hasWarning = false;
        boolean hasInfo = false;
        int i = 0;
        while (i < markers.length) {
            block10: {
                Integer sevLevel;
                block11: {
                    IMarker marker = markers[i];
                    if (!marker.exists() || (sevLevel = (Integer)markers[i].getAttribute(M_SEVERITY)) == null) break block10;
                    if (sevLevel != 2) break block11;
                    return 2;
                }
                try {
                    if (sevLevel == 1) {
                        hasWarning = true;
                    } else if (sevLevel == 0) {
                        hasInfo = true;
                    }
                }
                catch (CoreException ce) {
                    StrutsPlugin.getLogger().log((Throwable)ce);
                }
            }
            ++i;
        }
        if (hasWarning) {
            return 1;
        }
        if (hasInfo) {
            return 0;
        }
        return -1;
    }

    private static int getHighestSeverityForChildrenParts(IFile file, ILink link) {
        IMarker[] childrenMarkers = StrutsMarkerUtil.getChildrenMarkersForPart(file, link);
        return StrutsMarkerUtil.getHighestSeverity(childrenMarkers);
    }

    public static int getHighestSeverityForFile(IFile file) {
        return StrutsMarkerUtil.getHighestSeverity(StrutsMarkerUtil.getMarkersForFile(file));
    }

    public static int getHighestSeverityForPart(IFile file, ILink link) {
        IMarker[] allMarkers = StrutsMarkerUtil.getMarkersForFile(file);
        if (allMarkers == null || allMarkers.length == 0) {
            return -1;
        }
        ArrayList<IMarker> matchedMarkers = new ArrayList<IMarker>();
        int i = 0;
        while (i < allMarkers.length) {
            int start = MarkerUtilities.getCharStart((IMarker)allMarkers[i]);
            int end = MarkerUtilities.getCharEnd((IMarker)allMarkers[i]);
            int length = end - start;
            TextRange markerRange = new TextRange(start, length, 0);
            TextRange linkRange = link.getLinkLocation();
            if (linkRange.contains(markerRange)) {
                matchedMarkers.add(allMarkers[i]);
            }
            ++i;
        }
        IMarker[] markers = matchedMarkers.toArray(new IMarker[matchedMarkers.size()]);
        return StrutsMarkerUtil.getHighestSeverity(markers);
    }

    public static int getHighestSeverityForPartIncludingChildren(ILink link) {
        IFile file = (IFile)Platform.getAdapterManager().getAdapter((Object)link.getContainer().getResource(), IFile.class);
        if (file == null) {
            return -1;
        }
        return StrutsMarkerUtil.getHighestSeverityForPartIncludingChildren(link, file);
    }

    private static int getHighestSeverityForPartIncludingChildren(ILink link, IFile file) {
        int currentHighest = StrutsMarkerUtil.getHighestSeverityForPart(file, link);
        if (currentHighest >= 2) {
            return currentHighest;
        }
        int childrenSeverity = StrutsMarkerUtil.getHighestSeverityForChildrenParts(file, link);
        return childrenSeverity > currentHighest ? childrenSeverity : currentHighest;
    }

    public static int getHighestSeverityForResource(IResource resource, int depth) {
        return StrutsMarkerUtil.getHighestSeverity(StrutsMarkerUtil.getMarkersForResource(resource, depth));
    }

    private static int getIntAttribute(IMarker marker, String attribute, int defaultValue) {
        try {
            if (!marker.exists()) {
                return defaultValue;
            }
            Integer lineNum = (Integer)marker.getAttribute(attribute);
            return lineNum == null ? defaultValue : lineNum;
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    public static int getLineNumber(IMarker marker) {
        return StrutsMarkerUtil.getIntAttribute(marker, M_LINENUMBER, -1);
    }

    private static IMarker[] getMarkersForFile(IFile file) {
        if (!StrutsMarkerUtil.isValidFile(file)) {
            return null;
        }
        try {
            IMarker[] fileMarkers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            return fileMarkers == null || fileMarkers.length == 0 ? null : fileMarkers;
        }
        catch (CoreException ce) {
            StrutsPlugin.getLogger().log((Throwable)ce);
            return null;
        }
    }

    private static IMarker[] getMarkersForResource(IResource resource, int depth) {
        try {
            IMarker[] fileMarkers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
            return fileMarkers == null || fileMarkers.length == 0 ? null : fileMarkers;
        }
        catch (CoreException ce) {
            StrutsPlugin.getLogger().log((Throwable)ce);
            return null;
        }
    }

    protected static IMarker[] getValidationMarkersForFile(IFile file) {
        if (!StrutsMarkerUtil.isValidFile(file)) {
            return new IMarker[0];
        }
        try {
            boolean ignoreLinksMarkers;
            IMarker[] validateMarkers = TaskListUtility.getValidationTasks((IResource)file, (int)7);
            IMarker[] linksMarkers = file.findMarkers(null, true, 0);
            boolean ignoreValidateMarkers = validateMarkers == null || validateMarkers.length == 0;
            boolean bl = ignoreLinksMarkers = linksMarkers == null || linksMarkers.length == 0;
            if (ignoreValidateMarkers) {
                if (!ignoreLinksMarkers) {
                    return linksMarkers;
                }
                return new IMarker[0];
            }
            if (ignoreLinksMarkers) {
                return validateMarkers;
            }
            if (linksMarkers != null && validateMarkers != null) {
                int count = linksMarkers.length + validateMarkers.length;
                IMarker[] newList = new IMarker[count];
                System.arraycopy(validateMarkers, 0, newList, 0, validateMarkers.length);
                System.arraycopy(linksMarkers, 0, newList, validateMarkers.length, linksMarkers.length);
                return newList;
            }
        }
        catch (CoreException ce) {
            StrutsPlugin.getLogger().log((Throwable)ce);
        }
        return new IMarker[0];
    }

    private static boolean isValidFile(IFile file) {
        return file != null && file.isAccessible();
    }
}

