/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.validator;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.references.web.javaee.taglib.WebEEUtil;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.cache.SubClassLookupCache;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.strutsconfig.validator.ModelReaderForStrutsConfigValidation;
import com.ibm.etools.struts.strutsconfig.validator.StrutsConfigFileValidator;
import com.ibm.etools.struts.strutsconfig.validator.StrutsConfigHelper;
import com.ibm.etools.struts.strutsconfig.validator.StrutsValidationEditModelHolder;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageCollector;
import com.ibm.etools.struts.util.StrutsArtifactEdit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationFramework;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class StrutsConfigValidator
extends AbstractValidator
implements IValidator {
    private static final int[] FULL_VALIDATE_LEVEL = new int[1];
    private IValidationContext helper;
    private IReporter reporter;
    private IProgressMonitor strutsMonitor = null;
    private IStatus status;
    private ValidationResult vr;

    public void cleanup(IReporter reporter) {
        this.reporter = null;
        this.helper = null;
        this.status = null;
    }

    private void clearMarkers(IReporter reporter, int validationLevel, IFile file) {
        if (validationLevel == 0) {
            try {
                ValidationFramework.getDefault().clearMessages((IResource)file, "com.ibm.etools.struts.StrutsConfigValidator");
            }
            catch (CoreException coreException) {}
        } else {
            int i = validationLevel;
            while (i <= 4) {
                reporter.removeMessageSubset((IValidator)this, (Object)file, String.valueOf(i));
                ++i;
            }
        }
    }

    private Collection<IFile> conditionalValidateDefaultConfigs(IVirtualComponent component, SubClassLookupCache cache, HashSet matchedFiles) {
        Set scLinks = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)component.getProject(), (String)"", (IProgressMonitor)this.strutsMonitor);
        Collection defaultConfigs = StrutsSearchUtil.convertLinksToFiles((Collection)scLinks);
        Iterator iter = defaultConfigs.iterator();
        while (iter.hasNext()) {
            if (!matchedFiles.contains(iter.next())) continue;
            this.validateConfigsSet(component, defaultConfigs, cache);
            return defaultConfigs;
        }
        return Collections.emptyList();
    }

    public IValidationContext getHelper() {
        return this.helper;
    }

    public IReporter getReporter() {
        return this.reporter;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    private StrutsConfigFileValidator getStrutsConfigFileValidator(IVirtualComponent component) {
        return new StrutsConfigFileValidator();
    }

    private String getWebXMLName(IVirtualComponent component) {
        IPath webXml = WebEEUtil.getWebXmlPath((IProject)component.getProject());
        if (webXml != null) {
            return webXml.toString();
        }
        return null;
    }

    private boolean isValidModel(StrutsArtifactEdit model) {
        return model.getIDOMModel() != null && model.getStrutsConfig() != null;
    }

    public HashSet matchStrutsXML(IVirtualComponent component, HashSet deltaSet) {
        Set scLinks = StrutsSearchUtil.getStrutsConfigFileLinks((IProject)component.getProject(), (IProgressMonitor)this.strutsMonitor);
        Collection list = StrutsSearchUtil.convertLinksToFiles((Collection)scLinks);
        HashSet<IFile> matchedSet = null;
        for (IFile file : list) {
            if (!deltaSet.contains(file.getFullPath().toString())) continue;
            if (matchedSet == null) {
                matchedSet = new HashSet<IFile>();
            }
            matchedSet.add(file);
        }
        return matchedSet;
    }

    private void setHelper(IValidationContext helper) {
        this.helper = helper;
    }

    private void setReporter(IReporter reporter) {
        this.reporter = reporter;
    }

    public void setStatus(IStatus status) {
        this.status = status;
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        this.vr = new ValidationResult();
        if (resource == null || !(resource instanceof IFile)) {
            return this.vr;
        }
        this.strutsMonitor = monitor;
        IReporter rh = this.vr.getReporter(monitor);
        StrutsConfigHelper sch = new StrutsConfigHelper();
        sch.setCurrentFile((IFile)resource);
        sch.setProject(resource.getProject());
        LinkedList<String> files = new LinkedList<String>();
        files.add(resource.getFullPath().toString());
        sch.setValidationFileURIs(files);
        try {
            this.validate((IValidationContext)sch, rh);
        }
        catch (ValidationException validationException) {}
        return this.vr;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        if (reporter != null && helper instanceof StrutsConfigHelper) {
            StrutsConfigHelper scHelper = (StrutsConfigHelper)helper;
            IProject proj = scHelper.getProject();
            if (proj == null) {
                return;
            }
            IVirtualComponent component = Model2Util.findComponent((IResource)proj);
            if (component == null) {
                return;
            }
            int strutsVersion = StrutsProjectCoreUtil.getStrutsVersion((IProject)proj);
            if (strutsVersion != -1) {
                this.setHelper(helper);
                this.setReporter(reporter);
                try {
                    String[] changedFiles = helper.getURIs();
                    if (changedFiles == null || changedFiles.length == 0) {
                        this.validateAll(component);
                    } else {
                        this.validateForChangedFiles(component, changedFiles);
                    }
                }
                catch (Exception exception) {
                    StrutsPlugin.getLogger().log((Throwable)exception);
                }
            }
        }
    }

    public void validateAll(IVirtualComponent component) {
        SubClassLookupCache subclassCache = SubClassLookupCache.getSubClassLookupCache(component, true);
        try {
            Set scLinks;
            Collection strutsConfigs;
            Collection validatedConfigs = this.validateDefaultConfigs(component, subclassCache);
            if (this.reporter.isCancelled()) {
                return;
            }
            if (StrutsProjectCoreUtil.getStrutsVersion((IProject)component.getProject()) >= 1 && (strutsConfigs = StrutsSearchUtil.convertLinksToFiles((Collection)(scLinks = StrutsSearchUtil.getStrutsConfigFileLinks((IProject)component.getProject(), (IProgressMonitor)this.strutsMonitor)))) != null && strutsConfigs.size() != 0) {
                if (validatedConfigs != null) {
                    strutsConfigs.removeAll(validatedConfigs);
                }
                this.validateModuleConfigFiles(component, strutsConfigs, subclassCache);
            }
        }
        finally {
            subclassCache.markValidateAll();
        }
    }

    private void validateConfigsSet(IVirtualComponent component, Collection<IFile> configList, SubClassLookupCache subclassCache) {
        int[] validationlevel = new int[configList.size()];
        Arrays.fill(validationlevel, 0);
        IFile[] strutsFiles = configList.toArray(new IFile[configList.size()]);
        this.validateDeltaForConfiguredSubset(strutsFiles, validationlevel, component, subclassCache);
    }

    private Collection validateDefaultConfigs(IVirtualComponent component, SubClassLookupCache subclassCache) {
        Set scLinks = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)component.getProject(), (String)"", (IProgressMonitor)this.strutsMonitor);
        Collection files = StrutsSearchUtil.convertLinksToFiles((Collection)scLinks);
        this.validateConfigsSet(component, files, subclassCache);
        return files;
    }

    private void validateDeltaForConfiguredSubset(IFile[] strutsFiles, int[] validateLevel, IVirtualComponent component, SubClassLookupCache subclassCache) {
        ModelReaderForStrutsConfigValidation reader = new ModelReaderForStrutsConfigValidation(strutsFiles);
        StrutsValidationEditModelHolder modelHolder = null;
        StrutsConfigHelper helper = (StrutsConfigHelper)this.getHelper();
        StrutsConfigFileValidator validator = this.getStrutsConfigFileValidator(component);
        try {
            int i = 0;
            while (i < strutsFiles.length) {
                block14: {
                    if (this.reporter.isCancelled()) {
                        return;
                    }
                    IFile scFile = strutsFiles[i];
                    helper.setCurrentFile(scFile);
                    modelHolder = new StrutsValidationEditModelHolder(scFile);
                    StrutsArtifactEdit strutsEditModel = modelHolder.getStrutsArtifactEdit();
                    if (strutsEditModel != null) {
                        try {
                            try {
                                this.clearMarkers(this.getReporter(), validateLevel[i], scFile);
                                if (this.isValidModel(strutsEditModel)) {
                                    ValidateMessageCollector collector = new ValidateMessageCollector(this.getReporter(), this);
                                    validator.validate(collector, strutsEditModel, reader, this.getReporter(), validateLevel[i], subclassCache);
                                }
                            }
                            catch (Exception e) {
                                StrutsPlugin.getLogger().log((Throwable)e);
                                strutsEditModel = null;
                                modelHolder.releaseModel();
                                modelHolder = null;
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            strutsEditModel = null;
                            modelHolder.releaseModel();
                            modelHolder = null;
                            throw throwable;
                        }
                        strutsEditModel = null;
                        modelHolder.releaseModel();
                        modelHolder = null;
                    }
                }
                ++i;
            }
        }
        finally {
            reader.releaseAllModels();
            reader = null;
            validator = null;
            if (this.vr != null) {
                this.vr.setSuspendValidation(component.getProject());
            }
        }
    }

    public void validateForChangedFiles(IVirtualComponent component, String[] changedFiles) {
        String webXMLName = this.getWebXMLName(component);
        if (webXMLName == null || webXMLName.length() == 0) {
            return;
        }
        HashSet<String> deltaSet = new HashSet<String>();
        String deltaFileName = null;
        String[] stringArray = changedFiles;
        int n = changedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String element2 = stringArray[n2];
            deltaFileName = element2;
            if (deltaFileName.equals(webXMLName)) {
                this.validateAll(component);
                return;
            }
            if (deltaFileName.endsWith(".java")) {
                if (SubClassLookupCache.isCachValid(component)) {
                    Path path = new Path(deltaFileName);
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    IJavaElement element = JavaCore.create((IFile)file);
                    if (element != null && element.getElementType() == 5) {
                        try {
                            IType[] types = ((ICompilationUnit)element).getTypes();
                            if (types != null && types.length > 0 && !SubClassLookupCache.isReferencedClass(component, types[0].getFullyQualifiedName())) {
                                return;
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                }
                this.validateAll(component);
                return;
            }
            deltaSet.add(deltaFileName);
            ++n2;
        }
        HashSet matched = this.matchStrutsXML(component, deltaSet);
        if (matched != null) {
            this.validateSubset(component, matched);
        }
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        if (helper != null && reporter != null) {
            this.validate(helper, reporter);
        }
        Status OK_STATUS = new Status(0, "org.eclipse.wst.validation", 0, "OK", null);
        return this.status == null ? OK_STATUS : this.status;
    }

    private void validateModuleConfigFiles(IVirtualComponent component, Collection strutsFiles, SubClassLookupCache subclassCache) {
        if (strutsFiles.size() == 0) {
            return;
        }
        IFile[] fileArray = new IFile[1];
        Iterator iter = strutsFiles.iterator();
        while (iter.hasNext()) {
            fileArray[0] = (IFile)iter.next();
            this.validateDeltaForConfiguredSubset(fileArray, FULL_VALIDATE_LEVEL, component, subclassCache);
        }
    }

    public void validateSubset(IVirtualComponent component, HashSet matchedSet) {
        SubClassLookupCache subclassCache = SubClassLookupCache.getSubClassLookupCache(component, true);
        try {
            Collection<IFile> validatedConfigs = this.conditionalValidateDefaultConfigs(component, subclassCache, matchedSet);
            if (StrutsProjectCoreUtil.getStrutsVersion((IProject)component.getProject()) >= 1) {
                if (validatedConfigs != null) {
                    matchedSet.removeAll(validatedConfigs);
                }
                this.validateModuleConfigFiles(component, matchedSet, subclassCache);
            }
        }
        finally {
            subclassCache.dispose();
        }
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
        super.validationFinishing(project, state, monitor);
        this.reporter = null;
        this.helper = null;
        this.status = null;
    }
}

