/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.validator;

import com.ibm.etools.struts.cache.SubClassLookupCache;
import com.ibm.etools.struts.emf.strutsconfig.Controller;
import com.ibm.etools.struts.strutsconfig.validator.ModelReaderForStrutsConfigValidation;
import com.ibm.etools.struts.strutsconfig.validator.SetPropertyContainerValidator;
import com.ibm.etools.struts.strutsconfig.validator.StrutsConfigPartsUtil;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageCollector;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageItem;
import com.ibm.etools.struts.strutsconfig.validator.ValidateUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ControllerValidator
extends SetPropertyContainerValidator {
    public static final String ID = "id";
    public static final String BUFFER_SIZE = "bufferSize";
    public static final String CLASS_NAME = "className";
    public static final String CONTENT_TYPE = "contentType";
    public static final String DEBUG = "debug";
    public static final String FORWARD_PATTERN = "forwardPattern";
    public static final String INPUT_FORWARD = "inputForward";
    public static final String LOCALE = "locale";
    public static final String MAX_FILE_SIZE = "maxFileSize";
    public static final String MEM_FILE_SIZE = "memFileSize";
    public static final String MULTI_PART_CLASS = "multipartClass";
    public static final String NO_CACHE = "nocache";
    public static final String PAGE_PATTERN = "pagePattern";
    public static final String PROCESSOR_CLASS = "processorClass";
    public static final String TEMP_DIR = "tempDir";

    public ControllerValidator(IFile file, ModelReaderForStrutsConfigValidation reader, SubClassLookupCache cache) {
        super(file, reader, cache);
    }

    private void addProblems(ValidateMessageCollector problemCollector, ValidateMessageItem msg) {
        msg.setAttribute("TargetResource", this.getFile());
        problemCollector.addItem(msg);
    }

    @Override
    protected String getUniqueKeyString(EObject refObject) {
        return StrutsConfigPartsUtil.getUniqueNameForController((Controller)refObject);
    }

    @Override
    public boolean hasDuplicateInImage(EObject strutsMofPart) {
        return this.getReader().hasDuplicateController(strutsMofPart);
    }

    private void validateClassNames(SubClassLookupCache cache, IFile file, Controller controller, NamedNodeMap map, ValidateMessageCollector problemCollector) {
        String className;
        if (controller.isSetClassName() && !ControllerValidator.isValidSubclass(cache, className = ControllerValidator.getRawData(map, CLASS_NAME, controller.getClassName()), "org.apache.struts.config.ControllerConfig")) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidSubClassTypeMessageItem(controller, CLASS_NAME, className, "org.apache.struts.config.ControllerConfig"));
        }
        if (controller.isSetMultipartClass() && !ValidateUtil.hasValidImplementClass(file, className = ControllerValidator.getRawData(map, MULTI_PART_CLASS, controller.getMultipartClass()), "org.apache.struts.upload.MultipartRequestHandler")) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidImplementClassTypeMessageItem(controller, MULTI_PART_CLASS, className, "org.apache.struts.upload.MultipartRequestHandler"));
        }
        if (controller.isSetProcessorClass() && !ControllerValidator.isValidSubclass(cache, className = ControllerValidator.getRawData(map, PROCESSOR_CLASS, controller.getProcessorClass()), "org.apache.struts.action.RequestProcessor")) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidSubClassTypeMessageItem(controller, PROCESSOR_CLASS, className, "org.apache.struts.action.RequestProcessor"));
        }
    }

    @Override
    public void validateField(EObject container, ValidateMessageCollector problemCollector) {
        super.validateField(container, problemCollector);
        Controller controller = (Controller)container;
        Node node = ControllerValidator.getNode((Notifier)controller);
        NamedNodeMap map = node == null ? null : node.getAttributes();
        IFile file = this.getFile();
        this.validateClassNames(this.getCache(), file, controller, map, problemCollector);
        this.validateIntegerFields(controller, map, problemCollector);
        this.validateFileSize(controller, map, problemCollector);
        this.validatePattern(controller, map, problemCollector);
    }

    private void validateFileSize(Controller controller, NamedNodeMap map, ValidateMessageCollector problemCollector) {
        String memsize;
        String fileSize = ControllerValidator.getRawData(map, MAX_FILE_SIZE, null);
        if (fileSize != null && !ValidateUtil.isValidFileSize(fileSize)) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidFileSizeMessageItem(controller, MAX_FILE_SIZE, fileSize));
        }
        if ((memsize = ControllerValidator.getRawData(map, MEM_FILE_SIZE, null)) != null && !ValidateUtil.isValidFileSize(memsize)) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidFileSizeMessageItem(controller, MEM_FILE_SIZE, memsize));
        }
    }

    private void validateIntegerFields(Controller controller, NamedNodeMap map, ValidateMessageCollector problemCollector) {
        String intField = ControllerValidator.getRawData(map, BUFFER_SIZE, null);
        if (intField != null && !ValidateUtil.isValidIntegerString(intField)) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidIntegerMessageItem(controller, BUFFER_SIZE, intField));
        }
        if ((intField = ControllerValidator.getRawData(map, DEBUG, null)) != null && !ValidateUtil.isValidIntegerString(intField)) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidIntegerMessageItem(controller, DEBUG, intField));
        }
    }

    private void validatePattern(Controller controller, NamedNodeMap map, ValidateMessageCollector problemCollector) {
        String forwardPattern;
        String pagePattern;
        if (controller.isSetPagePattern() && !ValidateUtil.isValidPattern(pagePattern = ControllerValidator.getRawData(map, PAGE_PATTERN, controller.getPagePattern()))) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidPatternMessageItem(controller, PAGE_PATTERN, pagePattern));
        }
        if (controller.isSetForwardPattern() && !ValidateUtil.isValidPattern(forwardPattern = ControllerValidator.getRawData(map, FORWARD_PATTERN, controller.getForwardPattern()))) {
            this.addProblems(problemCollector, ValidateMessageItem.getInvalidPatternMessageItem(controller, FORWARD_PATTERN, forwardPattern));
        }
    }

    @Override
    public void validateReferences(EObject strutsMofPart, ValidateMessageCollector problemCollector) {
    }
}

