/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.validator;

import com.ibm.etools.struts.cache.SubClassLookupCache;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.emf.strutsconfig.ActionMapping;
import com.ibm.etools.struts.emf.strutsconfig.Exception0;
import com.ibm.etools.struts.emf.strutsconfig.Forward;
import com.ibm.etools.struts.emf.strutsconfig.SetProperty;
import com.ibm.etools.struts.strutsconfig.validator.DisplayableSetPropertyValidator;
import com.ibm.etools.struts.strutsconfig.validator.ExceptionValidator;
import com.ibm.etools.struts.strutsconfig.validator.ForwardValidator;
import com.ibm.etools.struts.strutsconfig.validator.ModelReaderForStrutsConfigValidation;
import com.ibm.etools.struts.strutsconfig.validator.StrutsConfigPartsUtil;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessage;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageCollector;
import com.ibm.etools.struts.strutsconfig.validator.ValidateMessageItem;
import com.ibm.etools.struts.strutsconfig.validator.ValidateUtil;
import com.ibm.etools.struts.strutsconfig.validator.WildcardSetPropertyValidator;
import com.ibm.etools.struts.util.StrutsLinksSearchUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ActionMappingValidator
extends DisplayableSetPropertyValidator {
    private static final String ATTRIBUTE = "attribute";
    private static final String CATALOG = "catalog";
    private static final String CLASS_NAME = "className";
    private static final String COMMAND = "command";
    public static String DFT_AM_CLSNAME = "org.apache.struts.action.ActionMapping";
    private static String DFT_AM_TYPE = "org.apache.struts.action.Action";
    private static final String FORWARD = "forward";
    private static final String INCLUDE = "include";
    private static final String INPUT = "input";
    private static final String NAME = "name";
    private static final String PARAMETER = "parameter";
    private static final String PATH = "path";
    private static final String PREFIX = "prefix";
    private static final String ROLES = "roles";
    private static final String SCOPE = "scope";
    private static final String SUFFIX = "suffix";
    private static final String TYPE = "type";
    private ExceptionValidator localExceptionValidator;
    private ForwardValidator localForwardValidator;
    private WildcardSetPropertyValidator wcSetPropertyValidator;
    private ActionMappingWildcardUtil wildCardValidatorUtil = null;

    public ActionMappingValidator(IFile file, ModelReaderForStrutsConfigValidation reader, SubClassLookupCache cache) {
        super(file, reader, cache);
        this.localForwardValidator = new ForwardValidator(file, reader, cache);
        this.localExceptionValidator = this.createExceptionValidator(file, reader, cache);
        this.wcSetPropertyValidator = new WildcardSetPropertyValidator(file, reader, cache);
    }

    private void addProblems(ValidateMessageCollector problemCollector, ValidateMessageItem msg) {
        msg.setAttribute("TargetResource", this.getFile());
        problemCollector.addItem(msg);
    }

    private ExceptionValidator createExceptionValidator(IFile file, ModelReaderForStrutsConfigValidation reader, SubClassLookupCache cache) {
        return new ExceptionValidator(file, reader, cache);
    }

    private void crossCheckCancelAndValidate(ActionMapping actionMapping, ValidateMessageCollector collector) {
        boolean isCancellable = actionMapping.isCancellable();
        boolean validate = actionMapping.isValidate();
        if (validate && !isCancellable) {
            this.addProblems(collector, ValidateMessageItem.getInvalidCancellableMessageItem(actionMapping));
        }
    }

    private void crossFieldNameChecking(ActionMapping action, ValidateMessageCollector problemCollector) {
        if (!action.isSetName()) {
            if (action.isSetAttribute()) {
                this.addProblems(problemCollector, this.getNameInvalidedAttributes(action, ATTRIBUTE));
            }
            if (action.isSetInput()) {
                this.addProblems(problemCollector, this.getNameInvalidedAttributes(action, INPUT));
            }
            if (action.isSetPrefix()) {
                this.addProblems(problemCollector, this.getNameInvalidedAttributes(action, PREFIX));
            }
            if (action.isSetScope()) {
                this.addProblems(problemCollector, this.getNameInvalidedAttributes(action, SCOPE));
            }
            if (action.isSetSuffix()) {
                this.addProblems(problemCollector, this.getNameInvalidedAttributes(action, SUFFIX));
            }
        }
    }

    private ValidateMessageItem getNameInvalidedAttributes(EObject part, String attrib) {
        return new ValidateMessageItem(ValidateMessage.INVALID_AM_MISSING_NAME, part, attrib, "");
    }

    @Override
    protected String getUniqueKeyString(EObject refObject) {
        return StrutsConfigPartsUtil.getUniqueNameForActionMapping((ActionMapping)refObject);
    }

    @Override
    public boolean hasDuplicateInImage(EObject strutsMofPart) {
        return this.getReader().hasDuplicateActionMapping(strutsMofPart);
    }

    private void validateActionMappingField(ActionMapping action, NamedNodeMap map, ValidateMessageCollector problemCollector) {
        this.validateAttribute(action, map, problemCollector);
        this.validateClassName(action, map, problemCollector);
        this.validateName(action, map, problemCollector);
        this.validatePath(action, map, problemCollector);
        this.validateType(action, map, problemCollector);
        this.validateSuffix(action, map, problemCollector);
        this.validatePrefix(action, map, problemCollector);
        if (StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)this.project)) {
            this.validateForward(action, map, problemCollector);
            this.validateInclude(action, map, problemCollector);
            this.validateInput(action, map, problemCollector);
            this.validateParameter(action, map, problemCollector);
            this.validateRoles(action, map, problemCollector);
        }
        if (StrutsProjectCoreUtil.isStruts1_3((IProject)this.project)) {
            super.validateExtendsAttribute(action, problemCollector);
            this.validateCatalog(action, map, problemCollector);
            this.validateCommand(action, map, problemCollector);
        }
    }

    private void validateAttribute(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        Node attribute = attrMap.getNamedItem(ATTRIBUTE);
        if (attribute != null) {
            String value = attribute.getNodeValue();
            if (!StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)this.project) || !this.wildCardValidatorUtil.attributeHasTokens(value)) {
                if (!ValidateUtil.isValidBeanName(value)) {
                    this.addProblems(problemCollector, ValidateMessageItem.getInvalidBeanNameMessageItem(action, ATTRIBUTE, value));
                }
            } else {
                Set<String> referencesToAction = StrutsLinksSearchUtil.getActionMappingRuntimePaths(this.project, action);
                String attributeValue = action.getAttribute();
                for (String refToAction : referencesToAction) {
                    String concreteAttributeValue = this.wildCardValidatorUtil.getConcreteAttributeValue(attributeValue, refToAction);
                    if (concreteAttributeValue == null || ValidateUtil.isValidBeanName(concreteAttributeValue)) continue;
                    this.addProblems(problemCollector, ValidateMessageItem.getInvalidTokenizedBeanNameMessageItem(action, ATTRIBUTE, concreteAttributeValue));
                }
                this.validateAttributeTokens(ATTRIBUTE, action, attrMap, problemCollector);
            }
        }
    }

    private void validateAttributeTokens(String attributeName, ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        Node attribute;
        if (StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)this.project) && this.wildCardValidatorUtil.isNumberOfWildcardsValid() && (attribute = attrMap.getNamedItem(attributeName)) != null) {
            String value = attribute.getNodeValue();
            if (!this.wildCardValidatorUtil.actionHasWildcards() && this.wildCardValidatorUtil.attributeHasTokens(value)) {
                this.addProblems(problemCollector, ValidateMessageItem.getAttributeTokenUseInAMWithNoWildcardsMessageItem(action, attributeName, value));
            } else if (this.wildCardValidatorUtil.actionHasWildcards() && !this.wildCardValidatorUtil.isAttributeTokenUseValid(value)) {
                this.addProblems(problemCollector, ValidateMessageItem.getInvalidParameterTokenInAMAttributeMessageItem(action, attributeName, value, String.valueOf(this.wildCardValidatorUtil.getNumberWildcards())));
            }
        }
    }

    private void validateCatalog(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        this.validateAttributeTokens(CATALOG, action, attrMap, problemCollector);
    }

    private void validateClassName(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        if (action.isSetClassName()) {
            String className = ActionMappingValidator.getRawData(attrMap, CLASS_NAME, action.getClassName());
            if (!ActionMappingValidator.isValidSubclass(this.getCache(), className, DFT_AM_CLSNAME)) {
                this.addProblems(problemCollector, ValidateMessageItem.getInvalidSubClassTypeMessageItem(action, CLASS_NAME, className, DFT_AM_CLSNAME));
            }
        }
    }

    private void validateCommand(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        this.validateAttributeTokens(COMMAND, action, attrMap, problemCollector);
    }

    @Override
    public void validateDuplicate(EList actionMappings, ValidateMessageCollector problemCollector) {
        ArrayList<ActionMapping> defaultActionMappingList;
        super.validateDuplicate(actionMappings, problemCollector);
        if (this.getReader().hasDuplicateDefaultActionMapping() && (defaultActionMappingList = this.getReader().getDefaultActionMappingsForFile(this.getFile())) != null) {
            problemCollector.addItems(this.buildDuplicateProblemListForParts(defaultActionMappingList, ValidateMessage.INVALID_AM_UNKNOWN));
        }
        Iterator iter = actionMappings.iterator();
        boolean is1_1OrHigher = StrutsProjectCoreUtil.isStruts1_1OrHigher((IProject)this.project);
        while (iter.hasNext()) {
            ActionMapping current = (ActionMapping)iter.next();
            this.localForwardValidator.validateDuplicateForLocalForwards(current.getForwards(), problemCollector);
            if (!is1_1OrHigher) continue;
            this.localExceptionValidator.validateDuplicateForLocalExceptionList(current.getExceptions(), problemCollector);
        }
    }

    @Override
    public void validateDuplicate(EObject strutsMofPart, ValidateMessageCollector problemCollector) {
        ArrayList<ActionMapping> defaultActionMappingList;
        super.validateDuplicate(strutsMofPart, problemCollector);
        if (this.getReader().hasDuplicateDefaultActionMapping() && (defaultActionMappingList = this.getReader().getDefaultActionMappingsForFile(this.getFile())) != null) {
            problemCollector.addItems(this.buildDuplicateProblemListForParts(defaultActionMappingList, ValidateMessage.INVALID_AM_UNKNOWN));
        }
        this.localForwardValidator.validateDuplicateForLocalForwards(((ActionMapping)strutsMofPart).getForwards(), problemCollector);
        if (StrutsProjectCoreUtil.isStruts1_1OrHigher((IProject)this.project)) {
            this.localExceptionValidator.validateDuplicateForLocalExceptionList(((ActionMapping)strutsMofPart).getExceptions(), problemCollector);
        }
    }

    @Override
    public void validateField(EObject strutsMofPart, ValidateMessageCollector problemCollector) {
        this.wildCardValidatorUtil = new ActionMappingWildcardUtil(this.project, ((ActionMapping)strutsMofPart).getPath());
        this.wcSetPropertyValidator.setAction((ActionMapping)strutsMofPart);
        this.wcSetPropertyValidator.setWildcardUtil(this.wildCardValidatorUtil);
        super.validateField(strutsMofPart, problemCollector);
        ActionMapping action = (ActionMapping)strutsMofPart;
        Node actionNode = ActionMappingValidator.getNode((Notifier)action);
        NamedNodeMap map = actionNode == null ? null : actionNode.getAttributes();
        this.validateActionMappingField(action, map, problemCollector);
        this.validateLocalForwards(action, problemCollector);
        if (StrutsProjectCoreUtil.isStruts1_1OrHigher((IProject)this.project)) {
            this.validateLocalExceptions(action, problemCollector);
        }
    }

    private void validateForward(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        this.validateAttributeTokens(FORWARD, action, attrMap, problemCollector);
    }

    private void validateInclude(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        this.validateAttributeTokens(INCLUDE, action, attrMap, problemCollector);
    }

    private void validateInput(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        this.validateAttributeTokens(INPUT, action, attrMap, problemCollector);
    }

    private void validateLocalExceptions(ActionMapping action, ValidateMessageCollector problemCollector) {
        EList<Exception0> list = action.getExceptions();
        if (list != null && !list.isEmpty()) {
            this.localExceptionValidator.validateField(list, problemCollector);
        }
    }

    private void validateLocalForwards(ActionMapping action, ValidateMessageCollector problemCollector) {
        EList<Forward> list = action.getForwards();
        boolean struts1_2OrHigher = StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)this.project);
        if (list != null && !list.isEmpty()) {
            if (struts1_2OrHigher) {
                this.localForwardValidator.validateField(list, problemCollector, this.wildCardValidatorUtil);
            } else {
                this.localForwardValidator.validateField(list, problemCollector);
            }
        }
    }

    private void validateName(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        Node attribute = attrMap.getNamedItem(NAME);
        if (attribute != null) {
            String value = attribute.getNodeValue();
            if (!StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)this.project) || !this.wildCardValidatorUtil.attributeHasTokens(value)) {
                if (!ValidateUtil.isValidBeanName(value)) {
                    this.addProblems(problemCollector, ValidateMessageItem.getInvalidBeanNameMessageItem(action, NAME, value));
                }
            } else {
                Set<String> referencesToAction = StrutsLinksSearchUtil.getActionMappingRuntimePaths(this.project, action);
                String name = action.getName();
                for (String refToAction : referencesToAction) {
                    String concreteAttributeValue = this.wildCardValidatorUtil.getConcreteAttributeValue(name, refToAction);
                    if (concreteAttributeValue == null || ValidateUtil.isValidBeanName(concreteAttributeValue)) continue;
                    this.addProblems(problemCollector, ValidateMessageItem.getInvalidTokenizedBeanNameMessageItem(action, NAME, concreteAttributeValue));
                }
                this.validateAttributeTokens(NAME, action, attrMap, problemCollector);
            }
        }
    }

    private void validateParameter(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        this.validateAttributeTokens(PARAMETER, action, attrMap, problemCollector);
    }

    private void validatePath(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        Node attribute = attrMap.getNamedItem(PATH);
        if (attribute != null) {
            String value = attribute.getNodeValue();
            if (!StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)this.project)) {
                if (ValidateUtil.isBeginsWithSlash(value)) {
                    if (!ValidateUtil.isValidMappingPath(value)) {
                        this.addProblems(problemCollector, ValidateMessageItem.getInvalidActionPathMessageItem(action, PATH, value));
                    }
                } else {
                    this.addProblems(problemCollector, ValidateMessageItem.getAMPathDoesNotBeginWithSlashMessageItem(action, PATH, value));
                }
            } else {
                if (!ValidateUtil.isBeginsWithSlash(value)) {
                    this.addProblems(problemCollector, ValidateMessageItem.getAMPathDoesNotBeginWithSlashMessageItem(action, PATH, value));
                }
                if (!ValidateUtil.isValidMappingPath(value)) {
                    this.addProblems(problemCollector, ValidateMessageItem.getInvalidActionPathMessageItem(action, PATH, value));
                }
                if (!this.wildCardValidatorUtil.isNumberOfWildcardsValid()) {
                    this.addProblems(problemCollector, ValidateMessageItem.getInvalidActionPathWildcardMessageItem(action, PATH, value));
                }
            }
        }
    }

    private void validatePrefix(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        if (action.isSetSuffix() && StrutsProjectCoreUtil.isStruts1_3((IProject)this.project)) {
            this.validateAttributeTokens(PREFIX, action, attrMap, problemCollector);
        }
    }

    @Override
    protected void validateProperties(EList<SetProperty> properties, ValidateMessageCollector problemCollector) {
        if (properties != null && !properties.isEmpty()) {
            if (StrutsProjectCoreUtil.isStruts1_3((IProject)this.project) && this.wcSetPropertyValidator != null && this.wildCardValidatorUtil != null) {
                for (SetProperty p : properties) {
                    this.wcSetPropertyValidator.validateField(p, problemCollector);
                }
            } else {
                super.validateProperties(properties, problemCollector);
            }
        }
    }

    @Override
    public void validateReferences(EObject strutsMofPart, ValidateMessageCollector problemCollector) {
        super.validateReferences(strutsMofPart, problemCollector);
        ActionMapping action = (ActionMapping)strutsMofPart;
        this.localForwardValidator.validateReferences(action.getForwards(), problemCollector);
    }

    @Override
    public void validateRequirement(EObject strutsMofPart, ValidateMessageCollector problemCollector) {
        super.validateRequirement(strutsMofPart, problemCollector);
        ActionMapping action = (ActionMapping)strutsMofPart;
        this.crossFieldNameChecking(action, problemCollector);
        if (StrutsProjectCoreUtil.isStruts1_3((IProject)this.project)) {
            this.crossCheckCancelAndValidate(action, problemCollector);
        }
        int numSet = 0;
        if (action.isSetForward()) {
            ++numSet;
        }
        if (action.isSetInclude()) {
            ++numSet;
        }
        if (action.isSetType()) {
            ++numSet;
        }
        if (!(numSet == 1 || StrutsProjectCoreUtil.isStruts1_3((IProject)this.project) && action.isSetExtends0())) {
            ValidateMessageItem msg = new ValidateMessageItem(ValidateMessage.INVALID_AM_ONE_OF_INC, action);
            this.addProblems(problemCollector, msg);
        }
        this.localForwardValidator.validateRequirement(action.getForwards(), problemCollector);
    }

    private void validateRoles(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        this.validateAttributeTokens(ROLES, action, attrMap, problemCollector);
    }

    private void validateSuffix(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        if (action.isSetSuffix() && StrutsProjectCoreUtil.isStruts1_3((IProject)this.project)) {
            this.validateAttributeTokens(SUFFIX, action, attrMap, problemCollector);
        }
    }

    private void validateType(ActionMapping action, NamedNodeMap attrMap, ValidateMessageCollector problemCollector) {
        if (action.isSetType()) {
            String typeValue = ActionMappingValidator.getRawData(attrMap, TYPE, action.getClassName());
            if (!StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)this.project) || !this.wildCardValidatorUtil.attributeHasTokens(typeValue)) {
                if (!ValidateUtil.isValidClassNameString(typeValue)) {
                    if (typeValue != null || !action.isSetExtends0()) {
                        this.addProblems(problemCollector, ValidateMessageItem.getInvalidClassNameMessageItem(action, TYPE, typeValue));
                    }
                } else if (!ActionMappingValidator.isValidSubclass(this.getCache(), typeValue, DFT_AM_TYPE)) {
                    this.addProblems(problemCollector, ValidateMessageItem.getInvalidSubClassTypeMessageItem(action, TYPE, typeValue, DFT_AM_TYPE));
                }
            } else {
                Set<String> referencesToAction = StrutsLinksSearchUtil.getActionMappingRuntimePaths(this.project, action);
                String type = action.getType();
                for (String refToAction : referencesToAction) {
                    String concreteAttributeValue = this.wildCardValidatorUtil.getConcreteAttributeValue(type, refToAction);
                    if (concreteAttributeValue != null && !ValidateUtil.isValidClassNameString(concreteAttributeValue)) {
                        problemCollector.addItem(ValidateMessageItem.getInvalidClassNameMessageItem(action, TYPE, concreteAttributeValue));
                        continue;
                    }
                    if (concreteAttributeValue == null || ActionMappingValidator.isValidSubclass(this.getCache(), concreteAttributeValue, DFT_AM_TYPE)) continue;
                    this.addProblems(problemCollector, ValidateMessageItem.getInvalidTokenizedSubClassTypeMessageItem(action, TYPE, concreteAttributeValue, DFT_AM_TYPE));
                }
                this.validateAttributeTokens(TYPE, action, attrMap, problemCollector);
            }
        }
    }
}

