/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.presentation.sections;

import com.ibm.etools.struts.emf.strutsconfig.StrutsconfigFactory;
import com.ibm.etools.struts.strutsconfig.edit.StrutsConfigFilter;
import com.ibm.etools.struts.strutsconfig.presentation.IStrutsconfigEditorData;
import com.ibm.etools.struts.strutsconfig.presentation.StrutsconfigTableWithButtonsSection;
import com.ibm.etools.struts.strutsconfig.presentation.sections.CommonTableLabelProvider;
import com.ibm.etools.struts.strutsconfig.presentation.sections.IconAdapterFactoryLabelProvider;
import com.ibm.etools.struts.strutsconfig.presentation.sections.MOFAdapterFactoryContentProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public abstract class StrutsconfigEntryTableSection
extends StrutsconfigTableWithButtonsSection {
    protected static final int NUMBER_TABLE_COLUMNS = 1;
    protected HashMap<Integer, String> fButtonMap;
    protected HashMap<String, String> fElementTableDisplayValueMap;

    public StrutsconfigEntryTableSection(IStrutsconfigEditorData data) {
        super(data);
        this.setHeaderText(this.getSectionHeaderTitle());
        this.setDescription(this.getSectionHeaderDescription());
        this.setCollapsable(false);
    }

    protected Composite createClient(Composite c) {
        Composite comp = this.createClient(c, this.getTableButtonsText(), 2, false, new String[]{""});
        ILabelProvider[] labelProviders = new ILabelProvider[]{new IconAdapterFactoryLabelProvider(this.getAdapterFactory())};
        String[] columnProperties = new String[]{this.getTableDisplayAttribute().getName()};
        this.fTableViewer.setColumnProperties(columnProperties);
        this.fTableViewer.setContentProvider((IContentProvider)this.fMOFAFContentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new CommonTableLabelProvider(labelProviders));
        this.setCellEditors(new boolean[]{true});
        this.fTableViewer.addFilter((ViewerFilter)new StrutsConfigFilter(this.getStrutsConfigFilterType()));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, this.getContextHelp());
        this.refresh();
        return comp;
    }

    public EObject externalTriggerOfNewElementCreation() {
        EObject result = null;
        IStatus status = this.fData.getEditValidator().validateState();
        if (status == null || status.getSeverity() == 0) {
            result = StrutsconfigFactory.eINSTANCE.create(this.getTableElementType().getEReferenceType());
            String newDisplayValue = this.getNewElementDisplayValue();
            if (newDisplayValue != null) {
                result.eSet((EStructuralFeature)this.getTableDisplayAttribute(), (Object)newDisplayValue);
            }
            AddCommand cmd = (AddCommand)AddCommand.create((EditingDomain)this.fEditingDomain, (Object)this.getTableParentElement(), (Object)this.getTableElementType(), (Object)result);
            cmd.setLabel(this.getAddCommandText());
            this.fEditingDomain.getCommandStack().execute((Command)cmd);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)result), true);
            this.fTableViewer.editElement((Object)result, 0);
        }
        return result;
    }

    protected abstract String getAddCommandText();

    protected abstract String getContextHelp();

    protected String getNewElementDisplayValue() {
        String displayValue = this.getTableElementAttributeBaseValue();
        if (displayValue != null) {
            this.fElementTableDisplayValueMap = new HashMap();
            Object olist = this.getTableParentElement().eGet((EStructuralFeature)this.getTableElementType());
            if (olist instanceof EList) {
                EList eObjectList = (EList)olist;
                EAttribute attribute = this.getTableDisplayAttribute();
                for (Object o : eObjectList) {
                    EObject eo;
                    if (!(o instanceof EObject) || !(eo = (EObject)o).eIsSet((EStructuralFeature)attribute)) continue;
                    this.fElementTableDisplayValueMap.put(eo.eGet((EStructuralFeature)attribute).toString(), eo.eGet((EStructuralFeature)attribute).toString());
                }
                int numMappings = this.fElementTableDisplayValueMap.size();
                int i = 0;
                i = 0;
                while (i < numMappings) {
                    if (this.fElementTableDisplayValueMap.get(String.valueOf(displayValue) + (i + 1)) == null) break;
                    ++i;
                }
                displayValue = String.valueOf(displayValue) + (i + 1);
            }
        }
        return displayValue;
    }

    protected EObject getNewPostRemovalSelection(IStructuredSelection currentSelection) {
        Object olist = this.getTableParentElement().eGet((EStructuralFeature)this.getTableElementType());
        if (olist instanceof EList) {
            EList elements = (EList)olist;
            List selections = currentSelection.toList();
            if (selections.size() < elements.size()) {
                Object lastSelectedObject = selections.get(currentSelection.size() - 1);
                int indexOfLastSelectedObject = 0;
                int indexOfNextSelectedObject = -1;
                for (Object am : elements) {
                    if (am == lastSelectedObject) break;
                    ++indexOfLastSelectedObject;
                }
                indexOfNextSelectedObject = indexOfLastSelectedObject + 1;
                if (indexOfNextSelectedObject >= elements.size()) {
                    indexOfNextSelectedObject -= 2;
                    int numSelections = selections.size();
                    int i = 0;
                    while (i < numSelections) {
                        if (!selections.contains(elements.get(indexOfNextSelectedObject))) break;
                        --indexOfNextSelectedObject;
                        ++i;
                    }
                }
                return (EObject)elements.get(indexOfNextSelectedObject);
            }
        }
        return null;
    }

    protected abstract String getRemoveCommandText();

    protected abstract String getSectionHeaderDescription();

    protected abstract String getSectionHeaderTitle();

    protected abstract int getStrutsConfigFilterType();

    protected String[] getTableButtonsText() {
        return new String[]{ADD, REMOVE};
    }

    protected abstract EAttribute getTableDisplayAttribute();

    protected abstract String getTableElementAttributeBaseValue();

    protected abstract EReference getTableElementType();

    protected abstract EObject getTableParentElement();

    protected void handleAddButtonSelected() {
        this.externalTriggerOfNewElementCreation();
    }

    protected void handleAddMoreButtonSelected() {
    }

    @Override
    protected final void handleButtonSelected(int index) {
        if (this.fButtonMap == null) {
            this.fButtonMap = new HashMap();
            String[] buttons = this.getTableButtonsText();
            int i = 0;
            while (i < buttons.length) {
                this.fButtonMap.put(i, buttons[i]);
                ++i;
            }
        }
        String buttonType = this.fButtonMap.get(index);
        if (this.validateState().isOK() && buttonType != null) {
            if (buttonType.equals(ADD)) {
                this.handleAddButtonSelected();
            } else if (buttonType.equals(ADDMORE)) {
                this.handleAddMoreButtonSelected();
            } else if (buttonType.equals(REMOVE)) {
                this.handleRemoveButtonSelected();
            } else if (buttonType.equals(NEW)) {
                this.handleNewButtonSelected();
            } else if (buttonType.equals(EDIT)) {
                this.handleEditButtonSelected();
            } else if (buttonType.equals(UP)) {
                this.handleUpButtonSelected();
            } else if (buttonType.equals(DOWN)) {
                this.handleDownButtonSelected();
            }
        }
    }

    protected void handleDownButtonSelected() {
    }

    protected void handleEditButtonSelected() {
    }

    protected void handleNewButtonSelected() {
    }

    @Override
    protected void handleRemoveButtonSelected() {
        ISelection s = this.fTableViewer.getSelection();
        EObject postRemoveSelection = null;
        if (s instanceof StructuredSelection) {
            postRemoveSelection = this.getNewPostRemovalSelection((IStructuredSelection)((StructuredSelection)s));
        }
        if (!s.isEmpty() && s instanceof IStructuredSelection) {
            Iterator selObjects = ((IStructuredSelection)s).iterator();
            ArrayList elements = new ArrayList();
            while (selObjects.hasNext()) {
                elements.add(selObjects.next());
            }
            RemoveCommand cmd = new RemoveCommand((EditingDomain)this.fEditingDomain, this.getTableParentElement(), (EStructuralFeature)this.getTableElementType(), elements);
            cmd.setLabel(this.getRemoveCommandText());
            if (postRemoveSelection == null) {
                this.fTableViewer.setSelection(null);
            } else {
                this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)postRemoveSelection));
            }
            this.fEditingDomain.getCommandStack().execute((Command)cmd);
            this.fTableViewer.refresh();
        }
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent e) {
        if (this.fTableViewer.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement() != this.getSelectedObject(e)) {
            this.setSelection((ISelection)new StructuredSelection(new Object[]{this.getSelectedObject(e)}), true);
        }
    }

    protected void handleUpButtonSelected() {
    }

    @Override
    public void initialize(IStrutsconfigEditorData data) {
        super.initialize(data);
        this.fMOFAFContentProvider = new MOFAdapterFactoryContentProvider(this.getAdapterFactory(), (EObject)this.getTableElementType().getEReferenceType());
        this.setContentProvider((IContentProvider)this.fMOFAFContentProvider);
        this.refresh();
    }

    public void initializeSelection() {
        if (this.fTable != null && this.fTableViewer != null && this.fTable.getItemCount() > 0 && this.fTable.getSelectionCount() == 0) {
            this.fTableViewer.setSelection((ISelection)new StructuredSelection(this.fTable.getItem(0).getData()), true);
        }
    }

    @Override
    public void refresh() {
        if (this.fTableViewer != null && !this.fTableViewer.getTable().isDisposed()) {
            Object srInput;
            Object input = this.getInput();
            if (input != (srInput = this.fTableViewer.getInput())) {
                this.fTableViewer.setInput(this.getInput());
            }
            this.refreshButtons();
        }
    }

    public void setGridData(Control control) {
        GridData gd = new GridData(1808);
        gd.widthHint = 0;
        gd.verticalSpan = 1;
        gd.horizontalIndent = 10;
        control.setLayoutData((Object)gd);
    }
}

