/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.presentation.sections;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jst.j2ee.webapplication.Filter;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class IconAdapterFactoryLabelProvider
extends AdapterFactoryLabelProvider {
    protected IContainer root = null;
    protected ImageRegistry imageReg = null;

    public IconAdapterFactoryLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Image getColumnImage(Object object, int columnIndex) {
        if (columnIndex >= 1) {
            return null;
        }
        Image result = this.getSpecialImage(object);
        if (result == null) {
            result = super.getColumnImage(object, columnIndex);
        }
        return result;
    }

    public Image getImage(Object object) {
        Image result = this.getSpecialImage(object);
        if (result == null) {
            result = super.getImage(object);
        }
        return result;
    }

    protected Image getImageFromFileName(String fileName) {
        Image image = null;
        boolean valid = true;
        IFile current = null;
        File file = null;
        try {
            Path currentPath = new Path(fileName);
            current = this.root.getFile((IPath)currentPath);
            file = current.getLocation().toFile();
        }
        catch (NullPointerException nullPointerException) {
            valid = false;
        }
        if (valid && current != null && file != null && current.exists() && (image = this.imageReg.get(file.getPath())) == null) {
            try {
                image = ImageDescriptor.createFromURL((URL)file.toURL()).createImage();
                Image resizedImage = new Image(null, 16, 16);
                GC gc = new GC((Drawable)resizedImage);
                Rectangle bounds = image.getBounds();
                gc.drawImage(image, bounds.x, bounds.y, bounds.width, bounds.height, 0, 0, 16, 16);
                gc.dispose();
                image = resizedImage;
                this.imageReg.put(file.getPath(), image);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SWTException sWTException) {}
        }
        return image;
    }

    protected Image getSpecialImage(Object object) {
        String iconName;
        Image result = null;
        Servlet servlet = null;
        WebApp webApp = null;
        Filter filter = null;
        if (object instanceof Servlet) {
            servlet = (Servlet)object;
            iconName = servlet.getSmallIcon();
            if (iconName != null) {
                result = this.getImageFromFileName(iconName);
            }
            if (result == null && (iconName = servlet.getLargeIcon()) != null) {
                result = this.getImageFromFileName(iconName);
            }
        }
        if (object instanceof WebApp) {
            webApp = (WebApp)object;
            iconName = webApp.getSmallIcon();
            if (iconName != null) {
                result = this.getImageFromFileName(iconName);
            }
            if (result == null && (iconName = webApp.getLargeIcon()) != null) {
                result = this.getImageFromFileName(iconName);
            }
        }
        if (object instanceof Filter) {
            filter = (Filter)object;
            iconName = filter.getSmallIcon();
            if (iconName != null) {
                result = this.getImageFromFileName(iconName);
            }
            if (result == null && (iconName = filter.getLargeIcon()) != null) {
                result = this.getImageFromFileName(iconName);
            }
        }
        return result;
    }

    public void setContainer(IContainer rootContainer) {
        this.root = rootContainer;
    }
}

