/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.strutsconfig.presentation.pages;

import com.ibm.etools.struts.emf.strutsconfig.MessageResources;
import com.ibm.etools.struts.emf.strutsconfig.SetProperty;
import com.ibm.etools.struts.emf.strutsconfig.SetPropertyContainer;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.strutsconfig.presentation.IStrutsconfigEditorData;
import com.ibm.etools.struts.strutsconfig.presentation.sections.MessageResourceAttributeSection;
import com.ibm.etools.struts.strutsconfig.presentation.sections.MessageResourceEntrySection;
import com.ibm.etools.struts.strutsconfig.presentation.sections.MessageResourceKeyValueTableSection;
import com.ibm.etools.webtools.flatui.FlatEditor;
import com.ibm.etools.webtools.flatui.FlatPage;
import com.ibm.etools.webtools.flatui.FlatPageSection;
import com.ibm.etools.webtools.flatui.FlatPageWithRHSFixedAndLHSScrolled;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class MessageResourcePage
extends FlatPageWithRHSFixedAndLHSScrolled {
    private MessageResourceEntrySection fMessageResourceSection;
    private MessageResourceAttributeSection fMessageResourceAttributeSection;
    private MessageResourceKeyValueTableSection fMessageResourceKeyValueTableSection;
    private FlatEditor fParentEditor;
    private IStrutsconfigEditorData fData;

    public MessageResourcePage(IStrutsconfigEditorData data) {
        super(data.getWidgetFactory());
        this.setTabText(ResourceHandler.message_resource_title);
        this.setHeadingText(ResourceHandler.message_resource_title);
        this.setScrollable(false);
        this.fData = data;
        this.createSections(data);
    }

    protected void createSectionControls(Composite parent) {
        super.createSectionControls(parent);
        this.getSashForm().SASH_WIDTH = 7;
        Control secCon1 = this.fMessageResourceSection.createControl(this.getLHSListComposite());
        this.fMessageResourceSection.setGridData(secCon1);
        int i = 1;
        while (i < this.fSections.size()) {
            FlatPageSection fps = (FlatPageSection)this.fSections.elementAt(i);
            Control secCon = fps.createControl(this.getRHSScrollableDetailsComposite());
            fps.setGridData(secCon);
            ++i;
        }
        this.getFlatScrolledComposite().init(1);
        Point rootCompSize = this.getRHSScrollableDetailsComposite().computeSize(-1, -1);
        this.setFlatScrollableSectionDimensions(rootCompSize);
        this.fMessageResourceSection.setListeners((FlatPage)this);
        this.getSashForm().setWeights(new int[]{40, 60});
    }

    protected void createSections(IStrutsconfigEditorData data) {
        this.fMessageResourceSection = new MessageResourceEntrySection(data);
        this.registerSection(this.fMessageResourceSection);
        this.fMessageResourceAttributeSection = new MessageResourceAttributeSection(data);
        this.registerSection(this.fMessageResourceAttributeSection);
        this.fMessageResourceKeyValueTableSection = new MessageResourceKeyValueTableSection(data);
        this.registerSection(this.fMessageResourceKeyValueTableSection);
    }

    private MessageResources findMessageResources(MessageResources source) {
        MessageResources target = null;
        EList<MessageResources> elist = this.fData.getStrutsArtifactEdit().getStrutsConfig().getMessageResources();
        for (MessageResources element : elist) {
            if (element.getParameter() == null) {
                if (source.getParameter() != null) continue;
                target = element;
                continue;
            }
            if (!element.getParameter().equals(source.getParameter())) continue;
            target = element;
        }
        return target;
    }

    private SetProperty findSetProperty(SetPropertyContainer parent, SetProperty source) {
        SetProperty target = null;
        EList<SetProperty> elist = parent.getSetProperties();
        for (SetProperty element : elist) {
            if (element.getProperty() == null) {
                if (source.getProperty() != null) continue;
                target = element;
                continue;
            }
            if (!element.getProperty().equals(source.getProperty())) continue;
            target = element;
        }
        return target;
    }

    private Object focusOn(Object target) {
        Object result = null;
        if (target instanceof MessageResources) {
            MessageResources trueTarget = this.findMessageResources((MessageResources)target);
            this.fMessageResourceSection.setSelection((ISelection)new StructuredSelection(new Object[]{trueTarget}), true);
            result = trueTarget;
        } else {
            EObject parent = ((EObject)target).eContainer();
            Object trueParent = this.focusOn(parent);
            if (target instanceof SetProperty) {
                SetProperty trueTarget = this.findSetProperty((SetPropertyContainer)trueParent, (SetProperty)target);
                this.fMessageResourceKeyValueTableSection.setSelection((ISelection)new StructuredSelection(new Object[]{trueTarget}), true);
                result = trueTarget;
            }
        }
        return result;
    }

    public final FlatEditor getEditor() {
        return this.fParentEditor;
    }

    public void refreshEditModel(IStrutsconfigEditorData data) {
        this.fMessageResourceSection.refreshEditModel(data);
        this.fMessageResourceAttributeSection.refreshEditModel(data);
        this.fMessageResourceKeyValueTableSection.refreshEditModel(data);
    }

    public void setActivated(boolean isActivated) {
        super.setActivated(isActivated);
        this.fMessageResourceSection.initializeSelection();
    }

    public final void setEditor(FlatEditor fe) {
        this.fParentEditor = fe;
    }

    public void setOutlineSelection(IStructuredSelection sel) {
        if (sel == null || sel.isEmpty()) {
            this.fMessageResourceSection.setSelection(null, false);
        } else {
            Object selectedObject = sel.getFirstElement();
            this.focusOn(selectedObject);
        }
    }
}

