/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.refactoring.processors;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.refactoring.processors.AbstractStrutsRenameProcessor;
import com.ibm.etools.struts.strutsconfig.validator.ExceptionValidator;
import com.ibm.etools.struts.strutsconfig.validator.ValidateUtil;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class RenameLocalExceptionProcessor
extends AbstractStrutsRenameProcessor {
    private static final String EXCEPTION = "exception";
    private static final String TYPE = "type";

    public String getIdentifier() {
        return "com.ibm.etools.struts.renameLocalException";
    }

    public String getProcessorName() {
        return ResourceHandler.refactoring_rename_local_exception;
    }

    public RefactoringStatus validateNewElementName(String text) {
        IProject project = this.getFile().getProject();
        if (text == null || "".equals(text)) {
            return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_empty_value_error, (Object[])new String[]{EXCEPTION, TYPE})));
        }
        if (!ValidateUtil.isValidClassNameString(text)) {
            return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_invalid_java_identifier_in_value_error, (Object[])new String[]{EXCEPTION, TYPE})));
        }
        if (!ValidateUtil.isValidTypeReference(this.getFile(), text)) {
            return RefactoringStatus.create((IStatus)new Status(2, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_type_does_not_exist_error, (Object[])new String[]{EXCEPTION, TYPE, text})));
        }
        if (!ValidateUtil.isValidSubClass(project, text, ExceptionValidator.DFT_EXCEPT_TYPE)) {
            return RefactoringStatus.create((IStatus)new Status(2, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_invalid_super_class_in_value_error, (Object[])new String[]{EXCEPTION, TYPE, ExceptionValidator.DFT_EXCEPT_TYPE})));
        }
        ILink actionMappingHandle = this.getEnclosingActionMapping(this.getRange());
        Set localExceptions = StrutsSearchUtil.getLocalExceptions((ILink)actionMappingHandle, null);
        if (localExceptions != null) {
            for (ILink e : localExceptions) {
                if (!text.equals(e.getName())) continue;
                return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_value_is_duplicate_error, (Object[])new String[]{EXCEPTION, TYPE, text})));
            }
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }
}

