/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.refactoring.processors;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.refactoring.processors.AbstractStrutsRenameProcessor;
import com.ibm.etools.struts.strutsconfig.validator.ExceptionValidator;
import com.ibm.etools.struts.strutsconfig.validator.ValidateUtil;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class RenameGlobalExceptionProcessor
extends AbstractStrutsRenameProcessor {
    private static final String EXCEPTION = "exception";
    private static final String TYPE = "type";

    public String getIdentifier() {
        return "com.ibm.etools.struts.renameGlobalException";
    }

    public String getProcessorName() {
        return ResourceHandler.refactoring_rename_global_exception;
    }

    public RefactoringStatus validateNewElementName(String text) {
        IProject project = this.getFile().getProject();
        if (text == null || "".equals(text)) {
            return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_empty_value_error, (Object[])new String[]{EXCEPTION, TYPE})));
        }
        if (!ValidateUtil.isValidClassNameString(text)) {
            return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_invalid_java_identifier_in_value_error, (Object[])new String[]{EXCEPTION, TYPE})));
        }
        if (!ValidateUtil.isValidTypeReference(this.getFile(), text)) {
            return RefactoringStatus.create((IStatus)new Status(2, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_type_does_not_exist_error, (Object[])new String[]{EXCEPTION, TYPE, text})));
        }
        if (!ValidateUtil.isValidSubClass(project, text, ExceptionValidator.DFT_EXCEPT_TYPE)) {
            return RefactoringStatus.create((IStatus)new Status(2, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_invalid_super_class_in_value_error, (Object[])new String[]{EXCEPTION, TYPE, ExceptionValidator.DFT_EXCEPT_TYPE})));
        }
        String module = StrutsSearchUtil.getModuleForIFile((IFile)this.getFile(), null);
        Set globalExceptions = StrutsSearchUtil.getGlobalExceptions((IProject)project, (String)module, null);
        if (globalExceptions != null) {
            for (ILink e : globalExceptions) {
                if (!text.equals(e.getName())) continue;
                return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_value_is_duplicate_error, (Object[])new String[]{EXCEPTION, TYPE, text})));
            }
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }
}

