/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.refactoring.processors;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.refactoring.processors.AbstractStrutsRenameProcessor;
import com.ibm.etools.struts.strutsconfig.validator.ValidateUtil;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.osgi.util.NLS;

public class RenameActionMappingProcessor
extends AbstractStrutsRenameProcessor {
    private static final String ACTION = "action";
    private static final String PATH = "path";

    public String getIdentifier() {
        return "com.ibm.etools.struts.renameActionMapping";
    }

    public String getProcessorName() {
        return ResourceHandler.refactoring_rename_action_mapping;
    }

    public RefactoringStatus validateNewElementName(String text) {
        IProject project = this.getFile().getProject();
        ActionMappingWildcardUtil wcu = new ActionMappingWildcardUtil(project, text);
        if (text == null || "".equals(text)) {
            return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_empty_value_error, (Object[])new String[]{ACTION, PATH})));
        }
        if (!text.startsWith("/")) {
            return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), ResourceHandler.refactoring_no_slash_path_error));
        }
        if (!ValidateUtil.isValidMappingPath(text)) {
            return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_invalid_characters_in_value_error, (Object[])new String[]{ACTION, PATH})));
        }
        if (wcu.actionHasWildcards()) {
            return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), ResourceHandler.refactoring_wildcards_in_path_error));
        }
        String module = StrutsSearchUtil.getModuleForIFile((IFile)this.getFile(), null);
        SearchScope scope = StrutsSearchUtil.getModuleScope((IProject)project, (String)module, null);
        Set actions = StrutsSearchUtil.getAllActionMappings((SearchScope)scope, null);
        if (actions != null) {
            for (ILink action : actions) {
                if (!text.equals(action.getName())) continue;
                return RefactoringStatus.create((IStatus)new Status(4, StrutsPlugin.getPluginId(), NLS.bind((String)ResourceHandler.refactoring_value_is_duplicate_error, (Object[])new String[]{ACTION, PATH, text})));
            }
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }
}

