/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.refactoring.participants;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.management.SpecializedType;
import com.ibm.etools.references.management.TextRange;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.struts.nls.ResourceHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.FileStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.osgi.util.NLS;

public class StrutsReferenceMoveRefactoringParticipant
extends MoveParticipant {
    private IFile fElement = null;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        if (!this.getArguments().getUpdateReferences()) {
            return RefactoringStatus.create((IStatus)Status.OK_STATUS);
        }
        LinkNode ln = ReferenceManager.getReferenceManager().getLinkNode(this.fElement);
        Collection links = ln.getLinks(ReferenceManager.getReferenceManager().getLinkType("struts.jsp.htmlink.link"), SpecializedType.Depth.ZERO, pm);
        RefactoringStatus status = new RefactoringStatus();
        ArrayList<MoveLink> affectedLinks = new ArrayList<MoveLink>();
        for (ILink link : links) {
            if (!link.getParameter("attributeParam").equals("action")) continue;
            affectedLinks.add(new MoveLink(link));
        }
        Collections.sort(affectedLinks);
        for (MoveLink ml : affectedLinks) {
            TextRange range = ml.link.getContextLocation();
            Region region = new Region(range.getOffset(), range.getLength());
            FileStatusContext fcontext = new FileStatusContext(this.fElement, (IRegion)region);
            String action = AbstractWebProvider.trimQuotes((String)ml.link.getLinkText());
            String page = this.fElement.getName();
            status.addWarning(NLS.bind((String)ResourceHandler.StrutsMoveModuleWarning, (Object[])new String[]{page, action}), (RefactoringStatusContext)fcontext);
        }
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public String getName() {
        return null;
    }

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            this.fElement = (IFile)element;
            return true;
        }
        return false;
    }

    private class MoveLink
    implements Comparable<MoveLink> {
        public ILink link;

        public MoveLink(ILink link) {
            this.link = link;
        }

        @Override
        public int compareTo(MoveLink o) {
            int olOffset;
            ILink ol = o.link;
            int linkOffset = this.link.getContextLocation().getOffset();
            if (linkOffset == (olOffset = ol.getContextLocation().getOffset())) {
                return 0;
            }
            if (linkOffset > olOffset) {
                return 1;
            }
            return -1;
        }
    }
}

