/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.projnavigator.providers;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.refactoring.RefactoringSupport;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.projnavigator.IStrutsProjNavNodeFactory;
import com.ibm.etools.struts.projnavigator.StrutsProjNavUtil;
import com.ibm.etools.struts.projnavigator.factories.AbstractStrutsProjNavNodeFactory;
import com.ibm.etools.struts.projnavigator.providers.IStrutsProjNavChildrenProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsResourcesProvider
implements IStrutsProjNavChildrenProvider {
    public static final int NONE = 0;
    public static final int STRUTS_CONFIG = 1;
    public static final int STRUTS_GPH = 2;
    private static Comparator strutsResourceProviderSorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            int fileNum2;
            ILink f1 = (ILink)o1;
            ILink f2 = (ILink)o2;
            int fileNum1 = this.fileNum(f1);
            if (fileNum1 != (fileNum2 = this.fileNum(f2))) {
                return fileNum1 - fileNum2;
            }
            String s1 = f1.getName();
            String s2 = f2.getName();
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareTo(s2);
        }

        public int fileNum(ILink f1) {
            return 1;
        }
    };
    private int type;

    public StrutsResourcesProvider() {
        this(0);
    }

    public StrutsResourcesProvider(int type) {
        this.type = this.getValidType(type);
    }

    @Override
    public Object[] getChildren(Object parentElement, String module, IStrutsProjNavNodeFactory factory, Class resultType) {
        if (!this.isValidParent(parentElement)) {
            return null;
        }
        Object[] childrenHandles = (ILink[])this.getPrimitiveChildren(parentElement, module);
        if (childrenHandles == null || childrenHandles.length == 0) {
            return null;
        }
        if (factory instanceof AbstractStrutsProjNavNodeFactory) {
            return ((AbstractStrutsProjNavNodeFactory)factory).createNodes(childrenHandles, parentElement, resultType, module);
        }
        if (factory != null) {
            return factory.createNodes(childrenHandles, parentElement, resultType);
        }
        return null;
    }

    private String getModuleForGraphicalFile(IFile gphFile) {
        return "";
    }

    @Override
    public Object[] getPrimitiveChildren(Object parentElement, String module) {
        IVirtualComponent component = StrutsProjNavUtil.getComponent(parentElement);
        if (component == null) {
            return null;
        }
        if (this.type == 0) {
            return null;
        }
        ArrayList list = new ArrayList();
        if ((this.type & 1) != 0) {
            this.getStrutsConfigFiles(component, module, list);
        }
        if ((this.type & 2) != 0) {
            this.getStrutsGraphicalFiles(component, module, list);
        }
        Object[] files = list.toArray(new ILink[list.size()]);
        Arrays.sort(files, strutsResourceProviderSorter);
        return files;
    }

    private void getStrutsConfigFiles(IVirtualComponent component, String module, ArrayList list) {
        Set fileList = null;
        try {
            fileList = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)component.getProject(), (String)module, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (ReferenceException e) {
            StrutsPlugin.getLogger().log((Throwable)e);
        }
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        list.addAll(fileList);
    }

    private void getStrutsGraphicalFiles(IVirtualComponent component, String module, ArrayList list) {
        if (component == null) {
            return;
        }
        final class FileVisitor
        implements IResourceVisitor {
            private final Collection<IFile> files = new ArrayList<IFile>();

            FileVisitor() {
            }

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 1) {
                    this.files.add((IFile)resource);
                }
                return true;
            }
        }
        FileVisitor fv = new FileVisitor();
        try {
            fv.visit((IResource)component.getProject());
        }
        catch (CoreException coreException) {
            return;
        }
        for (IFile file : fv.files) {
            String fileExtension = file.getFileExtension();
            if (!fileExtension.equalsIgnoreCase("gph") || !this.getModuleForGraphicalFile(file).equals(module)) continue;
            LinkNode linkNode = ReferenceManager.getReferenceManager().getLinkNode(file);
            RefactoringSupport rs = new RefactoringSupport();
            try {
                list.add(rs.getNodeIdLink(linkNode, null));
            }
            catch (ReferenceException referenceException) {}
        }
    }

    private int getValidType(int type) {
        return 3 & type;
    }

    @Override
    public boolean hasChildren(Object parentElement, String module) {
        return true;
    }

    @Override
    public boolean isValidParent(Object parentElement) {
        IVirtualComponent component = StrutsProjNavUtil.getComponent(parentElement);
        return component != null;
    }

    public void setType(int newType) {
        this.type = this.getValidType(newType);
    }
}

