/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.projnavigator.nodes;

import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.projnavigator.IStrutsProjNavNodeFactory;
import com.ibm.etools.struts.projnavigator.StrutsProjNavContentProvider;
import com.ibm.etools.struts.projnavigator.StrutsProjNavNode;
import com.ibm.etools.struts.projnavigator.factories.StrutsProjNavBasicNodeFactory;
import com.ibm.etools.struts.projnavigator.factories.StrutsProjNavHandleNodeFactory;
import com.ibm.etools.struts.projnavigator.nodes.StrutsProjNavCategoryNode;
import com.ibm.etools.struts.projnavigator.nodes.StrutsProjNavModuleNode;
import com.ibm.etools.struts.projnavigator.nodes.StrutsProjNavResourceNode;
import com.ibm.etools.struts.projnavigator.providers.CategoryProvider;
import com.ibm.etools.struts.projnavigator.providers.IStrutsProjNavChildrenProvider;
import com.ibm.etools.struts.projnavigator.providers.ModuleProvider;
import com.ibm.etools.struts.projnavigator.providers.StrutsResourcesProvider;
import com.ibm.etools.struts.strutsconfig.validator.StrutsMarkerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsRoot
extends StrutsProjNavNode
implements IReferenceListener {
    private static CategoryProvider categoryProvider = new CategoryProvider();
    private static ModuleProvider moduleProvider = new ModuleProvider();
    private static final int RES_PROVIDER_TYPE_1_0 = 1;
    private static final int RES_PROVIDER_TYPE_1_1 = 0;
    private static StrutsResourcesProvider resourcesProvider = new StrutsResourcesProvider(1);
    private StrutsProjNavContentProvider contentProvider = null;
    private final boolean isStruts10;
    private final boolean isStruts11OrHigher;
    private ArrayList resourceList;
    private int resourceProviderType = 0;

    public StrutsRoot(Object element, Object parent, StrutsProjNavContentProvider contentProvider) {
        super(element, parent);
        this.contentProvider = contentProvider;
        IVirtualComponent component = (IVirtualComponent)element;
        this.isStruts11OrHigher = StrutsProjectCoreUtil.getStrutsVersion((IProject)component.getProject()) >= 1;
        boolean bl = this.isStruts10 = StrutsProjectCoreUtil.getStrutsVersion((IProject)component.getProject()) == 0;
        if (this.isStruts11OrHigher) {
            this.resourceProviderType = 0;
        } else if (this.isStruts10) {
            this.resourceProviderType = 1;
        }
        ReferenceManager.getReferenceManager().addReferenceListener((IReferenceListener)this);
    }

    @Override
    protected Object[] buildChildren() {
        Object[] nonResourceChildren = super.buildChildren();
        Object[] resources = this.getResourceListAsArray();
        ArrayList<Object> allchildren = new ArrayList<Object>(nonResourceChildren.length + resources.length);
        allchildren.addAll(Arrays.asList(resources));
        allchildren.addAll(Arrays.asList(nonResourceChildren));
        this.children = allchildren.toArray(new Object[allchildren.size()]);
        if (allchildren.size() == 0) {
            this.children = ZERO_LENGTH_CHILD;
        }
        return this.children;
    }

    private ArrayList buildResourceList() {
        ArrayList<Object> list = new ArrayList<Object>();
        resourcesProvider.setType(this.resourceProviderType);
        Object[] children = resourcesProvider.getChildren(this, this.getModule(), StrutsProjNavHandleNodeFactory.getFactory(), StrutsProjNavResourceNode.class);
        if (children != null) {
            list.addAll(Arrays.asList(children));
        }
        return list;
    }

    @Override
    public void dispose() {
        this.disposeResourceList();
        ReferenceManager.getReferenceManager().removeReferenceListener((IReferenceListener)this);
        super.dispose();
    }

    @Override
    protected void disposeChildren() {
        super.disposeChildren();
        this.disposeResourceList();
    }

    private void disposeResourceList() {
        if (this.resourceList == null) {
            return;
        }
        for (StrutsProjNavResourceNode node : this.resourceList) {
            node.dispose();
        }
        this.resourceList = null;
    }

    @Override
    public Object getAdapter(Class adapterClass) {
        if (adapterClass == IResource.class) {
            if (this.getElement() instanceof IResource) {
                return this.getElement();
            }
            if (this.getElement() instanceof ILink) {
                return ((ILink)this.getElement()).getContainer().getResource();
            }
        }
        if (adapterClass == IVirtualComponent.class) {
            return this.getElement();
        }
        return null;
    }

    @Override
    protected Object[] getChildren(boolean create) {
        Object[] children = super.getChildren(create);
        if (children == null) {
            return null;
        }
        return children;
    }

    @Override
    public Class getChildrenType() {
        if (this.isStruts11OrHigher) {
            return StrutsProjNavModuleNode.class;
        }
        return StrutsProjNavCategoryNode.class;
    }

    public IVirtualComponent getComponent() {
        return (IVirtualComponent)this.getElement();
    }

    public StrutsProjNavContentProvider getContentProvider() {
        return this.contentProvider;
    }

    @Override
    public IStrutsProjNavNodeFactory getFactory() {
        return StrutsProjNavBasicNodeFactory.getFactory();
    }

    @Override
    public IStrutsProjNavChildrenProvider getProvider() {
        if (this.isStruts11OrHigher) {
            return moduleProvider;
        }
        return categoryProvider;
    }

    protected Object[] getResourceListAsArray() {
        if (this.resourceList == null) {
            this.resourceList = this.buildResourceList();
        }
        return this.resourceList.toArray();
    }

    @Override
    public int getStatus() {
        if (this.children != null) {
            return this.getHighestSeverityFromAllChildren(this.children);
        }
        Collection files = StrutsSearchUtil.getStrutsConfigIFiles((IProject)this.getComponent().getProject());
        int markerServ = 0;
        for (IFile file : files) {
            int sev = StrutsMarkerUtil.getHighestSeverityForFile(file);
            markerServ = Math.max(markerServ, sev);
        }
        return StrutsRoot.getStatusForIMarkerStatus(markerServ);
    }

    @Override
    public String getText() {
        return ResourceHandler.WebStructure_root;
    }

    public void handleReferenceEvents(List<ReferenceEvent> events) {
        for (ReferenceEvent referenceEvent : events) {
            ILink link;
            if (referenceEvent.getReferenceElement().getElementType() != IReferenceElement.ElementType.LINK || !(link = (ILink)referenceEvent.getReferenceElement()).getSpecializedType().getId().equals("struts.config.nodeid") || referenceEvent.getKind().equals((Object)ReferenceEvent.Kind.CHANGE)) continue;
            this.disposeChildren();
            this.notifyStructuralChanged();
            this.notifyVisualChangedForParent();
            break;
        }
    }

    public boolean isValidElement(Object element) {
        return element instanceof IProject;
    }
}

