/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.projnavigator;

import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.projnavigator.StrutsProjNavNode;
import com.ibm.etools.struts.projnavigator.nodes.StrutsRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class StrutsProjNavUtil {
    private static final String PROJECT_NAV_VIEW_ID = "org.eclipse.ui.navigator.ProjectExplorer";

    public static void forceProjectNavigatorRefresh() {
        RefreshViewerCacheJob job = new RefreshViewerCacheJob();
        job.schedule();
    }

    public static IVirtualComponent getComponent(Object element) {
        if (element instanceof IAdaptable) {
            return StrutsProjNavUtil.getComponentFromAdaptable((IAdaptable)element);
        }
        return null;
    }

    public static IVirtualComponent getComponentFromAdaptable(IAdaptable adapter) {
        return (IVirtualComponent)adapter.getAdapter(IVirtualComponent.class);
    }

    public static IVirtualComponent getContainerComponent(StrutsProjNavNode node) {
        StrutsRoot root = StrutsProjNavUtil.getStrutsRootFromNode(node);
        if (root != null) {
            return root.getComponent();
        }
        return null;
    }

    private static INavigatorContentService getNavigatorContentService() {
        IViewPart viewPart;
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (viewPart = page.findView(PROJECT_NAV_VIEW_ID)) instanceof CommonNavigator) {
            CommonNavigator viewer = (CommonNavigator)viewPart;
            CommonViewer commV = viewer.getCommonViewer();
            if (commV == null || commV.getTree() == null || commV.getTree().isDisposed()) {
                return null;
            }
            return viewer.getNavigatorContentService();
        }
        return null;
    }

    public static int getStatusForIMarkerStatus(int iMarkerSeverity) {
        switch (iMarkerSeverity) {
            case 2: {
                return 4;
            }
            case 1: {
                return 2;
            }
            case 0: {
                return 1;
            }
        }
        return 0;
    }

    public static StrutsRoot getStrutsRootFromNode(StrutsProjNavNode node) {
        if (node == null) {
            return null;
        }
        StrutsProjNavNode parent = node.getParent();
        while (parent != null && parent instanceof StrutsProjNavNode) {
            node = parent;
            parent = node.getParent();
        }
        if (node instanceof StrutsRoot) {
            return (StrutsRoot)node;
        }
        return null;
    }

    private static final class RefreshViewerCacheJob
    extends UIJob {
        private RefreshViewerCacheJob() {
            super(ResourceHandler.ProjNavExtension_RefreshCache);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            INavigatorContentService navigatorContentService = StrutsProjNavUtil.getNavigatorContentService();
            if (navigatorContentService != null) {
                navigatorContentService.getActivationService().activateExtensions(new String[0], false);
            }
            return Status.OK_STATUS;
        }
    }
}

