/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.projnavigator;

import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.services.IServiceLocator;

public class CommandAction
extends Action {
    private IHandlerService handlerService = null;
    private ParameterizedCommand parameterizedCommand = null;
    private ICommandListener commandListener;

    protected CommandAction() {
    }

    public CommandAction(IServiceLocator serviceLocator, String commandIdIn) {
        this(serviceLocator, commandIdIn, null);
    }

    public CommandAction(IServiceLocator serviceLocator, String commandIdIn, Map parameterMap) {
        if (commandIdIn == null) {
            throw new NullPointerException("commandIdIn must not be null");
        }
        this.init(serviceLocator, commandIdIn, parameterMap);
    }

    private void createCommand(ICommandService commandService, String commandId, Map parameterMap) {
        Command cmd = commandService.getCommand(commandId);
        if (!cmd.isDefined()) {
            WorkbenchPlugin.log((String)("Command " + commandId + " is undefined"));
            return;
        }
        if (parameterMap == null) {
            this.parameterizedCommand = new ParameterizedCommand(cmd, null);
            return;
        }
        this.parameterizedCommand = ParameterizedCommand.generateCommand((Command)cmd, (Map)parameterMap);
    }

    public void dispose() {
        this.handlerService = null;
        if (this.commandListener != null) {
            this.parameterizedCommand.getCommand().removeCommandListener(this.commandListener);
            this.commandListener = null;
        }
        this.parameterizedCommand = null;
    }

    public String getActionDefinitionId() {
        if (this.parameterizedCommand != null) {
            return this.parameterizedCommand.getId();
        }
        return null;
    }

    protected ICommandListener getCommandListener() {
        if (this.commandListener == null) {
            this.commandListener = new ICommandListener(){

                public void commandChanged(CommandEvent commandEvent) {
                    if ((commandEvent.isHandledChanged() || commandEvent.isEnabledChanged()) && commandEvent.getCommand().isDefined()) {
                        CommandAction.this.setEnabled(commandEvent.getCommand().isEnabled());
                    }
                }
            };
        }
        return this.commandListener;
    }

    protected ParameterizedCommand getParameterizedCommand() {
        return this.parameterizedCommand;
    }

    protected void init(IServiceLocator serviceLocator, String commandIdIn, Map parameterMap) {
        if (this.handlerService != null) {
            return;
        }
        this.handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)serviceLocator.getService(ICommandService.class);
        ICommandImageService commandImageService = (ICommandImageService)serviceLocator.getService(ICommandImageService.class);
        this.createCommand(commandService, commandIdIn, parameterMap);
        if (this.parameterizedCommand != null) {
            this.setId(this.parameterizedCommand.getId());
            try {
                this.setText(this.parameterizedCommand.getName());
            }
            catch (NotDefinedException notDefinedException) {}
            this.parameterizedCommand.getCommand().addCommandListener(this.getCommandListener());
            this.setEnabled(this.parameterizedCommand.getCommand().isEnabled());
            this.setImageDescriptor(commandImageService.getImageDescriptor(commandIdIn, 0));
            this.setDisabledImageDescriptor(commandImageService.getImageDescriptor(commandIdIn, 1));
            this.setHoverImageDescriptor(commandImageService.getImageDescriptor(commandIdIn, 2));
        }
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        if (this.handlerService == null) {
            String commandId = this.parameterizedCommand == null ? "unknownCommand" : this.parameterizedCommand.getId();
            WorkbenchPlugin.log((String)("Cannot run " + commandId + " before command action has been initialized"));
            return;
        }
        try {
            if (this.parameterizedCommand != null) {
                this.handlerService.executeCommand(this.parameterizedCommand, event);
            }
        }
        catch (Exception e) {
            WorkbenchPlugin.log((Throwable)e);
        }
    }
}

