/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.pagedataview.formbean.ui.internal;

import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.WebUtil;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.Images;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.wizards.formbeans.FormBeanWizard;
import com.ibm.etools.struts.wizards.formbeans.IFormBeanRegionData;
import com.ibm.etools.struts.wizards.wrf.WizardUtils;
import com.ibm.etools.webedit.common.editdomain.HTMLEditDomain;
import com.ibm.etools.webedit.editor.actions.design.HTMLEditorAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;

public class NewFormBeanAction
extends HTMLEditorAction {
    public NewFormBeanAction() {
        this("FormBeanWizard", ResourceHandler.NewFormBeanAction_CreateFormBean);
    }

    public NewFormBeanAction(String id, String text) {
        super(id, text);
        this.setToolTipText(ResourceHandler.ui_pdv_formbean_addFormBean);
        this.setImageDescriptor(Images.getFormBeanWizardDescriptor());
    }

    private Command getCommand() {
        Command ret = new Command(){

            public void execute() {
                super.execute();
                IFile file = this.getIFile();
                if (file == null) {
                    return;
                }
                IProject project = file.getProject();
                IVirtualComponent component = ComponentUtilities.findComponent((IResource)project);
                String defaultNameStr = ResourceHandler.Provider_NoName_label;
                FormBeanWizard wizard = new FormBeanWizard(defaultNameStr, true);
                StructuredSelection ss = new StructuredSelection((Object)project);
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)ss);
                IFormBeanRegionData fbrd = (IFormBeanRegionData)wizard.getRegionData();
                fbrd.setGenerateBacking();
                if (StrutsProjectCoreUtil.getStrutsVersion((IProject)component.getProject()) >= 1) {
                    Set scLinks;
                    String moduleName = StrutsSearchUtil.getModuleForIFile((IFile)file, null);
                    try {
                        scLinks = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)component.getProject(), (String)moduleName, null);
                    }
                    catch (ReferenceException e) {
                        e.printStackTrace();
                        scLinks = Collections.emptySet();
                    }
                    Collection scfns = StrutsSearchUtil.convertPathsToStrings((Collection)StrutsSearchUtil.convertFilesToDocRootRelativePaths((Collection)StrutsSearchUtil.convertLinksToFiles(scLinks)));
                    if (scfns != null && scfns.size() > 0) {
                        WizardUtils.setStrutsConfigFileNames(fbrd, scfns);
                        IPath container = WebUtil.getDocumentRootContainer((IResource)file).getFullPath();
                        IPath scPath = file.getFullPath();
                        int matches = scPath.matchingFirstSegments(container);
                        scPath = scPath.removeFirstSegments(matches).makeAbsolute();
                        String scfn = scPath.toString();
                        if (scfn != null) {
                            WizardUtils.setStrutsConfigFileName(fbrd, scfn);
                        }
                    }
                }
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
                dialog.create();
                dialog.open();
            }

            private IFile getIFile() {
                HTMLEditDomain editDomain = NewFormBeanAction.this.getTarget();
                IDOMDocument doc = editDomain.getActiveModel().getDocument();
                if (doc == null) {
                    return null;
                }
                String jspFilename = doc.getModel().getBaseLocation();
                if (jspFilename == null) {
                    return null;
                }
                Path jspPath = new Path(jspFilename);
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)jspPath);
                return file;
            }
        };
        return ret;
    }

    protected Command getCommandForExec() {
        Command cmd = this.getCommand();
        if (cmd != null) {
            cmd.execute();
        }
        return null;
    }

    protected Command getCommandForUpdate() {
        return this.getCommand();
    }
}

