/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.pagedataview.formbean;

import com.ibm.etools.references.events.IReferenceListener;
import com.ibm.etools.references.events.ReferenceEvent;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IReferenceElement;
import com.ibm.etools.references.management.LinkNode;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.management.ReferenceManager;
import com.ibm.etools.references.search.SearchScope;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.pagedataview.formbean.util.FormBeanModelUtil;
import com.ibm.etools.struts.util.StrutsLinksSearchUtil;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModel;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataModelLifeCycleListener;
import com.ibm.etools.webtools.pagedatamodel.api.IPageDataNode;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataModel;
import com.ibm.etools.webtools.pagedatamodel.impl.PageDataNode;
import com.ibm.etools.webtools.pagedataview.ui.CategoryChangeNotifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class FormBeanPDMListener
implements IPageDataModelLifeCycleListener,
IReferenceListener {
    public static final String FORM_BEAN_CATEGORY_ID = "StrutsFormBean";
    private List<IPageDataModel> allModels = new ArrayList<IPageDataModel>();
    private List<ILink> formBeanHandles = new ArrayList<ILink>();
    private boolean isListening = false;
    public List<IFile> javaClassHandles = new ArrayList<IFile>();
    private List<IPageDataNode> pageDataRootNodes = new ArrayList<IPageDataNode>();

    public void handleReferenceEvents(List<ReferenceEvent> events) {
        boolean doRefresh = false;
        for (ReferenceEvent referenceEvent : events) {
            ILink link;
            if (referenceEvent.getReferenceElement().getElementType() != IReferenceElement.ElementType.LINK || !"struts.formbean.link".equals((link = (ILink)referenceEvent.getReferenceElement()).getSpecializedType().getId())) continue;
            doRefresh = true;
        }
        if (doRefresh) {
            for (IPageDataNode node : this.pageDataRootNodes) {
                this.refreshBeans(node);
            }
            UIJob job = new UIJob("Category Change"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    CategoryChangeNotifier.getSingleton().fireCategoryChanged(FormBeanPDMListener.FORM_BEAN_CATEGORY_ID);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    public void pageDataModelInitialized(IPageDataModel pmodel) {
        IDOMModel model = ((PageDataModel)pmodel).getIDOMModel();
        if (model.getContentTypeIdentifier().equals(ContentTypeIdForJSP.ContentTypeID_JSP)) {
            this.pageDataRootNodes.add(pmodel.getRoot());
            final IPageDataNode root = pmodel.getRoot();
            Job job = new Job("Refresh form beans"){

                protected IStatus run(IProgressMonitor monitor) {
                    FormBeanPDMListener.this.refreshBeans(root);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            CategoryChangeNotifier.getSingleton().fireCategoryChanged(FORM_BEAN_CATEGORY_ID);
            this.allModels.add(pmodel);
        }
        if (!this.allModels.isEmpty() && !this.isListening) {
            ReferenceManager.getReferenceManager().addReferenceListener((IReferenceListener)this);
            this.isListening = true;
        }
    }

    public void pageDataModelReleased() {
    }

    public void pageDataModelToBeInitialized(IPageDataModel arg0) {
    }

    public void pageDataModelToBeReleased(IPageDataModel model) {
        this.allModels.remove(model);
        if (this.allModels.isEmpty() && this.isListening) {
            ReferenceManager.getReferenceManager().removeReferenceListener((IReferenceListener)this);
            this.isListening = false;
        }
        int i = 0;
        while (i < this.pageDataRootNodes.size()) {
            IPageDataNode root = this.pageDataRootNodes.get(i);
            if (root.getPageDataModel() == model) {
                this.pageDataRootNodes.remove(i);
                break;
            }
            ++i;
        }
    }

    private void refreshBeans(IPageDataNode root) {
        EList allChildren = root.getChildren();
        int size = allChildren.size();
        int i = size - 1;
        while (i >= 0) {
            IPageDataNode node = (IPageDataNode)allChildren.get(i);
            if (FORM_BEAN_CATEGORY_ID.equals(node.getCategory())) {
                ((PageDataNode)root).removeChildWithoutNotification(node);
            }
            --i;
        }
        this.javaClassHandles = new ArrayList<IFile>();
        this.formBeanHandles = new ArrayList<ILink>();
        IFile file = root.getPageDataModel().getResource();
        try {
            String module = StrutsSearchUtil.getModuleForIFile((IFile)file, null);
            SearchScope scope = StrutsSearchUtil.getModuleScope((IProject)file.getProject(), (String)module, null);
            Set formBeans = StrutsSearchUtil.getAllFormBeans((SearchScope)scope, null);
            ArrayList<IFile> javaFiles = new ArrayList<IFile>();
            for (ILink formBean : formBeans) {
                LinkNode container;
                ILink javaLink = StrutsSearchUtil.getJavaTarget((ILink)formBean);
                if (javaLink != null && (container = javaLink.getContainer()) != null) {
                    IFile javafile = (IFile)container.getResource();
                    if (file != null) {
                        javaFiles.add(javafile);
                    }
                }
                String type = StrutsLinksSearchUtil.getFormBeanType(formBean);
                ((PageDataNode)root).addChildWithoutNotification((IPageDataNode)FormBeanModelUtil.createFormBeanPageDataNode(root, type, formBean.getName(), formBean));
            }
            this.formBeanHandles.addAll(formBeans);
            this.javaClassHandles.addAll(javaFiles);
        }
        catch (ReferenceException e) {
            e.printStackTrace();
        }
    }
}

