/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.htmltags;

import com.ibm.etools.struts.ContextIds;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.jspeditor.attrview.parts.StrutsTextPart;
import com.ibm.etools.struts.jspeditor.vct.ErrorOpenResourceBundleException;
import com.ibm.etools.struts.jspeditor.vct.StrutsVisualizerUtil;
import com.ibm.etools.struts.jspeditor.vct.htmltags.AddErrorsKeysDialog;
import com.ibm.etools.struts.jspeditor.vct.htmltags.StrutsHtmlTagVisualizer;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.webedit.vct.Context;
import com.ibm.etools.webedit.vct.VisualizerReturnCode;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.w3c.dom.Node;

public class StrutsHtmlErrorsTagVisualizer
extends StrutsHtmlTagVisualizer
implements ContextIds {
    private Context myContext;
    private Node myNode;
    private static String ErrorsDisplayOptionKey = "errors.display.option";
    private static String ErrorsKeysKey = "errors.keys";
    private static String ErrorsHeaderKey = "errors.header";
    private static String ErrorsFooterKey = "errors.footer";
    private static String ErrorPrefix = "errors.prefix";
    private static String ErrorSuffix = "errors.suffix";

    private void addErrorMsgsItemString(StringBuffer errorsTextBuffer, Context context, ArrayList errorMsgs) {
        if (errorMsgs.size() == 0) {
            return;
        }
        String prefix = null;
        String suffix = null;
        if (StrutsVisualizerUtil.getStrutsVersion(context) >= 1) {
            try {
                prefix = StrutsVisualizerUtil.getString(context, ErrorPrefix, this);
                suffix = StrutsVisualizerUtil.getString(context, ErrorSuffix, this);
            }
            catch (ErrorOpenResourceBundleException errorOpenResourceBundleException) {}
        }
        if (prefix == null && suffix == null) {
            Iterator iterator = errorMsgs.iterator();
            while (iterator.hasNext()) {
                errorsTextBuffer.append("\r\n");
                errorsTextBuffer.append((String)iterator.next());
            }
        } else {
            if (prefix == null) {
                prefix = "";
            }
            if (suffix == null) {
                suffix = "";
            }
            Iterator iterator = errorMsgs.iterator();
            while (iterator.hasNext()) {
                errorsTextBuffer.append("\r\n");
                errorsTextBuffer.append(prefix);
                errorsTextBuffer.append((String)iterator.next());
                errorsTextBuffer.append(suffix);
            }
        }
    }

    public void addPushButtonSelected(Composite composite, StrutsTextPart textPart) {
        if (this.myContext == null) {
            return;
        }
        AddErrorsKeysDialog dialog = new AddErrorsKeysDialog(composite.getShell(), this.myContext, this);
        dialog.open();
        String[] selectedKeys = dialog.getSelectedKeys();
        if (selectedKeys == null || dialog.getReturnCode() == 1) {
            return;
        }
        String temp = textPart.getValue();
        if (temp == null) {
            temp = "";
        }
        int i = 0;
        while (i < selectedKeys.length) {
            temp = temp.concat("\r\n" + selectedKeys[i]);
            textPart.setValue(temp);
            temp = textPart.getValue();
            ++i;
        }
    }

    public VisualizerReturnCode doStart(Context context) {
        this.myContext = context;
        this.myNode = context.getSelf();
        if (this.getErrorsDisplayOption()) {
            ArrayList errorMsgs = null;
            String errorKeysString = this.getErrorsKeysString();
            if (errorKeysString != null && errorKeysString.length() > 0) {
                try {
                    errorMsgs = StrutsVisualizerUtil.getStringsFromKeys(context, StrutsVisualizerUtil.getCollectionOfLines(errorKeysString), this);
                }
                catch (ErrorOpenResourceBundleException e) {
                    StrutsVisualizerUtil.displayErrorMessageString(context, e.getMessage(), this);
                    return VisualizerReturnCode.OK;
                }
            } else {
                errorMsgs = StrutsVisualizerUtil.getActionErrors();
            }
            String errorMsgText = this.getErrorMsgsText(context, errorMsgs);
            if (errorMsgText != null) {
                context.putVisual(errorMsgText);
            }
        } else {
            context.putVisual(null);
        }
        return VisualizerReturnCode.OK;
    }

    private String getErrorMsgsText(Context context, ArrayList errorMsgs) {
        StringBuffer errorsTextBuffer = new StringBuffer();
        try {
            String text = StrutsVisualizerUtil.getString(context, ErrorsHeaderKey, this);
            if (text == null) {
                text = ResourceHandler.StrutsVCT_errorstag_header;
            }
            errorsTextBuffer.append(text);
            this.addErrorMsgsItemString(errorsTextBuffer, context, errorMsgs);
            text = StrutsVisualizerUtil.getString(context, ErrorsFooterKey, this);
            if (text == null) {
                text = ResourceHandler.StrutsVCT_errorstag_footer;
            }
            errorsTextBuffer.append(text);
        }
        catch (ErrorOpenResourceBundleException errorOpenResourceBundleException) {
            String text = ResourceHandler.StrutsVCT_errorstag_header;
            errorsTextBuffer.append(text);
            this.addErrorMsgsItemString(errorsTextBuffer, context, errorMsgs);
            text = ResourceHandler.StrutsVCT_errorstag_footer;
            errorsTextBuffer.append(text);
        }
        return errorsTextBuffer.toString();
    }

    public boolean getErrorsDisplayOption() {
        String preferenceString = null;
        if (this.myContext != null) {
            try {
                preferenceString = StrutsVisualizerUtil.getResourcePreference(this.myContext.getMyPath(), this.myNode, ErrorsDisplayOptionKey);
            }
            catch (CoreException e) {
                StrutsPlugin.getLogger().log((Throwable)e);
            }
        }
        boolean value = preferenceString == null ? StrutsVisualizerUtil.getErrorsDisplay() : new Boolean(preferenceString);
        return value;
    }

    public String getErrorsKeysString() {
        String preferenceString = null;
        if (this.myContext != null) {
            try {
                preferenceString = StrutsVisualizerUtil.getResourcePreference(this.myContext.getMyPath(), this.myNode, ErrorsKeysKey);
            }
            catch (CoreException e) {
                StrutsPlugin.getLogger().log((Throwable)e);
            }
        }
        return preferenceString;
    }

    public ArrayList getErrorsStrings() {
        String keysStr = this.getErrorsKeysString();
        if (keysStr != null && keysStr.length() > 0) {
            return StrutsVisualizerUtil.getCollectionOfLines(keysStr);
        }
        return null;
    }

    public boolean isReadOnlyVisual() {
        return true;
    }

    public void savePreference(String key, String value) {
        try {
            String pathString = this.myContext.getMyPath();
            StrutsVisualizerUtil.setResourcePreference(pathString, this.myNode, key, value);
        }
        catch (CoreException e) {
            StrutsPlugin.getLogger().log((Throwable)e);
        }
    }

    public void setErrorsDisplayOption(boolean selection) {
        if (this.myContext != null) {
            this.savePreference(ErrorsDisplayOptionKey, new Boolean(selection).toString());
            this.myContext.refresh();
        }
    }

    public void setErrorsKeysString(String keysString) {
        if (this.myContext != null) {
            this.savePreference(ErrorsKeysKey, keysString);
            this.myContext.refresh();
        }
    }

    public boolean useCustomAttributeView() {
        return true;
    }
}

