/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.dialog;

import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.core.util.ActionMappingWildcardUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;

public class ActionDialogElement
implements Comparable<ActionDialogElement>,
IAdaptable {
    private ILink actionLink;
    private String actionPath;
    private boolean concrete = false;
    private String module;
    private ActionMappingWildcardUtil wcUtil = null;

    public ActionDialogElement(ILink actionLink) {
        assert (actionLink != null);
        this.actionLink = actionLink;
        this.wcUtil = new ActionMappingWildcardUtil(actionLink.getContainer().getResource().getProject(), actionLink.getName());
        this.concrete = !this.wcUtil.actionHasWildcards();
        this.actionPath = actionLink.getName();
        if (!this.actionPath.startsWith("/")) {
            this.actionPath = "/" + this.actionPath;
        }
        try {
            this.module = StrutsSearchUtil.getModuleForILink((ILink)actionLink, null);
        }
        catch (ReferenceException e) {
            this.module = "";
            StrutsPlugin.getLogger().log((Throwable)e);
        }
    }

    public ActionDialogElement(IResolvedReference actionRef) {
        assert (actionRef != null);
        this.actionLink = actionRef.getTarget();
        this.concrete = true;
        this.wcUtil = new ActionMappingWildcardUtil(this.actionLink.getContainer().getResource().getProject(), this.actionLink.getName());
        this.actionPath = StrutsSearchUtil.depatternActionString((IProject)actionRef.getSource().getContainer().getResource().getProject(), (String)actionRef.getFragmentText(), null);
        if (!this.actionPath.startsWith("/")) {
            this.actionPath = "/" + this.actionPath;
        }
        try {
            this.module = StrutsSearchUtil.getModuleForILink((ILink)actionRef.getTarget(), null);
        }
        catch (ReferenceException e) {
            this.module = "";
            StrutsPlugin.getLogger().log((Throwable)e);
        }
    }

    @Override
    public int compareTo(ActionDialogElement o) {
        return this.actionPath.compareTo(o.getPath());
    }

    public boolean equals(Object o) {
        if (!(o instanceof ActionDialogElement)) {
            return false;
        }
        ActionDialogElement other = (ActionDialogElement)o;
        boolean same = true;
        same &= other.getModule().equals(this.module);
        same &= other.getPath().equals(this.actionPath);
        return same &= other.getLink().equals(this.actionLink);
    }

    public ActionMappingWildcardUtil getActionMappingWildcardUtil() {
        return this.wcUtil;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ILink.class)) {
            return this.actionLink;
        }
        return null;
    }

    public ILink getLink() {
        return this.actionLink;
    }

    public String getModule() {
        return this.module;
    }

    public String getPath() {
        return this.actionPath;
    }

    public int hashCode() {
        return this.module.hashCode() + this.actionPath.hashCode() + this.actionLink.hashCode();
    }

    public boolean isConcrete() {
        return this.concrete;
    }

    public void setPath(String newActionPath) {
        this.actionPath = newActionPath;
    }

    public String toString() {
        return "[module=" + this.module + ", path=" + this.actionPath + "]";
    }
}

