/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.dialog;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.IResolvedReference;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.jspeditor.vct.dialog.ActionDialogElement;
import com.ibm.etools.struts.util.StrutsLinksSearchUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class ActionContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private IVirtualComponent component;
    private final String ignoreModule;
    private final String showOnlyModule;

    public ActionContentProvider(String ignoreModule, String showOnlyModule) {
        this.ignoreModule = ignoreModule;
        this.showOnlyModule = showOnlyModule;
    }

    public void dispose() {
        this.component = null;
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<ActionDialogElement> children = new ArrayList<ActionDialogElement>();
        IProject project = this.component.getProject();
        boolean projectAllowsWildcards = StrutsProjectCoreUtil.isStruts1_2OrHigher((IProject)project);
        try {
            if (parentElement instanceof String) {
                String module = parentElement.toString();
                Set configFiles = StrutsSearchUtil.getStrutsConfigFilesInAModule((IProject)project, (String)module, (IProgressMonitor)new NullProgressMonitor());
                for (ILink cf : configFiles) {
                    Set actionMappings = StrutsSearchUtil.getAllActionMappingsInStrutsConfigFile((IResource)cf.getContainer().getResource(), (IProgressMonitor)new NullProgressMonitor());
                    for (ILink am : actionMappings) {
                        ActionDialogElement newElement = new ActionDialogElement(am);
                        if (!newElement.isConcrete() && (newElement.isConcrete() || !projectAllowsWildcards)) continue;
                        children.add(new ActionDialogElement(am));
                    }
                }
            } else if (parentElement instanceof ActionDialogElement && !((ActionDialogElement)parentElement).isConcrete()) {
                ActionDialogElement padElement = (ActionDialogElement)parentElement;
                String module = padElement.getModule();
                ILink ampLink = padElement.getLink();
                Set concreteValues = StrutsSearchUtil.getActionMappingIncomingReferences((IProject)project, (String)ampLink.getName(), (String)module, null);
                for (IResolvedReference l : concreteValues) {
                    ActionDialogElement ade = new ActionDialogElement(l);
                    if (children.contains(ade)) continue;
                    children.add(ade);
                }
            }
        }
        catch (ReferenceException e) {
            StrutsLinksSearchUtil.log(e);
        }
        Collections.sort(children);
        return children.toArray();
    }

    public Object[] getElements(Object inputElement) {
        if (this.component.getProject().equals(inputElement)) {
            Set<String> mods;
            try {
                mods = StrutsSearchUtil.getModulesForProject((IProject)this.component.getProject(), null);
            }
            catch (ReferenceException e) {
                e.printStackTrace();
                mods = Collections.emptySet();
            }
            Object[] modules = mods.toArray(new String[mods.size()]);
            if (this.ignoreModule == null && this.showOnlyModule == null) {
                return modules;
            }
            if (this.ignoreModule != null) {
                ArrayList<Object> filtered = new ArrayList<Object>();
                int i = 0;
                while (i < modules.length) {
                    Object string = modules[i];
                    if (string instanceof String && !this.ignoreModule.equals(string)) {
                        filtered.add(string);
                    }
                    ++i;
                }
                return filtered.toArray(new Object[filtered.size()]);
            }
            if (this.showOnlyModule != null) {
                ArrayList<Object> filtered = new ArrayList<Object>();
                int i = 0;
                while (i < modules.length) {
                    Object string = modules[i];
                    if (string instanceof String && this.showOnlyModule.equals(string)) {
                        filtered.add(string);
                    }
                    ++i;
                }
                return filtered.toArray(new Object[filtered.size()]);
            }
        }
        return EMPTY_ARRAY;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.dispose();
        if (newInput instanceof IProject) {
            this.component = Model2Util.findComponent((IResource)((IProject)newInput));
        }
    }
}

