/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.attrview.parts;

import com.ibm.etools.struts.jspeditor.vct.attrview.data.IAttributeData;
import com.ibm.etools.struts.jspeditor.vct.attrview.events.PropertyEvent;
import com.ibm.etools.struts.jspeditor.vct.attrview.events.PropertyValidationEvent;
import com.ibm.etools.struts.jspeditor.vct.attrview.events.PropertyValidationListener;
import com.ibm.etools.struts.jspeditor.vct.attrview.events.PropertyValueListener;
import com.ibm.etools.struts.jspeditor.vct.attrview.parts.PartsUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public abstract class PropertyPart
implements FocusListener,
KeyListener,
MouseListener,
SelectionListener,
ModifyListener {
    static final int KC_ENTER = 13;
    static final int BEGINNING = 1;
    static final int CENTER = 2;
    static final int END = 3;
    static final int FILL = 4;
    static final int LEFT = 1;
    static final int RIGHT = 3;
    static final int TOP = 1;
    static final int MIDDLE = 2;
    static final int BOTTOM = 3;
    private Composite parent = null;
    private Decorations menuShell = null;
    private Composite root = null;
    private Control title = null;
    private boolean ambiguous = false;
    private boolean valid = false;
    private boolean invalid = false;
    private String msg = null;
    private boolean enabled = true;
    private boolean visible = true;
    private boolean disposed = false;
    boolean active = false;
    PropertyValueListener valueListener = null;
    PropertyValidationListener validationListener = null;
    private int indent = 0;
    private Control[] controls = null;
    protected static final boolean AMBIGUOUS_CLEAR = true;
    protected static final boolean AMBIGUOUS_GRAY = false;

    public PropertyPart(Composite parent) {
        this.parent = parent;
        this.menuShell = null;
        Composite control = parent;
        while (control != null) {
            if (control instanceof Decorations) {
                this.menuShell = (Decorations)control;
                break;
            }
            control = control.getParent();
        }
    }

    protected static void dispose(Image image) {
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
    }

    protected static void dispose(Widget widget) {
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
    }

    private static void grayControl(Control control, boolean grey) {
        if (control != null) {
            Color color = control.getDisplay().getSystemColor(21);
            if (grey) {
                int r = (color.getRed() + 255) / 2;
                int g = (color.getGreen() + 255) / 2;
                int b = (color.getBlue() + 255) / 2;
                color = new Color((Device)control.getDisplay(), r, g, b);
            }
            control.setForeground(color);
        }
    }

    protected static void setWidthHint(Control control, int widthHint) {
        if (widthHint > 0) {
            PartsUtil.setWidthHint(control, widthHint * PartsUtil.getTextExtent((Control)control.getParent(), (String)"X").x);
        }
    }

    void createRoot(int numColumns, int align, int valign) {
        if (this.root != null) {
            this.root.dispose();
        }
        this.root = PartsUtil.createAreaComposite(this.getParent(), numColumns, align, valign);
    }

    void createTitleCheck(String text) {
        this.title = PartsUtil.createButton(this.getRoot(), text != null ? text : "", 32, null);
    }

    void createTitleLabel(String text) {
        this.title = PartsUtil.createLabel(this.getRoot(), text != null ? text : "", 0, null);
    }

    public void dispose() {
        this.disposed = true;
        this.menuShell = null;
        if (this.root != null) {
            this.root.dispose();
            this.root = null;
        }
        if (this.title != null) {
            this.title.dispose();
            this.title = null;
        }
    }

    public void focusGained(FocusEvent e) {
        this.active = true;
        if (this.valueListener != null) {
            this.valueListener.focusGained(new PropertyEvent(e, this));
        }
    }

    public void focusLost(FocusEvent e) {
        if (this.menuShell != null && e.widget instanceof Button) {
            this.menuShell.setDefaultButton(null);
        }
        this.active = false;
        if (this.valueListener != null) {
            this.valueListener.focusLost(new PropertyEvent(e, this));
        }
    }

    public String getAttributeName() {
        return null;
    }

    public Control getFocusControl() {
        if (this.title != null && this.title.isFocusControl()) {
            return this.title;
        }
        return null;
    }

    public int getIndent() {
        return this.indent;
    }

    public String getMessage() {
        if (this.active) {
            return this.msg;
        }
        return null;
    }

    public Composite getParent() {
        return this.parent;
    }

    public Composite getRoot() {
        return this.root;
    }

    public Control getTitle() {
        return this.title;
    }

    public Control getTitleControl() {
        return this.title;
    }

    public String getTitleText() {
        if (this.title != null) {
            if (this.title instanceof Label) {
                return ((Label)this.title).getText();
            }
            if (this.title instanceof Button) {
                return ((Button)this.title).getText();
            }
        }
        return null;
    }

    public boolean isAmbiguous() {
        return this.ambiguous;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void modifyText(ModifyEvent e) {
        Control c;
        if (e.widget instanceof Control && (c = (Control)e.widget).isFocusControl()) {
            if (this.isAmbiguous()) {
                this.setAmbiguous(false);
            }
            if (this.validationListener != null) {
                this.validationListener.valueChanged(new PropertyValidationEvent(e, this));
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void reset() {
        if (this.controls != null && this.ambiguous) {
            int i = 0;
            while (i < this.controls.length) {
                PropertyPart.grayControl(this.controls[i], false);
                ++i;
            }
        }
        this.setAmbiguous(false);
    }

    public void setAmbiguous(boolean ambiguous) {
        this.ambiguous = ambiguous;
        if (this.controls != null) {
            int i = 0;
            while (i < this.controls.length) {
                if (ambiguous) {
                    Control c = this.controls[i];
                    if (c instanceof Button) {
                        ((Button)c).setSelection(false);
                    } else if (c instanceof Combo) {
                        ((Combo)c).deselectAll();
                    } else if (c instanceof List) {
                        ((List)c).deselectAll();
                    } else if (c instanceof Text) {
                        ((Text)c).setText("");
                    }
                }
                ++i;
            }
        }
    }

    protected void setControls(Control[] controls) {
        this.controls = controls;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.title != null) {
            this.title.setEnabled(enabled);
        }
    }

    public void setHorizontalIndent(int indent) {
        if (indent > 0) {
            PartsUtil.setHorizontalIndent((Control)this.getRoot(), indent * PartsUtil.getTextExtent((Control)this.getParent(), (String)"X").x);
        }
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
        if (invalid) {
            this.valid = false;
        }
    }

    public void setMessage(String msg) {
        this.msg = msg;
    }

    public void setTitleText(String text) {
        if (this.title != null) {
            if (this.title instanceof Label) {
                ((Label)this.title).setText(text);
            } else {
                ((Button)this.title).setText(text);
            }
        }
    }

    public void setTitleWidthHint(int widthHint) {
        PropertyPart.setWidthHint(this.title, widthHint);
    }

    public void setValid(boolean valid) {
        this.valid = valid;
        if (valid) {
            this.invalid = false;
        }
    }

    public PropertyValidationListener setValidationListener(PropertyValidationListener validationListener) {
        PropertyValidationListener oldListener = this.validationListener;
        this.validationListener = validationListener;
        return oldListener;
    }

    public void setValue(IAttributeData data) {
        if (data.isSpecified()) {
            this.setValue(data.getValue());
            this.setAmbiguous(data.isAmbiguous());
            this.setEnabled(data.isEnabled());
        } else {
            this.reset();
        }
    }

    public abstract void setValue(String var1);

    public PropertyValueListener setValueListener(PropertyValueListener valueListener) {
        PropertyValueListener oldListener = this.valueListener;
        this.valueListener = valueListener;
        return oldListener;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
        if (this.root != null) {
            this.root.setVisible(visible);
        }
    }

    public void update() {
        this.setInvalid(false);
        if (this.validationListener != null) {
            Event e = new Event();
            this.validationListener.valueChanged(new PropertyValidationEvent(e, this));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
    }
}

