/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.attrview.parts;

import com.ibm.etools.struts.nls.ResourceHandler;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class PartsUtil {
    public static final int BEGINNING = 1;
    public static final int CENTER = 2;
    public static final int END = 3;
    public static final int FILL = 4;
    public static final int LEFT = 1;
    public static final int RIGHT = 3;
    public static final int TOP = 1;
    public static final int MIDDLE = 2;
    public static final int BOTTOM = 3;

    public static void align(Control control, int horizontal, int vertical) {
        PartsUtil.setHorizontalAlignment(control, horizontal);
        PartsUtil.setVerticalAlignment(control, vertical);
    }

    public static void alignWidth(Control control1, Control control2) {
        PartsUtil.alignWidth(new Control[]{control1, control2});
    }

    public static void alignWidth(Control control1, Control control2, Control control3) {
        PartsUtil.alignWidth(new Control[]{control1, control2, control3});
    }

    public static void alignWidth(Control[] controls) {
        int maxWidth = 0;
        int i = 0;
        while (i < controls.length) {
            int widthHint;
            Control c = controls[i];
            int w = 0;
            if (c instanceof Combo) {
                w = PartsUtil.getPreferredWidth((Combo)c);
            }
            if (w == 0) {
                w = c.computeSize((int)-1, (int)-1).x;
            }
            if (maxWidth < w) {
                maxWidth = w;
            }
            if (maxWidth < (widthHint = PartsUtil.getWidthHint(c))) {
                maxWidth = widthHint;
            }
            ++i;
        }
        i = 0;
        while (i < controls.length) {
            PartsUtil.setWidthHint(controls[i], maxWidth);
            ++i;
        }
    }

    public static Composite createAreaComposite(Composite parent, int numColumns, int align, int valign) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 3;
        GridData gridData = new GridData();
        if (align == 2) {
            gridData.horizontalAlignment = 2;
            gridData.grabExcessHorizontalSpace = true;
        } else if (align == 3) {
            gridData.horizontalAlignment = 3;
            gridData.grabExcessHorizontalSpace = true;
        } else if (align == 4) {
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
        }
        if (valign == 2) {
            gridData.verticalAlignment = 2;
            gridData.grabExcessVerticalSpace = true;
        } else if (valign == 3) {
            gridData.verticalAlignment = 3;
            gridData.grabExcessVerticalSpace = true;
        } else if (valign == 4) {
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
        }
        return PartsUtil.createComposite(parent, 0, gridLayout, gridData);
    }

    public static Button createBeanPropertyBrowseButton(Composite parent) {
        return PartsUtil.createBrowseButton(parent);
    }

    public static Button createBrowseButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(ResourceHandler.Browse__UI_);
        Display display = button.getDisplay();
        Font font = button.getFont();
        GC gc = new GC((Drawable)display);
        gc.setFont(font);
        Point size = gc.textExtent("....");
        size.x += 6;
        size.y = size.y < 12 ? 9 : size.y - 3;
        gc.dispose();
        Color fg = display.getSystemColor(21);
        Color bg = display.getSystemColor(22);
        RGB[] colormap = new RGB[]{bg.getRGB(), fg.getRGB()};
        ImageData imageData = new ImageData(size.x, size.y, 8, new PaletteData(colormap));
        Image image = new Image((Device)display, imageData);
        image.setBackground(bg);
        gc = new GC((Drawable)image);
        gc.setFont(font);
        gc.setBackground(bg);
        gc.setForeground(fg);
        gc.fillRectangle(0, 0, size.x, size.y);
        gc.drawText("...", (size.x - gc.textExtent((String)"...").x) / 2, 0);
        gc.dispose();
        button.setImage(image);
        return button;
    }

    public static Button createButton(Composite parent, String text, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        Button button = new Button(parent, style);
        if (text != null) {
            button.setText(text);
        }
        if (gridData != null) {
            button.setLayoutData((Object)gridData);
        }
        return button;
    }

    public static Combo createCombo(Composite parent, String[] items, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        Combo combo = new Combo(parent, style);
        if (items != null) {
            combo.setItems(items);
            combo.select(0);
        }
        if (gridData != null) {
            combo.setLayoutData((Object)gridData);
        }
        return combo;
    }

    public static Composite createComposite(Composite parent, int style, GridLayout gridLayout, GridData gridData) {
        Composite composite = new Composite(parent, style);
        if (gridLayout != null) {
            composite.setLayout((Layout)gridLayout);
        }
        if (gridData != null) {
            composite.setLayoutData((Object)gridData);
        }
        return composite;
    }

    public static Button createDownButton(Composite parent) {
        Button button = PartsUtil.createButton(parent, null, 1028, null);
        button.setText(ResourceHandler.ui_proppage_directtable_editor__down);
        return button;
    }

    public static Combo createEditableCombo(Composite parent, String[] items, boolean fill) {
        GridData gridData = null;
        if (fill) {
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
        }
        return PartsUtil.createCombo(parent, items, 0, gridData);
    }

    public static Composite createFieldContainer(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 3;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    public static Button createFileBrowseButton(Composite parent) {
        return PartsUtil.createMultiBrowseButton(parent);
    }

    public static Label createLabel(Composite parent, String text, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        Label label = new Label(parent, style);
        if (text != null) {
            label.setText(text);
        }
        if (gridData != null) {
            label.setLayoutData((Object)gridData);
        }
        return label;
    }

    public static List createList(Composite parent, String[] items, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        List list = new List(parent, style);
        if (items != null) {
            list.setItems(items);
        }
        if (gridData != null) {
            list.setLayoutData((Object)gridData);
        }
        return list;
    }

    public static Button createMultiBrowseButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(ResourceHandler.Browse__UI_);
        Display display = button.getDisplay();
        Font font = button.getFont();
        GC gc = new GC((Drawable)display);
        gc.setFont(font);
        Point size = gc.textExtent("....");
        size.x += 12;
        size.y = size.y < 9 ? 9 : size.y;
        gc.dispose();
        Color fg = display.getSystemColor(21);
        Color bg = display.getSystemColor(22);
        RGB[] colormap = new RGB[]{bg.getRGB(), fg.getRGB()};
        ImageData imageData = new ImageData(size.x, size.y, 8, new PaletteData(colormap));
        Image image = new Image((Device)display, imageData);
        image.setBackground(bg);
        gc = new GC((Drawable)image);
        gc.setFont(font);
        gc.setBackground(bg);
        gc.setForeground(fg);
        gc.fillRectangle(0, 0, size.x, size.y);
        gc.drawText("...", 0, 0);
        gc.setBackground(fg);
        int[] triangle = new int[]{size.x - 10, size.y - 7, size.x - 3, size.y - 7, size.x - 7, size.y - 3};
        gc.fillPolygon(triangle);
        gc.dispose();
        button.setImage(image);
        return button;
    }

    public static Composite createPageComposite(Composite parent) {
        return PartsUtil.createComposite(parent, 0, new GridLayout(), null);
    }

    public static Composite createPartComposite(Composite parent, int numColumns, int align) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 3;
        GridData gridData = new GridData();
        if (align == 2) {
            gridData.horizontalAlignment = 2;
            gridData.grabExcessHorizontalSpace = true;
        } else if (align == 3) {
            gridData.horizontalAlignment = 3;
            gridData.grabExcessHorizontalSpace = true;
        } else if (align == 4) {
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
        }
        gridData.verticalAlignment = 4;
        return PartsUtil.createComposite(parent, 0, gridLayout, gridData);
    }

    public static Composite createRootContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        return composite;
    }

    public static Label createSeparator(Composite parent) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        return PartsUtil.createLabel(parent, null, 258, gridData);
    }

    public static Table createTable(Composite parent, boolean fill) {
        Table table = new Table(parent, 67588);
        if (fill) {
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            table.setLayoutData((Object)gridData);
        }
        table.setHeaderVisible(true);
        return table;
    }

    public static Table createTable(Composite parent, int style, boolean fill) {
        Table table = new Table(parent, style);
        if (fill) {
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            table.setLayoutData((Object)gridData);
        }
        table.setHeaderVisible(true);
        return table;
    }

    public static Text createText(Composite parent, int style, GridData gridData) {
        if (parent == null) {
            return null;
        }
        Text text = new Text(parent, style);
        if (gridData != null) {
            text.setLayoutData((Object)gridData);
        }
        return text;
    }

    public static Text createTextArea(Composite parent, int numRows) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        if (numRows > 0) {
            gridData.heightHint = PartsUtil.getTextExtent((Control)parent, (String)"X").y * numRows;
        }
        return PartsUtil.createText(parent, 2818, gridData);
    }

    public static Text createTextField(Composite parent, boolean fill) {
        return PartsUtil.createTextField(parent, fill, false);
    }

    public static Text createTextField(Composite parent, boolean fill, boolean readonly) {
        int style = 2052;
        if (readonly) {
            style |= 8;
        }
        GridData gridData = null;
        if (fill) {
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
        }
        return PartsUtil.createText(parent, style, gridData);
    }

    public static Button createUpButton(Composite parent) {
        Button button = PartsUtil.createButton(parent, null, 132, null);
        button.setText(ResourceHandler.ui_proppage_directtable_editor__up);
        return button;
    }

    public static Label createWrappedLabel(Composite labelParent, String message, int numSpareRows, GridData labelGridData) {
        int tmpNumRows;
        if (labelParent == null) {
            return null;
        }
        int n = tmpNumRows = message.length() / 30 > 1 ? message.length() / 30 : 1;
        if (labelGridData == null) {
            labelGridData = new GridData();
            labelGridData.grabExcessHorizontalSpace = true;
            labelGridData.grabExcessVerticalSpace = false;
            labelGridData.horizontalAlignment = 4;
            labelGridData.verticalAlignment = 1;
            labelGridData.widthHint = PartsUtil.getTextExtent((Control)labelParent, (String)message).x / tmpNumRows;
            labelGridData.heightHint = (tmpNumRows += numSpareRows) * PartsUtil.getTextExtent((Control)labelParent, (String)"X").y;
        }
        Label newLabel = PartsUtil.createLabel(labelParent, message, 64, labelGridData);
        return newLabel;
    }

    public static int getHorizontalAlignment(Control control) {
        Object layoutData = control.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            return ((GridData)layoutData).horizontalAlignment;
        }
        return 0;
    }

    public static int getNumColumns(Composite composite) {
        Layout layout = composite.getLayout();
        if (layout instanceof GridLayout) {
            return ((GridLayout)layout).numColumns;
        }
        return 0;
    }

    public static int getPreferredWidth(Combo combo) {
        if (combo == null || combo.getItemCount() < 1) {
            return 0;
        }
        int width = 0;
        int i = 0;
        while (i < combo.getItemCount()) {
            int w = PartsUtil.getTextExtent((Control)combo, (String)combo.getItem((int)i)).x + 8;
            if (width < w) {
                width = w;
            }
            ++i;
        }
        return width;
    }

    public static Point getTextExtent(Control control, String text) {
        GC gc = new GC((Drawable)control);
        Point point = gc.textExtent(text);
        gc.dispose();
        return point;
    }

    public static int getVerticalAlignment(Control control) {
        Object layoutData = control.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            return ((GridData)layoutData).verticalAlignment;
        }
        return 0;
    }

    public static int getWidthHint(Control control) {
        Object layoutData = control.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            return ((GridData)layoutData).widthHint;
        }
        return 0;
    }

    public static void setHeightHint(Control control, int heightHint) {
        Object layoutData = control.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            ((GridData)layoutData).heightHint = heightHint;
        } else {
            GridData gridData = new GridData();
            gridData.heightHint = heightHint;
            control.setLayoutData((Object)gridData);
        }
    }

    public static void setHorizontalAlignment(Control control, int align) {
        Object layoutData = control.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            ((GridData)layoutData).horizontalAlignment = align;
        } else {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = align;
            control.setLayoutData((Object)gridData);
        }
    }

    public static void setHorizontalIndent(Control control, int horizontalIndent) {
        Object layoutData = control.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            ((GridData)layoutData).horizontalIndent = horizontalIndent;
        } else {
            GridData gridData = new GridData();
            gridData.horizontalIndent = horizontalIndent;
            control.setLayoutData((Object)gridData);
        }
    }

    public static void setHorizontalSpan(Control control, Composite parent, int numUsedColumns) {
        PartsUtil.setHorizontalSpan(control, PartsUtil.getNumColumns(parent) - numUsedColumns);
    }

    public static void setHorizontalSpan(Control control, int horizontalSpan) {
        Object layoutData;
        if (horizontalSpan < 1) {
            horizontalSpan = 1;
        }
        if ((layoutData = control.getLayoutData()) != null && layoutData instanceof GridData) {
            ((GridData)layoutData).horizontalSpan = horizontalSpan;
        } else {
            GridData gridData = new GridData();
            gridData.horizontalSpan = horizontalSpan;
            control.setLayoutData((Object)gridData);
        }
    }

    public static void setVerticalAlignment(Control control, int align) {
        Object layoutData = control.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            ((GridData)layoutData).verticalAlignment = align;
        } else {
            GridData gridData = new GridData();
            gridData.verticalAlignment = align;
            control.setLayoutData((Object)gridData);
        }
    }

    public static void setWidthHint(Control control, int widthHint) {
        Object layoutData = control.getLayoutData();
        if (layoutData != null && layoutData instanceof GridData) {
            ((GridData)layoutData).widthHint = widthHint;
        } else {
            GridData gridData = new GridData();
            gridData.widthHint = widthHint;
            control.setLayoutData((Object)gridData);
        }
    }
}

