/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.attrview.data;

import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.struts.jspeditor.vct.attrview.PropertyDataUtil;
import com.ibm.etools.struts.jspeditor.vct.attrview.data.AttributeData;
import com.ibm.etools.struts.jspeditor.vct.attrview.data.IAttributeData;
import com.ibm.etools.struts.jspeditor.vct.attrview.data.IStringData;
import com.ibm.etools.struts.jspeditor.vct.attrview.data.NodeListImpl;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextData
extends AttributeData
implements IStringData {
    private boolean enabled;

    public TextData(String attributeName) {
        super(attributeName);
    }

    private static NodeList getTextNodeList(Node node) {
        if (node == null) {
            return null;
        }
        class MyNodeList
        extends NodeListImpl {
            MyNodeList() {
            }

            @Override
            public void add(Node node) {
                super.add(node);
            }
        }
        MyNodeList textNodes = new MyNodeList();
        NodeList children = node.getChildNodes();
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 3) {
                    textNodes.add(child);
                }
                ++i;
            }
        }
        return textNodes.getLength() > 0 ? textNodes : null;
    }

    public static String getTextValue(Node node) {
        return TextData.getTextValue(TextData.getTextNodeList(node));
    }

    private static String getTextValue(NodeList nodeList) {
        String value = null;
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeValue;
                Node node = nodeList.item(i);
                if (node.getNodeType() == 3 && (nodeValue = PropertyDataUtil.getTextValue(node)) != null) {
                    if (value == null) {
                        value = new String(nodeValue);
                    } else {
                        value.concat(nodeValue);
                    }
                }
                ++i;
            }
        }
        return value;
    }

    private static boolean hasEditableTextNodes(Node node) {
        NodeList children;
        if (node != null && (children = node.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() != 3) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public boolean compare(IAttributeData data) {
        if (data instanceof IStringData) {
            return PropertyDataUtil.compare(this, (IStringData)data);
        }
        return false;
    }

    @Override
    public String getString() {
        return this.getValue();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void reset() {
        super.reset();
        this.enabled = true;
    }

    public void setString(String string) {
        this.specified = true;
        this.value = string;
    }

    public void setValue(IStringData data) {
        if (data.isSpecified()) {
            this.setString(data.getString());
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    @Override
    public void setValue(String value) {
        this.setString(value);
    }

    @Override
    public void update(NodeList nodeList) {
        this.nodeList = nodeList;
        this.reset();
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (!TextData.hasEditableTextNodes(node)) {
                    this.setValue((String)null);
                    this.enabled = false;
                    break;
                }
                NodeList textNodes = TextData.getTextNodeList(node);
                if (i == 0) {
                    if (textNodes != null) {
                        this.setValue(TextData.getTextValue(textNodes));
                    } else {
                        this.reset();
                    }
                } else {
                    if (textNodes != null) {
                        if (!this.isSpecified() || !StringUtil.compare((String)this.getValue(), (String)TextData.getTextValue(textNodes))) {
                            this.setAmbiguous(true);
                        }
                    } else if (this.isSpecified()) {
                        this.setAmbiguous(true);
                    }
                    if (!this.isAmbiguous()) break;
                }
                ++i;
            }
        }
    }
}

