/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.attrview.data;

import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.struts.jspeditor.vct.attrview.PropertyDataUtil;
import com.ibm.etools.struts.jspeditor.vct.attrview.SelectionTable;
import com.ibm.etools.struts.jspeditor.vct.attrview.data.AttributeData;
import com.ibm.etools.struts.jspeditor.vct.attrview.data.IAttributeData;
import com.ibm.etools.struts.jspeditor.vct.attrview.data.ISelectionData;
import org.w3c.dom.Attr;
import org.w3c.dom.NodeList;

public class SelectionData
extends AttributeData
implements ISelectionData {
    private String[] initialValues = null;
    private String[] initialTitles = null;
    private SelectionTable table = null;
    private int selection = -1;
    private boolean valueIgnoreCase = true;

    public SelectionData(String attributeName, String[] values, String[] titles) {
        this(attributeName, values, titles, true);
    }

    public SelectionData(String attributeName, String[] values, String[] titles, boolean valueIgnoreCase) {
        super(attributeName);
        this.valueIgnoreCase = valueIgnoreCase;
        this.setInitialValues(values, titles);
        this.resetTable();
    }

    public void addTableItem(String value, String title) {
        this.table.addItem(value, title);
    }

    @Override
    public boolean compare(IAttributeData data) {
        if (data instanceof ISelectionData) {
            return PropertyDataUtil.compare(this, (ISelectionData)data);
        }
        return false;
    }

    private int findSelectionIndex(String value) {
        return this.table.getItemIndexByValue(value);
    }

    @Override
    public int getSelectionIndex() {
        return this.selection;
    }

    public SelectionTable getSelectionTable() {
        return this.table;
    }

    public String[] getTitles() {
        return this.table.getTitles();
    }

    public String[] getValues() {
        return this.table.getValues();
    }

    @Override
    public void reset() {
        super.reset();
        this.resetTable();
        this.selection = -1;
    }

    protected void resetTable() {
        if (this.table != null) {
            this.table.reset();
        } else {
            this.table = new SelectionTable(this.valueIgnoreCase);
        }
        if (this.initialValues != null) {
            this.table.setItems(this.initialValues, this.initialTitles);
        }
    }

    public void select(int index) {
        super.setValue(this.table.getValue(index));
        this.selection = index;
    }

    public void setInitialValues(String[] values, String[] titles) {
        this.initialValues = values;
        this.initialTitles = titles;
    }

    public void setSelectionIndex(int index) {
        this.select(index);
    }

    private void setValue(Attr attr) {
        if (attr != null) {
            this.setValue(PropertyDataUtil.getAttributeValue(attr));
        } else {
            this.reset();
        }
    }

    public void setValue(ISelectionData data) {
        if (data.isSpecified() && data.getValue() != null) {
            this.setValue(data.getValue());
            this.setAmbiguous(data.isAmbiguous());
        } else {
            this.reset();
        }
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        int index = this.findSelectionIndex(value);
        if (index != -1) {
            this.selection = index;
        } else {
            this.addTableItem(value, value);
            this.selection = this.findSelectionIndex(value);
        }
    }

    @Override
    public void update(NodeList nodeList) {
        this.nodeList = nodeList;
        this.reset();
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                Attr attr = this.getAttributeNode(nodeList.item(i));
                if (i == 0) {
                    this.setValue(attr);
                } else {
                    if (attr != null) {
                        this.setAmbiguous(!this.specified || !StringUtil.compareIgnoreCase((String)this.getValue(), (String)PropertyDataUtil.getAttributeValue(attr)));
                    } else {
                        this.setAmbiguous(this.specified);
                    }
                    if (this.isAmbiguous()) break;
                }
                ++i;
            }
        }
    }
}

