/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.attrview;

import com.ibm.etools.struts.jspeditor.vct.AttributeValue;
import com.ibm.etools.struts.jspeditor.vct.IInsertElement;
import com.ibm.etools.struts.jspeditor.vct.SupportedAttributes;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Element;

public class TagValue
implements IInsertElement {
    private String name = null;
    private String string = null;
    private Vector attributes = null;
    private Vector children = null;
    private boolean jspTag = false;
    private Element element = null;

    public TagValue(String name, String string, Vector attributes) {
        this(name, string, attributes, null, null, TagValue.isJSPTag(name));
    }

    public TagValue(String name, String string, Vector attributes, Element element) {
        this(name, string, attributes, null, element, TagValue.isJSPTag(name));
    }

    public TagValue(String name, String string, Vector attributes, Vector children) {
        this(name, string, attributes, children, null, TagValue.isJSPTag(name));
    }

    public TagValue(String name, String string, Vector attributes, Vector children, boolean jspTag) {
        this(name, string, attributes, children, null, jspTag);
    }

    public TagValue(String name, String string, Vector attributes, Vector children, Element element) {
        this(name, string, attributes, children, element, TagValue.isJSPTag(name));
    }

    public TagValue(String name, String string, Vector attributes, Vector children, Element element, boolean jspTag) {
        this.name = name;
        this.setString(string);
        this.setAttributes(attributes);
        this.setChildren(children);
        this.setElement(element);
        this.setJSPTag(jspTag);
    }

    public static TagValue createTagValue(IInsertElement ie) {
        if (ie == null) {
            return null;
        }
        String name = ie.getName();
        if (name == null) {
            return null;
        }
        Vector<AttributeValue> attributes = new Vector<AttributeValue>();
        String[] attrs = SupportedAttributes.getAttributes(name);
        if (attrs != null) {
            int i = 0;
            while (i < attrs.length) {
                String value = ie.getAttribute(attrs[i]);
                attributes.add(new AttributeValue(attrs[i], value, false));
                ++i;
            }
        }
        Vector<TagValue> children = new Vector<TagValue>();
        Iterator childList = ie.getChildList();
        if (childList != null) {
            while (childList.hasNext()) {
                IInsertElement childIe = (IInsertElement)childList.next();
                TagValue childTv = TagValue.createTagValue(childIe);
                if (childTv == null) continue;
                children.add(childTv);
            }
        }
        return new TagValue(name, ie.getString(), attributes.size() > 0 ? attributes : null, children.size() > 0 ? children : null, ie.getData() instanceof Element ? (Element)ie.getData() : null, TagValue.isJSPTag(name));
    }

    public static boolean isJSPTag(String name) {
        if (name != null) {
            if (name.indexOf("jsp:directive") != -1) {
                return true;
            }
            if (name.equalsIgnoreCase("jsp:declaration") || name.equalsIgnoreCase("jsp:expression") || name.equalsIgnoreCase("jsp:scriptlet")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getAttribute(String attr) {
        if (this.attributes != null) {
            int i = 0;
            while (i < this.attributes.size()) {
                AttributeValue av = (AttributeValue)this.attributes.get(i);
                if (av.getAttribute().equalsIgnoreCase(attr)) {
                    return av.getValue();
                }
                ++i;
            }
        }
        return null;
    }

    public Vector getAttributes() {
        return this.attributes;
    }

    @Override
    public Iterator getChildList() {
        return this.children != null ? this.children.iterator() : null;
    }

    public Vector getChildren() {
        return this.children;
    }

    @Override
    public Object getData() {
        return this.getElement();
    }

    public Element getElement() {
        return this.element;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getString() {
        return this.string;
    }

    public boolean isJSPTag() {
        return this.jspTag;
    }

    public void setAttributes(Vector attributes) {
        this.attributes = attributes;
    }

    public void setChildren(Vector children) {
        this.children = children;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setJSPTag(boolean jspTag) {
        this.jspTag = jspTag;
    }

    public void setString(String string) {
        this.string = string;
    }
}

