/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct.attrview;

import com.ibm.etools.attrview.utils.StringUtil;
import com.ibm.etools.struts.jspeditor.vct.attrview.PropertyDataUtil;
import java.util.Iterator;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMNode;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMProperty;
import org.eclipse.wst.css.core.internal.metamodel.CSSMMUnit;
import org.eclipse.wst.css.core.internal.metamodel.CSSMetaModel;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMetaModelFinder;
import org.eclipse.wst.css.core.internal.metamodel.util.CSSMetaModelUtil;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AttributeValidatorUtil {
    private static CSSMetaModel findMetaModelFor(Node node) {
        String baseLocation = null;
        if (node instanceof IDOMNode) {
            IDOMModel model = ((IDOMNode)node).getModel();
            baseLocation = model.getBaseLocation();
        }
        return AttributeValidatorUtil.findMetaModelFor(baseLocation);
    }

    private static CSSMetaModel findMetaModelFor(String baseLocation) {
        CSSMetaModelFinder finder = CSSMetaModelFinder.getInstance();
        return finder.findMetaModelFor(baseLocation);
    }

    public static CMAttributeDeclaration getCMAttributeDeclaration(Document document, String tagName, String attrName) {
        CMElementDeclaration edecl = AttributeValidatorUtil.getCMElementDeclaration(document, tagName);
        if (edecl == null) {
            return null;
        }
        CMNamedNodeMap amap = edecl.getAttributes();
        if (amap == null) {
            return null;
        }
        return (CMAttributeDeclaration)amap.getNamedItem(attrName);
    }

    public static CMElementDeclaration getCMElementDeclaration(Document document, String tagName) {
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)document);
        if (modelQuery == null) {
            return null;
        }
        CMDocument cmdoc = modelQuery.getCorrespondingCMDocument((Node)document);
        if (cmdoc == null) {
            return null;
        }
        CMNamedNodeMap map = cmdoc.getElements();
        if (map == null) {
            return null;
        }
        return (CMElementDeclaration)map.getNamedItem(tagName);
    }

    public static CSSMMProperty getCSSMMProperty(Document document, String property) {
        CSSMetaModel metaModel = AttributeValidatorUtil.findMetaModelFor(document);
        if (metaModel != null) {
            return new CSSMetaModelUtil(metaModel).getProperty(property);
        }
        return null;
    }

    public static String[] getEnumeratedValues(Document document, String tagName, String attrName) {
        CMAttributeDeclaration adecl = AttributeValidatorUtil.getCMAttributeDeclaration(document, tagName, attrName);
        if (adecl == null) {
            return null;
        }
        CMDataType atype = adecl.getAttrType();
        if (atype == null) {
            return null;
        }
        return atype.getEnumeratedValues();
    }

    public static boolean isKnownAttribute(Document document, String tagName, String attrName) {
        return AttributeValidatorUtil.getCMAttributeDeclaration(document, tagName, attrName) != null;
    }

    public static boolean isKnownElement(Document document, String tagName) {
        return AttributeValidatorUtil.getCMElementDeclaration(document, tagName) != null;
    }

    public static boolean isValidCSSLength(Document document, String name, String value) {
        if (value == null) {
            return true;
        }
        CSSMMProperty prop = AttributeValidatorUtil.getCSSMMProperty(document, name);
        if (prop == null) {
            return true;
        }
        String integer = PropertyDataUtil.parseIntegerString(value);
        String suffix = PropertyDataUtil.parseSuffixString(value);
        Iterator i = prop.getValues();
        while (i.hasNext()) {
            CSSMMNode val = (CSSMMNode)i.next();
            String valueType = val.getType();
            if (valueType == "CSSMM.Keyword") {
                if (!StringUtil.compareIgnoreCase((String)val.toString(), (String)value)) continue;
                return true;
            }
            if (valueType != "CSSMM.Number" || integer == null) continue;
            Iterator j = val.getDescendants();
            while (j.hasNext()) {
                CSSMMUnit unit = (CSSMMUnit)j.next();
                if (!StringUtil.compareIgnoreCase((String)unit.toString(), (String)suffix)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidInteger(String value) {
        return AttributeValidatorUtil.isValidPixels(value);
    }

    public static boolean isValidLength(String value) {
        String suffix;
        if (value == null) {
            return true;
        }
        String integer = PropertyDataUtil.parseIntegerString(value);
        return integer != null && ((suffix = PropertyDataUtil.parseSuffixString(value)) == null || suffix.equals("%"));
    }

    public static boolean isValidMultiLength(String value) {
        String suffix;
        if (value == null) {
            return true;
        }
        String integer = PropertyDataUtil.parseIntegerString(value);
        return integer != null && ((suffix = PropertyDataUtil.parseSuffixString(value)) == null || suffix.equals("*") || suffix.equals("%"));
    }

    public static boolean isValidPixels(String value) {
        String suffix;
        if (value == null) {
            return true;
        }
        String integer = PropertyDataUtil.parseIntegerString(value);
        return integer != null && (suffix = PropertyDataUtil.parseSuffixString(value)) == null;
    }

    public static boolean validateAttributeValue(Document document, String tagName, String attrName, String value) {
        if (value == null) {
            return true;
        }
        CMAttributeDeclaration adecl = AttributeValidatorUtil.getCMAttributeDeclaration(document, tagName, attrName);
        if (adecl == null) {
            return true;
        }
        CMDataType atype = adecl.getAttrType();
        if (atype == null) {
            return true;
        }
        String[] values = atype.getEnumeratedValues();
        if (values == null) {
            return true;
        }
        int i = 0;
        while (i < values.length) {
            if (value.equalsIgnoreCase(values[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

