/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct;

import java.net.MalformedURLException;
import java.net.URL;

public class URLUtil {
    private static final String SCHEME_FORWARD = "";
    private static final String SCHEME_ACTION = "";
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_PAGE = "page";
    private static final String NETPATH = "//";
    public static int TYPE_FORWARD = 0;
    public static int TYPE_ACTION = 1;
    public static int TYPE_HTTP = 2;
    public static int TYPE_PAGE = 3;

    public static String decodeAmp(String strSubject) {
        StringBuffer s = new StringBuffer();
        char[] c = strSubject.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (i + 2 < c.length && c[i] == '%' && c[i + 1] == '2' && c[i + 2] == '6') {
                s.append("&");
                i += 3;
                continue;
            }
            s.append(c[i]);
            ++i;
        }
        return s.toString();
    }

    public static String encodeAmp(String strSubject) {
        StringBuffer s = new StringBuffer();
        char[] c = strSubject.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (c[i] == '&') {
                s.append("%26");
            } else {
                s.append(c[i]);
            }
            ++i;
        }
        return s.toString();
    }

    public static String getDefaultURL(int type) {
        if (type == TYPE_FORWARD) {
            return "";
        }
        if (type == TYPE_ACTION) {
            return "";
        }
        if (type == TYPE_HTTP) {
            return "http://";
        }
        if (type == TYPE_PAGE) {
            return "page://";
        }
        return "";
    }

    public static String getSchemeString(String url) {
        int index;
        int type = URLUtil.getSchemeType(url);
        if (type == TYPE_FORWARD) {
            return URLUtil.hasScheme(url) ? "" : null;
        }
        if (type == TYPE_ACTION) {
            return "";
        }
        if (type == TYPE_HTTP) {
            return SCHEME_HTTP;
        }
        if (url != null && (index = url.indexOf(58)) != -1) {
            return url.substring(0, index);
        }
        return null;
    }

    public static int getSchemeType(String url) {
        try {
            URL u = new URL(url);
            String s = u.getProtocol();
            if (s != null && s.length() != 0) {
                if (s.equals("")) {
                    return TYPE_FORWARD;
                }
                if (s.equals("")) {
                    return TYPE_ACTION;
                }
                if (s.equals(SCHEME_HTTP)) {
                    return TYPE_HTTP;
                }
                if (s.equals(SCHEME_PAGE)) {
                    return TYPE_PAGE;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return TYPE_PAGE;
    }

    public static boolean hasScheme(String url) {
        return url != null && url.indexOf(58) != -1;
    }

    public static String removeFragment(String url) {
        int index;
        if (url != null && (index = url.indexOf(35)) != -1) {
            url = url.substring(0, index);
        }
        return url;
    }

    public static String removeScheme(String url) {
        String s = URLUtil.getSchemeString(url);
        if (s != null && (url = url.substring(s.length() + 1)).startsWith(NETPATH)) {
            url = url.substring(NETPATH.length());
        }
        return url;
    }

    public static String replaceScheme(String url, int type) {
        if (type != URLUtil.getSchemeType(url)) {
            return String.valueOf(URLUtil.getDefaultURL(type)) + URLUtil.removeScheme(url);
        }
        return url;
    }
}

