/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.references.management.ILink;
import com.ibm.etools.references.management.ReferenceException;
import com.ibm.etools.references.web.AbstractWebProvider;
import com.ibm.etools.references.web.struts.internal.StrutsSearchUtil;
import com.ibm.etools.struts.Images;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.jspeditor.vct.ErrorOpenResourceBundleException;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.preference.StrutsPreferences;
import com.ibm.etools.struts.util.StrutsUtil;
import com.ibm.etools.webedit.vct.Context;
import com.ibm.etools.webedit.vct.CustomTagVisualizer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class StrutsVisualizerUtil {
    public static final String P_TAG = "<P/>";
    public static final String LINK_NAME = "linkName";
    public static final String ANCHOR = "anchor";
    public static final String FORWARD = "forward";
    public static final String PAGE = "page";
    public static final String HREF = "href";
    public static final String KEY = "key";
    public static final String SRCKEY = "srcKey";
    public static final String PAGEKEY = "pageKey";
    public static final String PROPERTY = "property";
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String STYLECLASS = "styleClass";
    public static final String TEMPLATE = "template";
    public static final String ACTION = "action";
    public static final String CANCEL = ResourceHandler.StrutsVCT_button_cancel;
    public static final String CLICK = ResourceHandler.StrutsVCT_button_click;
    public static final String RESET = ResourceHandler.StrutsVCT_button_reset;
    public static final String GET = "get";
    public static final String CONTENT = "content";
    public static final String PROPERTIES_FILE_EXTENSION = ".properties";
    public static final String PAGE_SCOPE_VARIABLES = "PAGE_VARIABLES";
    public static final String BEANWRITENODES = "BEANWRITENODES";
    public static final String COOKIES = "COOKIES";
    public static final String HEADERS = "HEADERS";
    public static final String INSERTTAG = "InsertTag";
    public static final String BEAN_WRITE = "bean:write";
    public static final String NESTED_WRITE = "nested:write";
    public static final String LOGIC_ITERATE = "logic:iterate";
    public static final String NESTED_ITERATE = "nested:iterate";
    public static final String NESTED_WRITENESTING = "nested:writeNesting";
    public static final String ITERATEKEY = "ITERATE";
    public static final String NESTED_LIST_KEY = "NESTED_LIST";
    public static final String UNKNOWN_BEAN_NAME = "<???>";
    public static boolean checkboxTagInitialState = true;
    public static final String ERRORCOLOR = "red";
    public static final String HTML_MSGS_HEADER = "header";
    public static final String HTML_MSGS_FOOTER = "footer";
    public static final String FRAME_NAME = "frameName";
    private static final String[] prefixes = new String[]{"StrutsHtml", "StrutsBean", "StrutsLogic", "StrutsTemplate"};
    private static String errorImagePath = null;
    private static String jspImagePath = null;
    private static final String WRITETAG = "write";
    public static final String MESSAGETAG = "message";
    private static final String ITERATETAG = "iterate";
    private static final boolean IGNORE_RESOURCE_OPEN_ERROR_FOR_RESOURCE_OPEN = true;

    public static void appendChildren(Element parent, NodeList children) {
        if (parent == null || children == null) {
            return;
        }
        Vector<Node> childs = new Vector<Node>();
        int i = 0;
        while (i < children.getLength()) {
            childs.add(children.item(i));
            ++i;
        }
        i = 0;
        while (i < childs.size()) {
            parent.appendChild((Node)childs.get(i));
            ++i;
        }
    }

    public static void closeJarFile(ZipFile file) {
        if (file == null) {
            return;
        }
        try {
            file.close();
        }
        catch (IOException ioe) {
            StrutsPlugin.getLogger().log((Throwable)ioe);
        }
    }

    public static boolean compareNodeNameToTag(Node node, String tagName) {
        String nodeName = node.getNodeName();
        int index = nodeName.indexOf(":" + tagName);
        return index >= 0 && nodeName.substring(index).equalsIgnoreCase(":" + tagName);
    }

    public static boolean compareNodes(Object object1, Object object2) {
        boolean same = false;
        if (object1 instanceof Node && object2 instanceof Node) {
            Element node1 = (Element)object1;
            Element node2 = (Element)object2;
            if (node1.getNodeName().equals(node2.getNodeName())) {
                NamedNodeMap node1Attributes = node1.getAttributes();
                NamedNodeMap node2Attributes = node2.getAttributes();
                if (node1Attributes.getLength() == node2Attributes.getLength()) {
                    same = true;
                    int i = 0;
                    while (i < node1Attributes.getLength() && same) {
                        Node attribute1 = node1Attributes.item(i);
                        Node attribute2 = node2Attributes.getNamedItem(attribute1.getNodeName());
                        if (attribute2 != null) {
                            if (!attribute1.getNodeValue().equals(attribute2.getNodeValue())) {
                                same = false;
                            }
                        } else {
                            same = false;
                        }
                        ++i;
                    }
                }
            }
        }
        return same;
    }

    public static void copyAttributes(Element from, Element to) {
        NamedNodeMap attributes = from.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attr = attributes.item(i);
            to.setAttribute(attr.getNodeName(), attr.getNodeValue());
            ++i;
        }
    }

    public static Element createElementB(Context context) {
        Element element = context.getDocument().createElement("B");
        context.putVisual((Node)element);
        return element;
    }

    public static Element createElementBR(Context context) {
        Element element = context.getDocument().createElement("BR");
        context.putVisual((Node)element);
        return element;
    }

    public static Element createElementI(Context context) {
        Element element = context.getDocument().createElement("I");
        context.putVisual((Node)element);
        return element;
    }

    public static void createElementLI(Document doc, Element parent, String textStr) {
        Element li = doc.createElement("LI");
        Text text = doc.createTextNode(textStr);
        li.appendChild(text);
        parent.appendChild(li);
    }

    public static Element createElementP(Context context) {
        Element element = context.getDocument().createElement("P");
        context.putVisual((Node)element);
        return element;
    }

    public static Element createHiddenTagIcon(Context context, String iconName) {
        Document doc = context.getDocument();
        context.getMyPath();
        Element element = doc.createElement("IMG");
        String iconPathStr = "icons/palette/small16/" + iconName + ".gif";
        try {
            URL iconGif = FileLocator.find((Bundle)StrutsPlugin.getDefault().getBundle(), (IPath)new Path(iconPathStr), null);
            iconGif = FileLocator.toFileURL((URL)iconGif);
            Path tmp = new Path(iconGif.toString());
            iconGif = new URL("file", null, "/" + tmp.makeUNC(true).toString());
            element.setAttribute("src", tmp.toString());
            element.setAttribute("border", "0");
            return element;
        }
        catch (IOException iOException) {
            StrutsPlugin.getLogger().log("unable to build installdir url");
            return null;
        }
    }

    public static Text createTextNode(Context context, String textStr) {
        Text text = context.getDocument().createTextNode(textStr);
        context.putVisual((Node)text);
        return text;
    }

    public static void displayErrorMessage(Context context, String message, CustomTagVisualizer visualizer) {
        Document doc = context.getDocument();
        Element p = StrutsVisualizerUtil.createElementP(context);
        Element img = null;
        img = doc.createElement("IMG");
        img.setAttribute("src", StrutsVisualizerUtil.getErrorImagePath());
        p.appendChild(img);
        Element font = doc.createElement("FONT");
        font.setAttribute("color", ERRORCOLOR);
        font.setAttribute("size", "3");
        Text tagText = doc.createTextNode(String.valueOf(StrutsVisualizerUtil.getStrutsTagShortName(visualizer)) + " - ");
        font.appendChild(tagText);
        Text text = doc.createTextNode(message);
        font.appendChild(text);
        p.appendChild(font);
        context.putVisual((Node)p);
    }

    public static void displayErrorMessageString(Context context, String message, CustomTagVisualizer visualizer) {
        String errorMsg = "<IMG src='" + StrutsVisualizerUtil.getErrorImagePath() + "'/>" + "<font color='" + ERRORCOLOR + "'>" + StrutsVisualizerUtil.getStrutsTagShortName(visualizer) + " - " + message + "</font>";
        context.putVisual(errorMsg);
    }

    public static ArrayList getActionErrors() {
        return StrutsVisualizerUtil.getCollectionOfLines(StrutsVisualizerUtil.getPreferences().getErrorsMessages());
    }

    public static String getActionErrorsString() {
        return StrutsVisualizerUtil.getPreferences().getErrorsMessages();
    }

    public static ArrayList getActionMessages() {
        return StrutsVisualizerUtil.getCollectionOfLines(StrutsVisualizerUtil.getPreferences().getMessagesMessages());
    }

    public static String getActionMessagesString() {
        return StrutsVisualizerUtil.getPreferences().getMessagesMessages();
    }

    public static String getAttributeValue(Node node, String name) {
        String value = "";
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeName().equalsIgnoreCase(name)) {
                value = attribute.getNodeValue();
                break;
            }
            ++i;
        }
        return value;
    }

    public static String getBeanNameFromActionName(Context context, String actionName) {
        try {
            ILink formBeanLink;
            ILink actionLink = StrutsSearchUtil.getActionMappingLink((IProject)StrutsVisualizerUtil.getComponent(context).getProject(), (String)actionName, (String)"", null);
            if (actionLink != null && (formBeanLink = StrutsSearchUtil.getFormBeanLinkForAction((ILink)actionLink)) != null) {
                return AbstractWebProvider.trimQuotes((String)formBeanLink.getLinkText());
            }
        }
        catch (ReferenceException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean getBeanWriteNameDisplay() {
        return StrutsVisualizerUtil.getPreferences().getBeanWriteNameDisplay();
    }

    public static boolean getBeanWritePropertyDisplay() {
        return StrutsVisualizerUtil.getPreferences().getBeanWritePropertyDisplay();
    }

    private static InputStream getBundleFromFolderPath(IPath path, String bundlePathName) throws ErrorOpenResourceBundleException {
        if (path == null) {
            return null;
        }
        IPath filePath = path.append(bundlePathName);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
        if (file.isAccessible()) {
            try {
                return new BufferedInputStream(file.getContents());
            }
            catch (CoreException e) {
                StrutsPlugin.getLogger().log((Throwable)e);
                throw new ErrorOpenResourceBundleException(NLS.bind((String)ResourceHandler.StrutsVCT_common_error_open_properties_file_message, (Object)bundlePathName));
            }
        }
        return null;
    }

    private static InputStream getBundleFromJarPath(IPath jarFilePath, String bundlePathName) throws ErrorOpenResourceBundleException {
        ByteArrayInputStream inputStream;
        block21: {
            if (jarFilePath == null || jarFilePath.isEmpty() || bundlePathName == null || bundlePathName.length() < 1) {
                return null;
            }
            File testFile = new File(jarFilePath.toString());
            if (!testFile.exists()) {
                return null;
            }
            inputStream = null;
            ZipFile jarfile = null;
            try {
                jarfile = new ZipFile(jarFilePath.toString());
            }
            catch (IOException ioExc) {
                StrutsPlugin.getLogger().log((Throwable)ioExc);
                StrutsVisualizerUtil.closeJarFile(jarfile);
            }
            if (jarfile == null) {
                return null;
            }
            try {
                ZipEntry zentry = jarfile.getEntry(bundlePathName);
                InputStream entryInputStream = null;
                if (zentry == null) break block21;
                try {
                    entryInputStream = jarfile.getInputStream(zentry);
                }
                catch (IOException ioExc) {
                    StrutsPlugin.getLogger().log((Throwable)ioExc);
                }
                if (entryInputStream == null) break block21;
                ByteArrayOutputStream buffer = null;
                buffer = zentry.getSize() > 0L ? new ByteArrayOutputStream((int)zentry.getSize()) : new ByteArrayOutputStream();
                byte[] bytes = new byte[2048];
                try {
                    try {
                        int c;
                        while ((c = entryInputStream.read(bytes)) >= 0) {
                            buffer.write(bytes, 0, c);
                        }
                        inputStream = new ByteArrayInputStream(buffer.toByteArray());
                        StrutsVisualizerUtil.closeJarFile(jarfile);
                    }
                    catch (IOException iOException) {
                        try {
                            entryInputStream.close();
                        }
                        catch (IOException iOException2) {}
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        entryInputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    entryInputStream.close();
                }
                catch (IOException iOException) {}
            }
            finally {
                StrutsVisualizerUtil.closeJarFile(jarfile);
            }
        }
        return inputStream;
    }

    private static InputStream getBundleInputStream(IJavaProject javaProject, String bundlePathName) throws ErrorOpenResourceBundleException {
        InputStream inputStream = null;
        try {
            IPath path = javaProject.getOutputLocation();
            inputStream = StrutsVisualizerUtil.getBundleFromFolderPath(path, bundlePathName);
        }
        catch (JavaModelException e) {
            StrutsPlugin.getLogger().log((Throwable)e);
            return null;
        }
        if (inputStream != null) {
            return inputStream;
        }
        IClasspathEntry[] entries = null;
        try {
            entries = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException jme) {
            StrutsPlugin.getLogger().log((Throwable)jme);
            return null;
        }
        int i = 0;
        while (inputStream == null && i < entries.length) {
            IClasspathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 1: {
                    IPath path = entry.getPath();
                    inputStream = StrutsVisualizerUtil.getBundleFromJarPath(path, bundlePathName);
                    break;
                }
                case 3: {
                    IPath path = entry.getPath();
                    inputStream = StrutsVisualizerUtil.getBundleFromFolderPath(path, bundlePathName);
                }
            }
            ++i;
        }
        return inputStream;
    }

    private static String getBundlePathName(String bundleName) {
        int indexOfDot = bundleName.lastIndexOf(46);
        if (indexOfDot > -1) {
            String newBundleName = bundleName.replace('.', '/');
            return String.valueOf(newBundleName) + PROPERTIES_FILE_EXTENSION;
        }
        return String.valueOf(bundleName) + PROPERTIES_FILE_EXTENSION;
    }

    public static boolean getCheckboxTagInitialState() {
        return checkboxTagInitialState;
    }

    public static ArrayList getCollectionOfLines(String linesStr) {
        ArrayList<String> lines = new ArrayList<String>();
        String tempStr = linesStr;
        int index = 0;
        boolean done = false;
        while (!done && (index = tempStr.indexOf("\r\n")) > -1) {
            if (index > 0) {
                lines.add(tempStr.substring(0, index));
            }
            if (index + 2 <= tempStr.length()) {
                tempStr = tempStr.substring(index + 2);
                continue;
            }
            done = true;
        }
        if (!done && tempStr.length() > 0) {
            lines.add(tempStr);
        }
        return lines;
    }

    public static IVirtualComponent getComponent(Context context) {
        String fileStr = "file:///";
        String realPathStr = context.getRealPath("");
        if (realPathStr.substring(0, fileStr.length()).equalsIgnoreCase(fileStr)) {
            realPathStr = realPathStr.substring(fileStr.length(), realPathStr.length());
        }
        IPath path = new Path(realPathStr).removeTrailingSeparator();
        return StrutsVisualizerUtil.getComponentForIPath(path);
    }

    private static IVirtualComponent getComponentForIPath(IPath fullLocalIPath) {
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        IContainer container = workspace.getContainerForLocation(fullLocalIPath);
        return Model2Util.findComponent((IResource)container);
    }

    private static String[] getDefaultResourceBundleName(Context context) {
        IFile file = StrutsVisualizerUtil.getFile(context.getMyPath());
        IVirtualComponent component = StrutsVisualizerUtil.getComponent(context);
        String module = StrutsSearchUtil.getModuleForIFile((IFile)file, null);
        return StrutsUtil.getStrutsApplicationResourcesNames(component, module);
    }

    public static String getErrorImagePath() {
        if (errorImagePath == null) {
            errorImagePath = Images.getErrorImagePath();
        }
        return errorImagePath;
    }

    public static boolean getErrorsDisplay() {
        return StrutsVisualizerUtil.getPreferences().getErrorsDisplay();
    }

    public static IFile getFile(String pathString) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        IPath rootPath = workspaceRoot.getLocation();
        if (pathString.startsWith("file:///")) {
            pathString = pathString.substring("file:///".length());
        }
        Path path = new Path(pathString);
        path = path.removeFirstSegments(rootPath.segmentCount());
        return workspaceRoot.getFile((IPath)path);
    }

    public static String getGlobalForwardPath(Context context, String forwardName, CustomTagVisualizer visualizer) {
        IVirtualComponent component = StrutsVisualizerUtil.getComponent(context);
        Set links = StrutsSearchUtil.getGlobalForwards((IProject)component.getProject(), (String)"", null);
        for (ILink link : links) {
            if (forwardName == null || !forwardName.equals(link.getName())) continue;
            return AbstractWebProvider.trimQuotes((String)link.getLinkText());
        }
        return null;
    }

    public static String getImageSrc(Context context, Element element, CustomTagVisualizer visualizer) throws ErrorOpenResourceBundleException {
        String src = null;
        String srcKey = element.getAttribute(SRCKEY);
        if (srcKey != null) {
            src = StrutsVisualizerUtil.getString(context, srcKey, visualizer);
        }
        String page = element.getAttribute(PAGE);
        if (page != null) {
            src = context.getRealPath(page);
        } else {
            String pageKey = element.getAttribute(PAGEKEY);
            if (pageKey != null) {
                page = StrutsVisualizerUtil.getString(context, pageKey, visualizer);
                src = context.getRealPath(page);
            }
        }
        return src;
    }

    public static String getJspImagePath() {
        if (jspImagePath == null) {
            jspImagePath = Images.getJSPImagePath();
        }
        return jspImagePath;
    }

    private static String getKey(Node currentNode) {
        String key = new String();
        NamedNodeMap nnm = currentNode.getAttributes();
        key = key.concat(currentNode.getNodeName());
        int i = 0;
        while (i < nnm.getLength()) {
            key = key.concat(nnm.item(i).getNodeName());
            key = key.concat(nnm.item(i).getNodeValue());
            ++i;
        }
        return key;
    }

    private static String getKey(Node currentNode, String preferenceKey) {
        String key = new String();
        NamedNodeMap nnm = currentNode.getAttributes();
        key = key.concat(currentNode.getNodeName());
        int i = 0;
        while (i < nnm.getLength()) {
            key = key.concat(nnm.item(i).getNodeName());
            key = key.concat(nnm.item(i).getNodeValue());
            ++i;
        }
        return key.concat(preferenceKey);
    }

    public static boolean getMessagesDisplay() {
        return StrutsVisualizerUtil.getPreferences().getMessagesDisplay();
    }

    public static ArrayList getOptions() {
        return StrutsVisualizerUtil.getCollectionOfLines(StrutsVisualizerUtil.getPreferences().getOptions());
    }

    public static Object getPageScopeVariable(Context context, String varName) {
        HashMap pageVars = (HashMap)context.getAttribute(PAGE_SCOPE_VARIABLES);
        if (pageVars == null) {
            return null;
        }
        return pageVars.get(varName);
    }

    public static Object getPageScopeVariable(Context context, String varName, Object value) {
        HashMap pageVars = StrutsVisualizerUtil.getPageScopeVariables(context, true);
        Object returnObj = pageVars.get(varName);
        if (returnObj == null) {
            StrutsVisualizerUtil.storePageScopeVariable(context, varName, value);
            returnObj = value;
        }
        return returnObj;
    }

    public static HashMap getPageScopeVariables(Context context, boolean createFlag) {
        HashMap pageVars = (HashMap)context.getAttribute(PAGE_SCOPE_VARIABLES);
        if (pageVars == null && createFlag) {
            pageVars = new HashMap();
            context.setAttribute(PAGE_SCOPE_VARIABLES, pageVars);
        }
        return pageVars;
    }

    public static StrutsPreferences getPreferences() {
        return StrutsPlugin.getDefault().getStrutsPreferences();
    }

    private static PropertyResourceBundle getResourceBundle(Context context, CustomTagVisualizer visualizer, String bundleName) throws ErrorOpenResourceBundleException {
        String bundlePathName;
        if (bundleName == null) {
            throw new ErrorOpenResourceBundleException(NLS.bind((String)ResourceHandler.StrutsVCT_common_error_open_properties_file_message, (Object)(" - " + ResourceHandler.strutsModuleWizard_error_noBundleName)));
        }
        IVirtualComponent component = StrutsVisualizerUtil.getComponent(context);
        IJavaProject javaProject = JavaCore.create((IProject)component.getProject());
        InputStream inputStream = StrutsVisualizerUtil.getBundleInputStream(javaProject, bundlePathName = StrutsVisualizerUtil.getBundlePathName(bundleName));
        if (inputStream != null) {
            PropertyResourceBundle bundle = null;
            try {
                bundle = new PropertyResourceBundle(inputStream);
            }
            catch (IOException iOException) {}
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bundle == null) {
                throw new ErrorOpenResourceBundleException(ResourceHandler.StrutsVCT_common_error_open_properties_file_message);
            }
            return bundle;
        }
        return null;
    }

    public static HashSet getResourceBundleKeys(Context context, CustomTagVisualizer visualizer) throws ErrorOpenResourceBundleException {
        String[] bundleNames = StrutsVisualizerUtil.getResourceBundleNames(context);
        if (bundleNames == null || bundleNames.length == 0) {
            throw new ErrorOpenResourceBundleException(NLS.bind((String)ResourceHandler.StrutsVCT_common_error_open_properties_file_message, (Object)(" - " + ResourceHandler.strutsModuleWizard_error_noBundleName)));
        }
        HashSet<String> keySet = new HashSet<String>();
        PropertyResourceBundle bundle = null;
        int i = 0;
        while (i < bundleNames.length) {
            try {
                bundle = StrutsVisualizerUtil.getResourceBundle(context, visualizer, bundleNames[i]);
                if (bundle != null) {
                    Enumeration<String> keys = bundle.getKeys();
                    while (keys.hasMoreElements()) {
                        keySet.add(keys.nextElement());
                    }
                }
            }
            catch (ErrorOpenResourceBundleException errorOpenResourceBundleException) {}
            ++i;
        }
        return keySet;
    }

    private static String[] getResourceBundleNames(Context context) {
        return StrutsVisualizerUtil.getDefaultResourceBundleName(context);
    }

    public static String getResourcePreference(String pathString, Node currentNode) throws CoreException {
        IFile file = StrutsVisualizerUtil.getFile(pathString);
        QualifiedName qualifiedName = new QualifiedName("com.ibm.etools.struts.jspeditor", StrutsVisualizerUtil.getKey(currentNode));
        if (file.exists()) {
            return file.getPersistentProperty(qualifiedName);
        }
        return null;
    }

    public static String getResourcePreference(String pathString, Node currentNode, String preferenceKey) throws CoreException {
        IFile file = StrutsVisualizerUtil.getFile(pathString);
        QualifiedName qualifiedName = new QualifiedName("com.ibm.etools.struts.jspeditor", StrutsVisualizerUtil.getKey(currentNode, preferenceKey));
        if (file.exists()) {
            return file.getPersistentProperty(qualifiedName);
        }
        return null;
    }

    public static String getString(Context context, String key, CustomTagVisualizer visualizer) throws ErrorOpenResourceBundleException {
        return StrutsVisualizerUtil.getString(context, key, Locale.getDefault(), visualizer);
    }

    public static String getString(Context context, String key, Locale locale, CustomTagVisualizer visualizer) throws ErrorOpenResourceBundleException {
        String[] bundleNames = StrutsVisualizerUtil.getResourceBundleNames(context);
        if (bundleNames == null || bundleNames.length == 0) {
            throw new ErrorOpenResourceBundleException(NLS.bind((String)ResourceHandler.StrutsVCT_common_error_open_properties_file_message, (Object)(" - " + ResourceHandler.strutsModuleWizard_error_noBundleName)));
        }
        int i = 0;
        while (i < bundleNames.length) {
            PropertyResourceBundle bundle = null;
            try {
                bundle = StrutsVisualizerUtil.getResourceBundle(context, visualizer, bundleNames[i]);
            }
            catch (ErrorOpenResourceBundleException errorOpenResourceBundleException) {}
            if (bundle != null) {
                try {
                    String message = bundle.getString(key);
                    if (message != null) {
                        return message;
                    }
                }
                catch (MissingResourceException missingResourceException) {}
            }
            ++i;
        }
        return null;
    }

    public static ArrayList getStringsFromKeys(Context context, ArrayList keys, CustomTagVisualizer visualizer) throws ErrorOpenResourceBundleException {
        String[] bundleNames = StrutsVisualizerUtil.getResourceBundleNames(context);
        if (bundleNames == null || bundleNames.length == 0) {
            throw new ErrorOpenResourceBundleException(NLS.bind((String)ResourceHandler.StrutsVCT_common_error_open_properties_file_message, (Object)(" - " + ResourceHandler.strutsModuleWizard_error_noBundleName)));
        }
        int currentOpenedBundle = -1;
        PropertyResourceBundle[] bundles = new PropertyResourceBundle[bundleNames.length];
        ArrayList<String> strings = new ArrayList<String>();
        for (String key : keys) {
            String keyString = null;
            int i = 0;
            while (i < bundles.length) {
                PropertyResourceBundle currentBundle;
                block14: {
                    if (currentOpenedBundle < i) {
                        try {
                            try {
                                bundles[i] = StrutsVisualizerUtil.getResourceBundle(context, visualizer, bundleNames[i]);
                            }
                            catch (ErrorOpenResourceBundleException errorOpenResourceBundleException) {
                                bundles[i] = null;
                                currentOpenedBundle = i;
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            currentOpenedBundle = i;
                            throw throwable;
                        }
                        currentOpenedBundle = i;
                    }
                }
                if ((currentBundle = bundles[i]) != null) {
                    try {
                        keyString = currentBundle.getString(key);
                        if (keyString != null) {
                            break;
                        }
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
                ++i;
            }
            if (keyString == null) {
                keyString = "<li><font color=red>" + NLS.bind((String)ResourceHandler.StrutsVCT_messagetag_error_missing_message, (Object)key) + "</font></li>";
            }
            strings.add(keyString);
        }
        bundles = null;
        return strings;
    }

    public static String getStrutsTagName(CustomTagVisualizer visualizer) {
        return "Struts " + StrutsVisualizerUtil.getStrutsTagShortName(visualizer) + " Tag";
    }

    public static String getStrutsTagShortName(CustomTagVisualizer visualizer) {
        String tempStr = visualizer.getClass().getName();
        int index = tempStr.lastIndexOf(46);
        tempStr = tempStr.substring(index + 1);
        String prefix = null;
        int count = 0;
        while (count < prefixes.length) {
            prefix = prefixes[count];
            if (tempStr.startsWith(prefix)) {
                tempStr = tempStr.substring(prefix.length());
                index = tempStr.indexOf("TagVisualizer");
                return tempStr.substring(0, index).toLowerCase();
            }
            ++count;
        }
        return null;
    }

    public static int getStrutsVersion(Context context) {
        IVirtualComponent component = StrutsVisualizerUtil.getComponent(context);
        if (component != null) {
            return StrutsProjectCoreUtil.getStrutsVersion((IProject)component.getProject());
        }
        return -1;
    }

    public static boolean isBeanMessageNode(Node node) {
        return StrutsVisualizerUtil.compareNodeNameToTag(node, MESSAGETAG);
    }

    public static boolean isBeanWriteNode(Node node) {
        String nodeName = node.getNodeName();
        int index = nodeName.indexOf(":write");
        return index >= 0 && nodeName.substring(index).equalsIgnoreCase(":write");
    }

    public static boolean isLogicIterateNode(Node node) {
        return StrutsVisualizerUtil.compareNodeNameToTag(node, ITERATETAG);
    }

    public static void setResourcePreference(String pathString, Node currentNode, String preferenceString) throws CoreException {
        IFile file = StrutsVisualizerUtil.getFile(pathString);
        QualifiedName qualifiedName = new QualifiedName("com.ibm.etools.struts.jspeditor", StrutsVisualizerUtil.getKey(currentNode));
        file.setPersistentProperty(qualifiedName, preferenceString);
    }

    public static void setResourcePreference(String pathString, Node currentNode, String key, String preferenceString) throws CoreException {
        IFile file = StrutsVisualizerUtil.getFile(pathString);
        QualifiedName qualifiedName = new QualifiedName("com.ibm.etools.struts.jspeditor", StrutsVisualizerUtil.getKey(currentNode, key));
        file.setPersistentProperty(qualifiedName, preferenceString);
    }

    public static Vector splitString(String string, String regex) {
        Vector<String> subStrings = new Vector<String>();
        char dot = ".".charAt(0);
        int i = 0;
        while (i < string.length()) {
            int index = string.indexOf(dot, i);
            if (index > -1) {
                subStrings.add(string.substring(i, index));
                i = index + 1;
                continue;
            }
            subStrings.add(string.substring(i));
            i = string.length();
        }
        return subStrings;
    }

    public static void storePageScopeVariable(Context context, String varName) {
        StrutsVisualizerUtil.storePageScopeVariable(context, varName, null);
    }

    public static void storePageScopeVariable(Context context, String varName, Object object) {
        HashMap pageVars = StrutsVisualizerUtil.getPageScopeVariables(context, true);
        pageVars.put(varName, object);
    }
}

