/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.vct;

import com.ibm.etools.webedit.utils.DocumentUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class ComboDataType {
    public static final int TYPE_INT = 1;
    public static final int TYPE_STRING = 2;
    public static final int NOT_FOUND_INT = -1;
    public static final String NOT_FOUND_STRING = null;
    private List keyOrder;
    private Hashtable dataTable;
    protected int type = 2;
    protected DocumentUtil docUtil = null;

    protected ComboDataType() {
        this.initData();
    }

    protected ComboDataType(DocumentUtil docUtil) {
        this.docUtil = docUtil;
        this.initData();
    }

    protected ComboDataType(int type) {
        this.type = type;
        this.initData();
    }

    public static String createDisplayString(String text) {
        if (text == null || text.length() < 1) {
            return text;
        }
        char[] p = text.toCharArray();
        char[] q = new char[p.length];
        int i = 0;
        while (i < p.length) {
            q[i] = !Character.isWhitespace(p[i]) ? p[i] : 32;
            ++i;
        }
        return new String(q);
    }

    protected void add(Object key, Object value) {
        if (!this.keyOrder.contains(key)) {
            this.keyOrder.add(key);
        }
        this.dataTable.put(key, value);
    }

    protected void add(String value) {
        String displayString = ComboDataType.createDisplayString(value);
        if (displayString == null) {
            displayString = "";
        }
        this.add(displayString, value);
    }

    public String getDisplayString(String target) {
        if (this.type != 2) {
            return NOT_FOUND_STRING;
        }
        Enumeration e = this.dataTable.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)this.dataTable.get(key);
            if (!value.equals(target)) continue;
            return key;
        }
        return NOT_FOUND_STRING;
    }

    public List getDisplayStringList() {
        return Collections.unmodifiableList(this.keyOrder);
    }

    public int getValueInt(String displayString) {
        if (this.type != 1) {
            return -1;
        }
        if (this.dataTable.containsKey(displayString)) {
            return (Integer)this.dataTable.get(displayString);
        }
        return -1;
    }

    public String getValueString(String displayString) {
        if (this.type != 2) {
            return NOT_FOUND_STRING;
        }
        if (this.dataTable.containsKey(displayString)) {
            return (String)this.dataTable.get(displayString);
        }
        return NOT_FOUND_STRING;
    }

    protected void initData() {
        this.initTable(-1);
    }

    protected void initTable(int size) {
        if (this.dataTable != null) {
            this.dataTable.clear();
        }
        Hashtable hashtable = this.dataTable = size > 0 ? new Hashtable(size) : new Hashtable();
        if (this.keyOrder != null) {
            this.keyOrder.clear();
        }
        this.keyOrder = size > 0 ? new ArrayList(size) : new ArrayList();
    }
}

