/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.jspeditor.attrview.parts;

import com.ibm.etools.attrview.AVWidgetFactory;
import com.ibm.etools.attrview.sdk.AVData;
import com.ibm.etools.attrview.sdk.AVPart;
import com.ibm.etools.attrview.sdk.AVStringComponent;
import com.ibm.etools.attrview.sdk.AVTextConverter;
import com.ibm.etools.attrview.utils.WidgetUtil;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StrutsTextPart
extends AVPart
implements AVStringComponent,
VerifyListener {
    static final int KC_ENTER = 13;
    private Text text;
    private AVTextConverter converter;

    public StrutsTextPart(AVData data, Composite parent, String title, AVTextConverter converter) {
        super(data, parent, title);
        this.converter = converter;
        this.createContents();
    }

    protected void createContents() {
        if (this.getTitle() != null) {
            this.initializeContainer(1);
            this.createLabel();
        } else {
            this.initializeContainer(1);
        }
        this.text = WidgetUtil.createTextArea((AVWidgetFactory)this.getWidgetFactory(), (Composite)this.getContainer(), (int)3);
        this.text.addFocusListener((FocusListener)this);
        this.text.addKeyListener((KeyListener)this);
        this.text.addModifyListener((ModifyListener)this);
        this.text.addMouseListener((MouseListener)this);
        this.text.addVerifyListener((VerifyListener)this);
        this.setControls(new Control[]{this.text});
    }

    public void dispose() {
        super.dispose();
        StrutsTextPart.dispose((Widget)this.text);
        this.text = null;
    }

    public Control getFocusControl() {
        if (this.text.isFocusControl()) {
            return this.text;
        }
        return super.getFocusControl();
    }

    public String getString() {
        String string = this.text.getText();
        if (string != null && string.length() > 0) {
            return string;
        }
        return null;
    }

    public Text getTextControl() {
        return this.text;
    }

    public String getValue() {
        return this.getString();
    }

    public boolean isSpecified() {
        return this.getString() != null;
    }

    public void keyPressed(KeyEvent e) {
        if (e.character == '\r' && (e.stateMask & 0x20000) != 0) {
            super.keyPressed(e);
        }
    }

    public void reset() {
        super.reset();
        this.text.setText("");
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    public void setValue(String string) {
        if (string != null && this.converter != null) {
            string = this.converter.convertLineDelimiters(string, null);
        }
        this.text.setText(string != null ? string : "");
    }

    protected void update() {
        AVData data = this.getDataComponent();
        if (data != null && data.isValueSpecified()) {
            this.setValue(data.getValue());
            this.setAmbiguous(data.isAmbiguous());
            this.setEnabled(data.isEditable());
        } else {
            this.reset();
        }
    }

    public void verifyText(VerifyEvent e) {
        if (e.character == '\r' && (e.stateMask & 0x20000) != 0) {
            e.doit = false;
        }
    }
}

