/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.internal.util;

import com.ibm.etools.j2ee.web.WebSettings;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.core.facet.StrutsVersionMediator;
import com.ibm.etools.struts.core.util.StrutsProjectCoreUtil;
import com.ibm.etools.struts.facet.StrutsFacetInstallDataModelProvider;
import com.ibm.etools.struts.nls.ResourceHandler;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public final class StrutsProjectUtil
extends StrutsProjectCoreUtil {
    private static final String SPF168_FACET_ID = "jsr.struts";
    private static final String IBMPORTLET_FACET_ID = "ibmportlet.struts";

    public static void addBuilder(IProject project, String builderId) {
        try {
            ICommand command;
            Object[] commands;
            IProjectDescription description = project.getDescription();
            Object[] objectArray = commands = description.getBuildSpec();
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                command = objectArray[n2];
                if (builderId.equals(command.getBuilderName())) {
                    return;
                }
                ++n2;
            }
            command = description.newCommand();
            command.setBuilderName(builderId);
            commands = (ICommand[])StrutsProjectUtil.copyWith(commands, command);
            description.setBuildSpec((ICommand[])commands);
            project.setDescription(description, null);
        }
        catch (Exception exception) {
            StrutsPlugin.getLogger().log((Throwable)exception);
        }
    }

    public static void addFeature(IProject project, String featureId) {
        try {
            String[] loadedFeatures;
            WebSettings webSettings = new WebSettings(project);
            String[] stringArray = loadedFeatures = webSettings.getFeatureIds();
            int n = loadedFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                String loadedFeature = stringArray[n2];
                if (featureId.equals(loadedFeature)) {
                    return;
                }
                ++n2;
            }
            webSettings.setFeatureIds(new String[]{featureId});
            webSettings.write();
        }
        catch (Exception exception) {
            StrutsPlugin.getLogger().log((Throwable)exception);
        }
    }

    public static void addNature(IProject project, String natureId) {
        try {
            Object[] ids;
            IProjectDescription description = project.getDescription();
            Object[] objectArray = ids = description.getNatureIds();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                Object id = objectArray[n2];
                if (natureId.equals(id)) {
                    return;
                }
                ++n2;
            }
            ids = (String[])StrutsProjectUtil.copyWith(ids, natureId);
            description.setNatureIds((String[])ids);
            project.setDescription(description, null);
        }
        catch (Exception exception) {
            StrutsPlugin.getLogger().log((Throwable)exception);
        }
    }

    public static final IStatus checkStrutsFacet(IProject project, boolean deepProbe, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            int version = StrutsProjectUtil.probeStrutsVersion(project, (IProgressMonitor)sub.newChild(1));
            if (version != -1 && !StrutsProjectUtil.isStrutsPortlet(project, deepProbe, (IProgressMonitor)sub.newChild(1))) {
                IStatus iStatus = StrutsProjectUtil.installStrutsFacet(project, version, (IProgressMonitor)sub.newChild(1));
                return iStatus;
            }
            StrutsProjectUtil.removeNature(project, "com.ibm.etools.struts.StrutsNature");
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static Object[] copyWith(Object[] objects, Object object) {
        Object[] result = (Object[])Array.newInstance(object.getClass(), objects.length + 1);
        System.arraycopy(objects, 0, result, 0, objects.length);
        result[objects.length] = object;
        return result;
    }

    private static Object[] copyWithout(Object[] objects, int index) {
        Object[] result = (Object[])Array.newInstance(objects[index].getClass(), objects.length - 1);
        System.arraycopy(objects, 0, result, 0, index);
        System.arraycopy(objects, index + 1, result, index, result.length - index);
        return result;
    }

    public static void enabledStrutsCapabilities() {
        try {
            IWorkbenchActivitySupport support = PlatformUI.getWorkbench().getActivitySupport();
            final ITriggerPoint point = support.getTriggerPointManager().getTriggerPoint("org.eclipse.ui.ide.natures");
            if (point != null) {
                UIJob job = new UIJob(ResourceHandler.StrutsFacetInstallDelegate_EnableStrutsCapability){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        WorkbenchActivityHelper.allowUseOf((ITriggerPoint)point, (Object)new IPluginContribution(){

                            public String getLocalId() {
                                return StrutsPlugin.getPluginId();
                            }

                            public String getPluginId() {
                                return StrutsPlugin.getPluginId();
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
        catch (Exception exception) {}
    }

    public static final IProject getFirstStrutsProject() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (StrutsProjectUtil.isStruts((IProject)project)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public static final int getStrutsVersionFromActionClass(IProject project) {
        return StrutsProjectUtil.probeStrutsVersion(project, null);
    }

    private static IType getType(IProject project, String fullyQualifedName, IProgressMonitor monitor) {
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp == null) {
            return null;
        }
        String nonQualified = Signature.getSimpleName((String)fullyQualifedName);
        String packName = Signature.getQualifier((String)fullyQualifedName);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{jp}, (int)15);
        StrutsTypeNameMatchRequestor typeNameReq = new StrutsTypeNameMatchRequestor();
        try {
            new SearchEngine().searchAllTypeNames(packName.toCharArray(), 0, nonQualified.toCharArray(), 0, 0, scope, (TypeNameMatchRequestor)typeNameReq, 3, monitor);
        }
        catch (CoreException coreException) {
            return null;
        }
        return typeNameReq.getMatches().isEmpty() ? null : typeNameReq.getMatches().get(0);
    }

    private static boolean hasType(IProject project, String fullyQualifedName, IProgressMonitor monitor) {
        IJavaProject jp = JavaCore.create((IProject)project);
        if (jp == null) {
            return false;
        }
        String nonQualified = Signature.getSimpleName((String)fullyQualifedName);
        String packName = Signature.getQualifier((String)fullyQualifedName);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{jp}, (int)15);
        StrutsTypeNameRequestor typeNameReq = new StrutsTypeNameRequestor();
        try {
            new SearchEngine().searchAllTypeNames(packName.toCharArray(), 0, nonQualified.toCharArray(), 0, 0, scope, (TypeNameRequestor)typeNameReq, 3, monitor);
        }
        catch (CoreException coreException) {
            return false;
        }
        return !typeNameReq.getMatches().isEmpty();
    }

    private static final IStatus installStrutsFacet(IProject project, int version, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        sub.subTask(ResourceHandler.StrutsProjectUtil_0);
        try {
            try {
                IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)"web.struts");
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)sub.newChild(1));
                String versionString = StrutsVersionMediator.getStrutsVersion((int)version);
                if (versionString != null) {
                    IProjectFacetVersion projectFacetVersion = projectFacet.getVersion(versionString);
                    StrutsFacetInstallDataModelProvider provider = new StrutsFacetInstallDataModelProvider();
                    IDataModel model = (IDataModel)provider.create();
                    model.setBooleanProperty("IStrutsFacetDataModelProperties.PSEUDO_INSTALL", true);
                    facetedProject.installProjectFacet(projectFacetVersion, (Object)model, (IProgressMonitor)sub.newChild(1));
                }
            }
            catch (IllegalArgumentException exception) {
                Status status = new Status(4, StrutsPlugin.getPluginId(), exception.getLocalizedMessage(), (Throwable)exception);
                if (monitor != null) {
                    monitor.done();
                }
                return status;
            }
            catch (CoreException exception) {
                IStatus iStatus;
                block11: {
                    iStatus = exception.getStatus();
                    if (monitor == null) break block11;
                    monitor.done();
                }
                return iStatus;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    /*
     * Exception decompiling
     */
    public static final boolean isStrutsPortlet(IProject project, boolean deepProbe, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final int probeStrutsVersion(IProject project, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            if (project == null || !project.exists()) {
                return -1;
            }
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject == null || !javaProject.exists()) {
                return -1;
            }
            sub.subTask(ResourceHandler.StrutsProjectUtil_3);
            boolean hasAction = StrutsProjectUtil.hasType(project, "org.apache.struts.action.Action", (IProgressMonitor)sub.newChild(1));
            if (!hasAction) {
                return -1;
            }
            sub.subTask(ResourceHandler.StrutsProjectUtil_4);
            boolean hasGlobals = StrutsProjectUtil.hasType(project, "org.apache.struts.Globals", (IProgressMonitor)sub.newChild(1));
            if (!hasGlobals) {
                return 0;
            }
            sub.subTask(ResourceHandler.StrutsProjectUtil_5);
            IType actionType = StrutsProjectUtil.getType(project, "org.apache.struts.action.Action", (IProgressMonitor)sub.newChild(1));
            IMethod saveErrorsMethod1 = actionType.getMethod("saveErrors", new String[]{"Ljavax.servlet.http.HttpServletRequest;", "Lorg.apache.struts.action.ActionMessages;"});
            if (saveErrorsMethod1 == null || !saveErrorsMethod1.exists()) {
                return 1;
            }
            sub.subTask(ResourceHandler.StrutsProjectUtil_6);
            IMethod saveErrorsMethod2 = actionType.getMethod("saveErrors", new String[]{"Ljavax.servlet.http.HttpServletRequest;", "Lorg.apache.struts.action.ActionErrors;"});
            if (saveErrorsMethod2 != null && saveErrorsMethod2.exists()) {
                return 2;
            }
            sub.subTask(ResourceHandler.StrutsProjectUtil_7);
            return 3;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static void removeBuilder(IProject project, String builderId) {
        try {
            IProjectDescription description = project.getDescription();
            Object[] commands = description.getBuildSpec();
            int i = 0;
            while (i < commands.length) {
                if (builderId.equals(commands[i].getBuilderName())) {
                    commands = (ICommand[])StrutsProjectUtil.copyWithout(commands, i);
                    description.setBuildSpec((ICommand[])commands);
                    project.setDescription(description, null);
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            StrutsPlugin.getLogger().log((Throwable)exception);
        }
    }

    public static void removeFeature(IProject project, String featureId) {
        try {
            WebSettings webSettings = new WebSettings(project);
            webSettings.removeFeatureId(featureId);
            webSettings.write();
        }
        catch (Exception exception) {
            StrutsPlugin.getLogger().log((Throwable)exception);
        }
    }

    public static void removeNature(IProject project, String natureId) {
        try {
            IProjectDescription description = project.getDescription();
            Object[] ids = description.getNatureIds();
            int i = 0;
            while (i < ids.length) {
                if (ids[i].equals(natureId)) {
                    ids = (String[])StrutsProjectUtil.copyWithout(ids, i);
                    description.setNatureIds((String[])ids);
                    project.setDescription(description, null);
                    break;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            StrutsPlugin.getLogger().log((Throwable)exception);
        }
    }

    public static class StrutsTypeNameMatchRequestor
    extends TypeNameMatchRequestor {
        private final List<IType> matches = new ArrayList<IType>();

        public void acceptTypeNameMatch(TypeNameMatch match) {
            this.matches.add(match.getType());
        }

        public List<IType> getMatches() {
            return this.matches;
        }
    }

    public static class StrutsTypeNameRequestor
    extends TypeNameRequestor {
        private final List<String> matches = new ArrayList<String>();

        public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            String name = new String(packageName);
            name = String.valueOf(name) + "." + new String(simpleTypeName);
            this.matches.add(name);
        }

        public List<String> getMatches() {
            return this.matches;
        }
    }
}

