/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.facet;

import com.ibm.etools.model2.base.facet.ProjectFacetUtil;
import com.ibm.etools.struts.facet.ResultsDialog;
import com.ibm.etools.struts.facet.StrutsFacetDelegate;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.runtimes.Runtimes;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class StrutsFacetVersionChangeDelegate
extends StrutsFacetDelegate {
    private IProjectFacetVersion oldVersion;
    private List<String> log;

    private void checkDigest(IFile file) throws CoreException {
        try {
            byte[] actual = this.getDigest(file);
            byte[] expected = Runtimes.getDefault().getDigest(true, this.oldVersion.getVersionString(), file.getName());
            if (!Arrays.equals(expected, actual) && !Arrays.equals(expected = Runtimes.getDefault().getDigest(false, this.oldVersion.getVersionString(), file.getName()), actual)) {
                this.log.add(NLS.bind((String)ResourceHandler.FilesDiffer, (Object)file.getProjectRelativePath(), (Object)this.oldVersion.getVersionString()));
            }
        }
        catch (IOException exception) {
            this.error(exception);
        }
        catch (GeneralSecurityException exception) {
            this.error(exception);
        }
    }

    @Override
    protected boolean copyFile(IFile targetFile) {
        boolean ok = super.copyFile(targetFile);
        if (ok) {
            this.log.add(NLS.bind((String)ResourceHandler.StrutsFacetVersionChangeDelegate_Added, (Object)this.version.getVersionString(), (Object)targetFile.getProjectRelativePath()));
        }
        return ok;
    }

    @Override
    protected void createUpdateWebEditModelCommands(List<Command> commands, WebArtifactEdit webEditModel) {
    }

    @Override
    protected void delete(IFile file) throws CoreException {
        try {
            super.delete(file);
            this.log.add(NLS.bind((String)ResourceHandler.StrutsFacetVersionChangeDelegate_Removed, (Object)this.oldVersion.getVersionString(), (Object)file.getProjectRelativePath()));
        }
        catch (CoreException coreException) {
            this.log.add(NLS.bind((String)ResourceHandler.StrutsFacetVersionChangeDelegate_Not_Removed, (Object)this.oldVersion.getVersionString(), (Object)file.getProjectRelativePath()));
        }
    }

    protected void deleteOldJarFiles() throws CoreException {
        String[] files = this.getJarFiles(this.getOldVersionInt(), true);
        int i = 0;
        while (i < files.length) {
            List<IFile> found = this.find((IContainer)this.project, files[i]);
            for (IFile file : found) {
                this.checkDigest(file);
                this.delete(file);
            }
            ++i;
        }
    }

    protected boolean deleteOldTLDFiles() throws CoreException {
        boolean existed = false;
        String[] files = this.getTLDFiles(this.getOldVersionInt(), true);
        int i = 0;
        while (i < files.length) {
            List<IFile> found = this.find((IContainer)this.project, files[i]);
            for (IFile file : found) {
                this.checkDigest(file);
                this.delete(file);
            }
            ++i;
        }
        return existed;
    }

    @Override
    protected void dispose() {
        this.oldVersion = null;
        this.log = null;
        super.dispose();
    }

    @Override
    protected void execute() throws CoreException {
        this.checkInstallVersion();
        this.validateEdit();
        this.deleteOldJarFiles();
        boolean existed = this.deleteOldTLDFiles();
        this.copyJarFiles();
        if (existed) {
            this.copyTLDFiles();
        }
        this.showResults();
    }

    protected List<IFile> find(IContainer container, final String name) throws CoreException {
        final ArrayList<IFile> files = new ArrayList<IFile>();
        container.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getType() == 1) {
                    if (resource.getName().equals(name)) {
                        files.add((IFile)resource);
                    }
                    return false;
                }
                return true;
            }
        });
        return files;
    }

    private byte[] getDigest(IFile file) throws IOException, CoreException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("MD5");
        file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
        InputStream stream = file.getContents();
        DigestInputStream digestStream = new DigestInputStream(stream, digest);
        try {
            long n;
            byte[] buffer = new byte[8192];
            while ((n = (long)digestStream.read(buffer)) != -1L) {
            }
        }
        finally {
            stream.close();
        }
        return digest.digest();
    }

    protected int getOldVersionInt() {
        return this.getVersionInt(this.oldVersion.getVersionString());
    }

    @Override
    protected void initialize(IProject project, IProjectFacetVersion version, Object model, IProgressMonitor monitor) {
        super.initialize(project, version, model, monitor);
        this.oldVersion = ProjectFacetUtil.getInstalledFacetVersion((IProject)project, (String)"web.struts");
        this.log = new ArrayList<String>();
    }

    private void showResults() {
        final String projectName = this.project.getName();
        final String oldVersionString = this.oldVersion.getVersionString();
        final String newVersionString = this.version.getVersionString();
        final String[] messages = this.log.toArray(new String[this.log.size()]);
        Thread thread = new Thread(){

            @Override
            public void run() {
                final Display display = PlatformUI.getWorkbench().getDisplay();
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = display.getActiveShell();
                        ResultsDialog.openInformation(shell, projectName, oldVersionString, newVersionString, messages);
                    }
                });
            }
        };
        thread.start();
    }
}

