/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.facet;

import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.references.web.javaee.taglib.WebEEUtil;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.core.facet.IStrutsFacetConstants;
import com.ibm.etools.struts.core.facet.StrutsVersionMediator;
import com.ibm.etools.struts.nls.ResourceHandler;
import com.ibm.etools.struts.runtimes.Runtimes;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class StrutsFacetDelegate
implements IDelegate {
    protected IProject project;
    protected IProjectFacetVersion version;
    protected IDataModel model;
    protected IProgressMonitor monitor;
    protected IVirtualComponent component;
    private static final String WEB_INF = "WEB-INF";
    private static final String LIB = "WEB-INF/lib";

    protected void checkInstallVersion() throws CoreException {
        String versionString = this.version.getVersionString();
        int versionInt = StrutsVersionMediator.getStrutsVersionIntFor((String)versionString);
        if (versionInt != 2 && versionInt != 3) {
            this.error(ResourceHandler.facet_install_error_badVersion, versionString);
        }
    }

    protected boolean copyFile(IFile targetFile) {
        InputStream sourceStream = null;
        try {
            try {
                sourceStream = new BufferedInputStream(Runtimes.getDefault().openStream(this.version.getVersionString(), targetFile.getName()));
                try {
                    targetFile.create(sourceStream, true, this.monitor);
                }
                catch (CoreException exception) {
                    StrutsPlugin.getLogger().log((Throwable)exception);
                }
            }
            catch (Exception exception) {
                StrutsPlugin.getLogger().log((Throwable)exception);
                if (sourceStream != null) {
                    try {
                        sourceStream.close();
                    }
                    catch (IOException exception2) {
                        StrutsPlugin.getLogger().log((Throwable)exception2);
                    }
                }
                return false;
            }
        }
        finally {
            if (sourceStream != null) {
                try {
                    sourceStream.close();
                }
                catch (IOException exception) {
                    StrutsPlugin.getLogger().log((Throwable)exception);
                }
            }
        }
        return true;
    }

    protected void copyJarFiles() {
        String[] files = this.getJarFiles(this.getVersionInt(), false);
        int i = 0;
        while (i < files.length) {
            IFile targetFile = this.component.getRootFolder().getFolder(LIB).getFile(files[i]).getUnderlyingFile();
            if (targetFile.exists() || this.copyFile(targetFile)) {
                // empty if block
            }
            ++i;
        }
    }

    protected void copyTLDFiles() {
        String[] files = this.getTLDFiles(this.getVersionInt(), false);
        int i = 0;
        while (i < files.length) {
            IFile targetFile = this.component.getRootFolder().getFolder(WEB_INF).getFile(files[i]).getUnderlyingFile();
            if (targetFile.exists() || this.copyFile(targetFile)) {
                // empty if block
            }
            ++i;
        }
    }

    private Command createUpdateWebEditModelCommand(WebArtifactEdit webEditModel) {
        ArrayList<Command> commands = new ArrayList<Command>();
        this.createUpdateWebEditModelCommands(commands, webEditModel);
        switch (commands.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Command)commands.get(0);
            }
        }
        return new CompoundCommand(commands);
    }

    protected abstract void createUpdateWebEditModelCommands(List<Command> var1, WebArtifactEdit var2);

    protected void delete(IFile file) throws CoreException {
        file.delete(true, this.monitor);
    }

    protected void dispose() {
        if (this.monitor != null) {
            this.monitor.done();
        }
        this.project = null;
        this.version = null;
        this.model = null;
        this.monitor = null;
        this.component = null;
    }

    protected void error(String format, String ... inserts) throws CoreException {
        this.problem(4, null, format, inserts);
    }

    protected void error(Throwable throwable) throws CoreException {
        this.problem(4, throwable, null, new String[0]);
    }

    protected abstract void execute() throws CoreException;

    public final void execute(IProject project, IProjectFacetVersion version, Object model, IProgressMonitor monitor) throws CoreException {
        this.initialize(project, version, model, monitor);
        try {
            this.execute();
        }
        finally {
            this.dispose();
        }
    }

    protected CommandStack getCommandStack(WebArtifactEdit artifactEdit) {
        ArtifactEditModel artifactEditModel = (ArtifactEditModel)artifactEdit.getAdapter(ArtifactEditModel.ADAPTER_TYPE);
        return artifactEditModel.getCommandStack();
    }

    protected IFile getFile(IPath path) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(path);
    }

    protected String[] getJarFiles(int strutsVersion, boolean all) {
        if (all) {
            switch (strutsVersion) {
                case 0: {
                    return IStrutsFacetConstants.JAR_FILES_ALL_1_0_2;
                }
                case 1: {
                    return IStrutsFacetConstants.JAR_FILES_ALL_1_1;
                }
                case 2: {
                    return IStrutsFacetConstants.JAR_FILES_ALL_1_2;
                }
                case 3: {
                    return IStrutsFacetConstants.JAR_FILES_ALL_1_3;
                }
            }
        } else {
            switch (strutsVersion) {
                case 0: {
                    return IStrutsFacetConstants.JAR_FILES_1_0_2;
                }
                case 1: {
                    return IStrutsFacetConstants.JAR_FILES_1_1;
                }
                case 2: {
                    return IStrutsFacetConstants.JAR_FILES_1_2;
                }
                case 3: {
                    return IStrutsFacetConstants.JAR_FILES_1_3;
                }
            }
        }
        return new String[0];
    }

    protected String[] getTLDFiles(int strutsVersion, boolean all) {
        switch (strutsVersion) {
            case 0: {
                return IStrutsFacetConstants.TLD_FILES_1_0_2;
            }
            case 1: {
                return IStrutsFacetConstants.TLD_FILES_1_1;
            }
            case 2: {
                return IStrutsFacetConstants.TLD_FILES_1_2;
            }
            case 3: {
                return IStrutsFacetConstants.TLD_FILES_1_3;
            }
        }
        return new String[0];
    }

    protected int getVersionInt() {
        return this.getVersionInt(this.version.getVersionString());
    }

    protected int getVersionInt(String versionString) {
        return StrutsVersionMediator.getStrutsVersionIntFor((String)versionString);
    }

    protected void initialize(IProject project, IProjectFacetVersion version, Object model, IProgressMonitor monitor) {
        this.project = project;
        this.version = version;
        this.model = (IDataModel)model;
        this.monitor = monitor;
        this.component = Model2Util.findComponent((IResource)this.project);
        if (this.model != null) {
            this.model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)this.project.getName());
        }
        if (this.monitor != null) {
            this.monitor.beginTask("", 10);
        }
    }

    private void problem(int severity, Throwable throwable, String format, String ... inserts) throws CoreException {
        String message = null;
        if (format != null) {
            message = NLS.bind((String)format, (Object[])inserts);
        } else if (throwable != null) {
            message = throwable.getLocalizedMessage();
        }
        Status status = new Status(severity, StrutsPlugin.getPluginId(), message, throwable);
        throw new CoreException((IStatus)status);
    }

    protected final void updateWebXML() {
        WebArtifactEdit webEditModel = Model2Util.getWebArtifactEdit((IVirtualComponent)this.component, (boolean)false);
        if (webEditModel != null) {
            try {
                try {
                    Command command = this.createUpdateWebEditModelCommand(webEditModel);
                    if (command != null) {
                        this.getCommandStack(webEditModel).execute(command);
                    }
                    webEditModel.saveIfNecessary(this.monitor);
                }
                catch (Exception exception) {
                    StrutsPlugin.getLogger().log("Exception during update of web.xml", (Throwable)exception);
                    webEditModel.dispose();
                }
            }
            finally {
                webEditModel.dispose();
            }
        }
    }

    protected void validateEdit() throws CoreException {
        IFile file = this.getFile(WebEEUtil.getWebXmlPath((IProject)this.project));
        IStatus status = Model2Util.validateEdit((IFile)file, null);
        if (status.getSeverity() != 0) {
            throw new CoreException(status);
        }
    }

    protected void warning(String format, String ... inserts) throws CoreException {
        this.problem(2, null, format, inserts);
    }
}

