/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.configFile.id.contributions;

import com.ibm.etools.model2.base.facet.ConditionalFacetWeightedUtil;
import com.ibm.etools.model2.base.facet.IConditionalFacetWeighted;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.configFile.id.contributions.ConfigFileIdentifierContributionWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ConfigFileIdentifierContributionsManager {
    public static final String configFileIdentifierExtension = String.valueOf(StrutsPlugin.getPluginId()) + ".configFileIdentifier";
    public static final String configFileIdentifierClassAttribute = "class";
    public static final String configFileIdentifierIdAttribute = "id";
    public static final String ConditionAttribute = "condition";
    private static HashMap contributions = new HashMap();
    private static HashMap contributionWrappersById = new HashMap();
    private static ArrayList contributionWrappers = null;
    private static boolean cached = false;

    private static void buildContributionsList() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] conf = reg.getConfigurationElementsFor(configFileIdentifierExtension);
        int i = 0;
        while (i < conf.length) {
            IConfigurationElement currentConf = conf[i];
            String id = currentConf.getAttribute(configFileIdentifierIdAttribute);
            if (contributions.containsKey(id)) {
                StrutsPlugin.getLogger().log("This Config File Identifier contribution has the key of an already registered contribution --> " + currentConf);
            } else {
                contributions.put(id, currentConf);
            }
            ++i;
        }
    }

    private static void cache() {
        ConfigFileIdentifierContributionsManager.buildContributionsList();
        cached = true;
    }

    public static ArrayList getAllContributionWrappers() {
        contributionWrappers = new ArrayList();
        for (Map.Entry mapEntry : ConfigFileIdentifierContributionsManager.getContributions().entrySet()) {
            ConfigFileIdentifierContributionWrapper identifier = ConfigFileIdentifierContributionsManager.getContributionWrapper((String)mapEntry.getKey());
            if (identifier == null) continue;
            contributionWrappers.add(identifier);
        }
        return contributionWrappers;
    }

    public static HashMap getContributions() {
        if (!cached) {
            ConfigFileIdentifierContributionsManager.cache();
        }
        return contributions;
    }

    public static ConfigFileIdentifierContributionWrapper getContributionWrapper(String id) {
        if (!contributionWrappersById.containsKey(id)) {
            IConfigurationElement element = (IConfigurationElement)ConfigFileIdentifierContributionsManager.getContributions().get(id);
            if (element != null) {
                ConfigFileIdentifierContributionWrapper wrapper = new ConfigFileIdentifierContributionWrapper();
                if (wrapper != null) {
                    ConditionalFacetWeightedUtil.readFacetWeights((IConditionalFacetWeighted)wrapper, (IConfigurationElement)element);
                    wrapper.setConfigElement(element);
                    contributionWrappersById.put(id, wrapper);
                }
            } else {
                StrutsPlugin.getLogger().log("Request for ConfigFileIdentifierContributionWrapper instance failed due to invalid passed key ==> " + id);
            }
        }
        return (ConfigFileIdentifierContributionWrapper)contributionWrappersById.get(id);
    }
}

