/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.struts.config.file.identifiers;

import com.ibm.etools.model2.base.util.CommonDialogManager;
import com.ibm.etools.model2.base.util.Model2Util;
import com.ibm.etools.model2.base.util.WizardUtils;
import com.ibm.etools.struts.StrutsPlugin;
import com.ibm.etools.struts.configFile.id.contributions.IConfigFileIdentifier;
import com.ibm.etools.struts.configFile.id.contributions.Params;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.InitParam;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.ServletType;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class StrutsConfigFileIdentifier
implements IConfigFileIdentifier {
    private final String ACTION_SERVLET_CLASSNAME = "org.apache.struts.action.ActionServlet";
    private static final String MODULE_CONFIG_PREFIX = "config/";

    protected static ServletMapping getPreferredServletMappingFromList(List mappings) {
        if (mappings == null || mappings.size() == 0) {
            return null;
        }
        if (mappings.size() == 1) {
            return (ServletMapping)mappings.get(0);
        }
        for (ServletMapping mapping : mappings) {
            String pattern = mapping.getUrlPattern();
            if (pattern == null || !pattern.startsWith("*")) continue;
            return mapping;
        }
        return (ServletMapping)mappings.get(0);
    }

    private void addFilesFromConfigValueToSet(Object configValue, IVirtualComponent webComponent, HashSet result) {
        if (configValue instanceof String) {
            IFile file = Model2Util.fileFor((IVirtualComponent)webComponent, (String)((String)configValue));
            if (file != null) {
                result.add(file);
            }
        } else if (configValue instanceof List) {
            Iterator configsIter = ((List)configValue).iterator();
            while (configsIter.hasNext()) {
                IFile file = Model2Util.fileFor((IVirtualComponent)webComponent, (String)((String)configsIter.next()));
                if (file == null) continue;
                result.add(file);
            }
        }
    }

    @Override
    public boolean addInitParamForActionServlet(IVirtualComponent webComponent, String paramName, String paramValue) {
        IStatus status;
        IFile webXMLFile = this.getWebXMLFile(webComponent);
        if (webXMLFile != null && (status = Model2Util.validateEdit((IFile)webXMLFile, (Shell)CommonDialogManager.getShell())).getSeverity() == 0) {
            WebArtifactEdit webArtifactEdit = null;
            try {
                webArtifactEdit = WebArtifactEdit.getWebArtifactEditForWrite((IVirtualComponent)webComponent);
                if (webArtifactEdit != null) {
                    Command command = this.createAddInitParamCommand(webArtifactEdit, paramName, paramValue);
                    if (command != null) {
                        webArtifactEdit.getCommandStack().execute(command);
                        webArtifactEdit.saveIfNecessary(null);
                    }
                    return true;
                }
            }
            catch (Exception exception) {
                StrutsPlugin.getLogger().log("Exception during update of web.xml", (Throwable)exception);
            }
            finally {
                if (webArtifactEdit != null) {
                    webArtifactEdit.dispose();
                }
            }
        }
        return false;
    }

    private Command createAddInitParamCommand(WebArtifactEdit webArtifactEdit, String paramName, String paramValue) {
        Servlet servlet = this.getStrutsActionServlet(webArtifactEdit);
        if (servlet != null) {
            int j2eeVersion = servlet.getWebApp().getJ2EEVersionID();
            switch (j2eeVersion) {
                case 12: 
                case 13: {
                    return this.createOldAddInitParam(servlet, paramName, paramValue, webArtifactEdit.getCommandStack());
                }
            }
            return this.createNewAddInitParam(servlet, paramName, paramValue, webArtifactEdit.getCommandStack());
        }
        return null;
    }

    private Command createNewAddInitParam(Servlet servlet, String paramName, String paramValue, CommandStack commandStack) {
        EList initParams = servlet.getInitParams();
        for (ParamValue initParam : initParams) {
            if (!paramName.equals(initParam.getName())) continue;
            return null;
        }
        ParamValue initParam = CommonFactory.eINSTANCE.createParamValue();
        initParam.setName(paramName);
        initParam.setValue(paramValue);
        return AddCommand.create((EditingDomain)this.getEditingDomain(commandStack), (Object)servlet, (Object)WebapplicationPackage.eINSTANCE.getServlet_InitParams(), (Object)initParam);
    }

    private Command createOldAddInitParam(Servlet servlet, String paramName, String paramValue, CommandStack commandStack) {
        InitParam initParam2;
        EList initParams = servlet.getParams();
        for (InitParam initParam2 : initParams) {
            if (!paramName.equals(initParam2.getParamName())) continue;
            return null;
        }
        WebapplicationFactory factory = WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
        initParam2 = factory.createInitParam();
        initParam2.setParamName(paramName);
        initParam2.setParamValue(paramValue);
        return AddCommand.create((EditingDomain)this.getEditingDomain(commandStack), (Object)servlet, (Object)WebapplicationPackage.eINSTANCE.getServlet_Params(), (Object)initParam2);
    }

    @Override
    public List getAllActionServletUrlMappingFromServlet(IVirtualComponent webComponent) {
        Servlet actionServlet = (Servlet)this.getStrutsActionServlet(webComponent);
        ArrayList<String> list = new ArrayList<String>();
        if (actionServlet == null) {
            return list;
        }
        List mappings = actionServlet.getMappings();
        if (mappings != null && !mappings.isEmpty()) {
            for (ServletMapping mapping : mappings) {
                if (mapping == null || mapping.getUrlPattern() == null) continue;
                list.add(mapping.getUrlPattern());
            }
        }
        return list;
    }

    @Override
    public String[] getAllConfiguredStrutsModuleNamesForComponent(IVirtualComponent webComponent) {
        String[] result = null;
        WebArtifactEdit webArtifactEdit = Model2Util.getWebArtifactEdit((IVirtualComponent)webComponent, (boolean)true);
        if (webArtifactEdit != null) {
            try {
                Servlet servlet = this.getStrutsActionServlet(webArtifactEdit);
                if (servlet != null) {
                    List list = this.getAllStrutsConfigModulesFrom(servlet);
                    result = list.toArray(new String[list.size()]);
                }
            }
            finally {
                webArtifactEdit.dispose();
            }
        }
        return result;
    }

    @Override
    public IFile[] getAllStrutsConfigFilesForComponent(IVirtualComponent webComponent) {
        IFile[] result = null;
        WebArtifactEdit webArtifactEdit = Model2Util.getWebArtifactEdit((IVirtualComponent)webComponent, (boolean)true);
        if (webArtifactEdit != null) {
            try {
                Servlet servlet = this.getStrutsActionServlet(webArtifactEdit);
                if (servlet != null) {
                    result = this.getAllStrutsConfigFilesFrom(servlet, webComponent);
                }
            }
            finally {
                webArtifactEdit.dispose();
            }
        }
        return result;
    }

    private IFile[] getAllStrutsConfigFilesForModule(Servlet servlet, IVirtualComponent webComponent, String moduleName) {
        HashMap initParms = this.getStrutsConfigInitParams(servlet);
        Object initParmValue = initParms.get(moduleName);
        if (initParmValue != null) {
            HashSet result = new HashSet();
            this.addFilesFromConfigValueToSet(initParmValue, webComponent, result);
            return result.toArray(new IFile[result.size()]);
        }
        return new IFile[0];
    }

    private IFile[] getAllStrutsConfigFilesFrom(Servlet servlet, IVirtualComponent webComponent) {
        HashSet result = new HashSet();
        HashMap initParms = this.getStrutsConfigInitParams(servlet);
        Iterator configValueIter = initParms.values().iterator();
        while (configValueIter.hasNext()) {
            this.addFilesFromConfigValueToSet(configValueIter.next(), webComponent, result);
        }
        return result.toArray(new IFile[result.size()]);
    }

    private List getAllStrutsConfigModulesFrom(Servlet servlet) {
        ArrayList result = new ArrayList();
        HashMap initParms = this.getStrutsConfigInitParams(servlet);
        Iterator hashKey = initParms.keySet().iterator();
        while (hashKey.hasNext()) {
            result.add(hashKey.next());
        }
        return result;
    }

    private EditingDomain getEditingDomain(CommandStack commandStack) {
        return new AdapterFactoryEditingDomain(new AdapterFactory(){

            public Adapter adapt(Notifier target, Object type) {
                return null;
            }

            public Object adapt(Object object, Object type) {
                return null;
            }

            public void adaptAllNew(Notifier notifier) {
            }

            public Adapter adaptNew(Notifier target, Object type) {
                return null;
            }

            public boolean isFactoryForType(Object type) {
                return false;
            }
        }, commandStack);
    }

    @Override
    public Params getInitParams(final IVirtualComponent component) {
        return new Params(){
            private WebArtifactEdit webArtifactEdit;

            @Override
            protected List createObjects() {
                WebApp webApp;
                Servlet servlet;
                this.webArtifactEdit = Model2Util.getWebArtifactEdit((IVirtualComponent)component, (boolean)false);
                if (this.webArtifactEdit != null && (servlet = StrutsConfigFileIdentifier.this.getStrutsActionServlet(this.webArtifactEdit)) != null && (webApp = servlet.getWebApp()) != null) {
                    int j2eeVersion = servlet.getWebApp().getJ2EEVersionID();
                    switch (j2eeVersion) {
                        case 12: 
                        case 13: {
                            return servlet.getParams();
                        }
                    }
                    return servlet.getInitParams();
                }
                return Collections.EMPTY_LIST;
            }

            @Override
            protected Params.IParam createParam(EObject object) {
                if (object instanceof ParamValue) {
                    return new Params.IParam(object){
                        private ParamValue param;
                        {
                            this.param = (ParamValue)eObject;
                        }

                        @Override
                        public String getName() {
                            return this.param.getName();
                        }

                        @Override
                        public String getValue() {
                            return this.param.getValue();
                        }

                        @Override
                        public void setName(String name) {
                            this.param.setName(name);
                        }

                        @Override
                        public void setValue(String value) {
                            this.param.setValue(value);
                        }
                    };
                }
                if (object instanceof InitParam) {
                    return new Params.IParam(object){
                        private InitParam param;
                        {
                            this.param = (InitParam)eObject;
                        }

                        @Override
                        public String getName() {
                            return this.param.getParamName();
                        }

                        @Override
                        public String getValue() {
                            return this.param.getParamValue();
                        }

                        @Override
                        public void setName(String name) {
                            this.param.setParamName(name);
                        }

                        @Override
                        public void setValue(String value) {
                            this.param.setParamValue(value);
                        }
                    };
                }
                return null;
            }

            @Override
            public void dispose() {
                if (this.webArtifactEdit != null) {
                    this.webArtifactEdit.dispose();
                    this.webArtifactEdit = null;
                }
            }

            @Override
            public void save() {
                if (this.webArtifactEdit != null) {
                    this.webArtifactEdit.saveIfNecessary((IProgressMonitor)new NullProgressMonitor());
                }
            }
        };
    }

    @Override
    public HashMap getInitParamsForActionServlet(IVirtualComponent webComponent) {
        Object servlet = this.getStrutsActionServlet(webComponent);
        if (servlet == null) {
            return null;
        }
        return Model2Util.getServletInitParams((Servlet)((Servlet)servlet));
    }

    @Override
    public String getInitParamValueForActionServlet(IVirtualComponent webComponent, String paramName) {
        Object servlet = this.getStrutsActionServlet(webComponent);
        if (servlet == null) {
            return null;
        }
        return Model2Util.getInitParam((Servlet)((Servlet)servlet), (String)paramName);
    }

    @Override
    public String getPreferredActionServletMapping(IVirtualComponent webComponent) {
        String servletMapping = null;
        WebArtifactEdit webArtifactEdit = null;
        try {
            webArtifactEdit = Model2Util.getWebArtifactEdit((IVirtualComponent)webComponent, (boolean)true);
            if (webArtifactEdit == null) {
                return null;
            }
            Servlet actionServlet = this.getStrutsActionServlet(webArtifactEdit);
            if (actionServlet == null) {
                return null;
            }
            try {
                List mappings = actionServlet.getMappings();
                ServletMapping mapping = StrutsConfigFileIdentifier.getPreferredServletMappingFromList(mappings);
                if (mapping != null) {
                    servletMapping = mapping.getUrlPattern();
                }
            }
            catch (Exception e) {
                StrutsPlugin.getLogger().log((Throwable)e);
            }
        }
        finally {
            if (webArtifactEdit != null) {
                webArtifactEdit.dispose();
            }
            webArtifactEdit = null;
        }
        return servletMapping;
    }

    @Override
    public Object getStrutsActionServlet(IVirtualComponent webComponent) {
        Servlet result = null;
        WebArtifactEdit webArtifactEdit = Model2Util.getWebArtifactEdit((IVirtualComponent)webComponent, (boolean)true);
        if (webArtifactEdit != null) {
            try {
                result = this.getStrutsActionServlet(webArtifactEdit);
            }
            finally {
                webArtifactEdit.dispose();
            }
        }
        return result;
    }

    protected Servlet getStrutsActionServlet(WebArtifactEdit webArtifactEdit) {
        WebApp webApp = webArtifactEdit.getWebApp();
        if (webApp != null) {
            for (Servlet servlet : webApp.getServlets()) {
                if (!this.isActionServlet(servlet)) continue;
                return servlet;
            }
        }
        return null;
    }

    @Override
    public IFile[] getStrutsConfigFilesForModule(IVirtualComponent webComponent, String module) {
        IFile[] result = null;
        WebArtifactEdit webArtifactEdit = Model2Util.getWebArtifactEdit((IVirtualComponent)webComponent, (boolean)true);
        if (webArtifactEdit != null) {
            try {
                Servlet servlet = this.getStrutsActionServlet(webArtifactEdit);
                if (servlet != null) {
                    result = this.getAllStrutsConfigFilesForModule(servlet, webComponent, module);
                }
            }
            finally {
                webArtifactEdit.dispose();
            }
        }
        return result;
    }

    private HashMap getStrutsConfigInitParams(Servlet servlet) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry mapEntry : Model2Util.getServletInitParams((Servlet)servlet).entrySet()) {
            String paramValue = (String)mapEntry.getValue();
            String paramName = (String)mapEntry.getKey();
            if (WizardUtils.isEmpty((String)paramName)) continue;
            String string = paramValue = paramValue == null ? "" : paramValue;
            if (paramName.equals("config")) {
                Object hashValue = paramValue;
                if (paramValue.indexOf(",") >= 0) {
                    hashValue = Model2Util.cds2List((String)paramValue);
                }
                result.put("", hashValue);
                continue;
            }
            if (!paramName.startsWith(MODULE_CONFIG_PREFIX)) continue;
            String moduleName = paramName.substring("config".length());
            result.put(moduleName, paramValue);
        }
        if (!result.containsKey("")) {
            result.put("", "/WEB-INF/struts-config.xml");
        }
        return result;
    }

    private IFile getWebXMLFile(IVirtualComponent webComponent) {
        WebArtifactEdit webArtifactEdit = Model2Util.getWebArtifactEdit((IVirtualComponent)webComponent, (boolean)true);
        if (webArtifactEdit == null) {
            return null;
        }
        return WorkbenchResourceHelper.getFile((Resource)webArtifactEdit.getDeploymentDescriptorResource());
    }

    @Override
    public boolean hasActionServletDefined(IVirtualComponent webComponent) {
        Object servlet = this.getStrutsActionServlet(webComponent);
        return servlet != null;
    }

    @Override
    public boolean isActionServlet(Servlet servlet) {
        if (servlet == null) {
            return false;
        }
        WebType webType = servlet.getWebType();
        if (webType != null && webType.isServletType()) {
            JavaClass actionServletClass;
            ServletType servletType = (ServletType)webType;
            String servletClassName = servletType.getClassName();
            if ("org.apache.struts.action.ActionServlet".equals(servletClassName)) {
                return true;
            }
            JavaClass servletClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(servletClassName, (EObject)servlet);
            if (servletClass != null && (actionServletClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType("org.apache.struts.action.ActionServlet", (EObject)servlet)) != null && servletClass.inheritsFrom(actionServletClass)) {
                return true;
            }
        }
        return false;
    }
}

